/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.FloatValidator;
import edu.stanford.smi.protege.util.IntegerValidator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.NumberValidator;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;

public class SlotValuesWidget
extends AbstractListWidget {
    private static final long serialVersionUID = 103665542520867791L;
    private Action _viewAction;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private Action _removeAction;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            super.templateFacetValueChanged(clsEvent);
            if (clsEvent.getFacet().getName().equals(":VALUE-TYPE")) {
                SlotValuesWidget.this.updateButtons();
            }
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            if (frameEvent.getSlot().getName().equals(":SLOT-VALUE-TYPE")) {
                SlotValuesWidget.this.updateButtons();
            }
        }
    };

    private Collection addItems() {
        Collection<String> collection = null;
        ValueType valueType = this.getCurrentType();
        if (SlotValuesWidget.equals(valueType, ValueType.CLS)) {
            Collection collection2 = this.getAllowedParents();
            collection = DisplayUtilities.pickClses((Component)this, this.getKnowledgeBase(), collection2);
        } else if (SlotValuesWidget.equals(valueType, ValueType.INSTANCE)) {
            Collection collection3 = this.getAllowedClses();
            collection = DisplayUtilities.pickInstances((Component)this, this.getKnowledgeBase(), collection3);
        } else if (SlotValuesWidget.equals(valueType, ValueType.SYMBOL)) {
            collection = CollectionUtilities.createCollection(this.editSymbol(null));
        } else {
            Log.getLogger().warning("bad type: " + valueType);
        }
        return collection;
    }

    private Boolean editBoolean(Object object) {
        List<Object> list = Arrays.asList("true", "false");
        String string = object == null ? (String)null : object.toString();
        string = this.editSymbol(string, list);
        return string == null ? null : new Boolean(string);
    }

    private Object editItem(Object object) {
        Object object2;
        ValueType valueType = this.getCurrentType();
        if (SlotValuesWidget.equals(valueType, ValueType.BOOLEAN)) {
            object2 = this.editBoolean(object);
        } else if (SlotValuesWidget.equals(valueType, ValueType.CLS)) {
            this.showInstance((Instance)object);
            object2 = object;
        } else if (SlotValuesWidget.equals(valueType, ValueType.FLOAT)) {
            object2 = this.editText("Float", object, FloatValidator.getInstance());
        } else if (SlotValuesWidget.equals(valueType, ValueType.INSTANCE)) {
            if (object == null) {
                Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), this.getAllowedClses());
                object2 = cls.createDirectInstance(null);
                this.showInstance((Instance)object2);
            } else {
                this.showInstance((Instance)object);
                object2 = object;
            }
        } else if (SlotValuesWidget.equals(valueType, ValueType.INTEGER)) {
            object2 = this.editText("Integer", object, IntegerValidator.getInstance());
        } else if (SlotValuesWidget.equals(valueType, ValueType.STRING)) {
            object2 = this.editText("String", object, null);
        } else if (SlotValuesWidget.equals(valueType, ValueType.SYMBOL)) {
            object2 = this.editSymbol(object);
        } else {
            Log.getLogger().warning("bad type: " + valueType);
            object2 = object;
        }
        return object2;
    }

    private String editSymbol(Object object) {
        return this.editSymbol((String)object, this.getAllowedValues());
    }

    private String editSymbol(String string, Collection collection) {
        return (String)DisplayUtilities.pickSymbol(this, "Value", string, collection);
    }

    private Object editText(String string, Object object, NumberValidator numberValidator) {
        String string2 = DisplayUtilities.editString(this, string + " Value", object, numberValidator);
        Object object2 = string2 == null ? null : (numberValidator == null ? string2 : numberValidator.convertToNumber(string2));
        return object2;
    }

    private Action getAddAction() {
        this._addAction = new AddAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -8390731086548880897L;

            public void onAdd() {
                Collection collection = SlotValuesWidget.this.addItems();
                if (collection != null) {
                    SlotValuesWidget.this.addItems(collection);
                }
            }
        };
        return this._addAction;
    }

    private Slot getSlotInstance() {
        return (Slot)this.getInstance();
    }

    private Collection getAllowedClses() {
        Slot slot = this.getSlotInstance();
        Collection collection = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedClses(slot) : slot.getAllowedClses();
        return this.rootCollection(collection);
    }

    private Collection getAllowedParents() {
        Slot slot = this.getSlotInstance();
        Collection collection = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedParents(slot) : slot.getAllowedParents();
        return this.rootCollection(collection);
    }

    private Collection getAllowedValues() {
        Slot slot = this.getSlotInstance();
        Collection collection = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedValues(slot) : slot.getAllowedValues();
        return collection;
    }

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -4397623316890492860L;

            public void onCreate() {
                Object object = SlotValuesWidget.this.editItem(null);
                if (object != null) {
                    SlotValuesWidget.this.addItem(object);
                }
            }
        };
        return this._createAction;
    }

    private ValueType getCurrentType() {
        Slot slot = this.getSlotInstance();
        ValueType valueType = slot == null ? ValueType.ANY : (this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotValueType(slot) : slot.getValueType());
        return valueType;
    }

    private Action getEditAction() {
        this._viewAction = new ViewAction((Selectable)this){
            private static final long serialVersionUID = -7273113512035501651L;

            public void onView(Object object) {
                Object object2 = SlotValuesWidget.this.editItem(object);
                if (!object.equals(object2)) {
                    SlotValuesWidget.this.replaceItem(object, object2);
                }
            }
        };
        return this._viewAction;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -2334952871995157304L;

            public void onRemove(Collection collection) {
                SlotValuesWidget.this.removeItems(collection);
            }
        };
        return this._removeAction;
    }

    public void initialize() {
        Action action = this.getEditAction();
        super.initialize(action);
        this.addButton(action);
        this.addButton(this.getCreateAction());
        this.addButton(this.getAddAction());
        this.addButton(this.getRemoveAction());
        this.updateButtons();
    }

    private boolean isEditable() {
        Slot slot = this.getSlotInstance();
        boolean bl = slot == null ? false : (this.isSlotAtCls() ? this.getAssociatedCls().isEditable() : slot.isEditable());
        bl = bl && !this.isReadOnlyConfiguredWidget();
        return bl;
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-VALUES");
    }

    private Collection rootCollection(Collection collection) {
        return collection.isEmpty() ? this.getKnowledgeBase().getRootClses() : collection;
    }

    public void setInstance(Instance instance) {
        Instance instance2 = this.getInstance();
        if (instance2 != null) {
            instance2.removeFrameListener(this._frameListener);
        }
        super.setInstance(instance);
        if (instance != null) {
            instance.addFrameListener(this._frameListener);
        }
    }

    public void setAssociatedCls(Cls cls) {
        Cls cls2 = this.getAssociatedCls();
        if (cls2 != null) {
            cls2.removeClsListener(this._clsListener);
        }
        super.setAssociatedCls(cls);
        if (cls != null) {
            cls.addClsListener(this._clsListener);
        }
    }

    public void setValues(Collection collection) {
        super.setValues(collection);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean bl;
        ValueType valueType = this.getCurrentType();
        boolean bl2 = bl = SlotValuesWidget.equals(valueType, ValueType.INSTANCE) || SlotValuesWidget.equals(valueType, ValueType.CLS) || SlotValuesWidget.equals(valueType, ValueType.SYMBOL);
        this._addAction.setAllowed(bl2 && this.isEditable());
        boolean bl3 = !SlotValuesWidget.equals(valueType, ValueType.ANY) && !bl;
        this._createAction.setAllowed(bl3 && this.isEditable());
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Template Values", ResourceKey.TEMPLATE_VALUES_SLOT_WIDGET_LABEL);
    }
}

