/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.EditableJavaCodeGeneratorOptions;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeGeneratorPanel
extends JPanel {
    private static final Color DISABLED_COLOR = new Color(240, 240, 240);
    private KnowledgeBase kb;
    private Collection<Cls> clses = new HashSet<Cls>();
    private JTextField factoryClassNameTextField;
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableJavaCodeGeneratorOptions options;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;
    private JCheckBox setCheckBox;
    private LabeledComponent lcClasses;
    private SelectableList clsesList;
    private JRadioButton generateAllClses;
    private JRadioButton generateSelectedClses;
    private JCheckBox generateDependentClasses;

    public JavaCodeGeneratorPanel(KnowledgeBase knowledgeBase, EditableJavaCodeGeneratorOptions editableJavaCodeGeneratorOptions) {
        this.kb = knowledgeBase;
        this.options = editableJavaCodeGeneratorOptions;
        this.packageTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getPackage() != null) {
            this.packageTextField.setText(editableJavaCodeGeneratorOptions.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getOutputFolder() != null) {
            this.rootFolderTextField.setText(editableJavaCodeGeneratorOptions.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.factoryClassNameTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getFactoryClassName() != null) {
            this.factoryClassNameTextField.setText(editableJavaCodeGeneratorOptions.getFactoryClassName());
        }
        this.setCheckBox = new JCheckBox("Return Set instead of Collection");
        this.setCheckBox.setSelected(editableJavaCodeGeneratorOptions.getSetMode());
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent labeledComponent = new LabeledComponent("Root output folder", this.rootFolderTextField);
        labeledComponent.addHeaderButton(new AbstractAction("Select folder...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaCodeGeneratorPanel.this.selectFolder();
            }
        });
        this.add(labeledComponent);
        this.add(Box.createVerticalStrut(8));
        this.add(new LabeledComponent("Java package", this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(new LabeledComponent("Factory class name", this.factoryClassNameTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.setCheckBox));
        this.add(Box.createVerticalStrut(8));
        this.lcClasses = this.createClsesPanel();
        this.add(this.lcClasses);
        this.generateAllClses.setSelected(true);
        this.clsesList.setBackground(DISABLED_COLOR);
        this.generateAllClses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaCodeGeneratorPanel.this.updateClassRadioButtons();
            }
        });
        this.generateSelectedClses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaCodeGeneratorPanel.this.updateClassRadioButtons();
            }
        });
        this.add(Box.createVerticalStrut(8));
    }

    private void updateClassRadioButtons() {
        this.clsesList.setBackground(this.generateAllClses.isSelected() ? DISABLED_COLOR : Color.WHITE);
        this.generateDependentClasses.setEnabled(!this.generateAllClses.isSelected());
        this.generateDependentClasses.setSelected(!this.generateAllClses.isSelected());
    }

    private LabeledComponent createClsesPanel() {
        this.clsesList = ComponentFactory.createSelectableList(null);
        this.clsesList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.addListValues(this.clsesList, this.clses);
        LabeledComponent labeledComponent = new LabeledComponent("", new JScrollPane(this.clsesList), true);
        labeledComponent.addHeaderButton(new AllowableAction("Add classes", Icons.getAddClsIcon(), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                HashSet<Cls> hashSet = new HashSet<Cls>();
                for (Object object2 : JavaCodeGeneratorPanel.this.kb.getClses()) {
                    if (object2.isSystem()) continue;
                    hashSet.add((Cls)object2);
                }
                hashSet.add(JavaCodeGeneratorPanel.this.kb.getRootCls());
                object2 = DisplayUtilities.pickClses((Component)JavaCodeGeneratorPanel.this, JavaCodeGeneratorPanel.this.kb, "Select classes (multiple selection)");
                this.addClsesIfNotExists((Collection<Cls>)object2);
                ComponentUtilities.clearListValues(JavaCodeGeneratorPanel.this.clsesList);
                ComponentUtilities.addListValues(JavaCodeGeneratorPanel.this.clsesList, JavaCodeGeneratorPanel.this.clses);
                if (object2.size() > 0) {
                    JavaCodeGeneratorPanel.this.generateSelectedClses.setSelected(true);
                    JavaCodeGeneratorPanel.this.clsesList.setBackground(Color.WHITE);
                }
            }

            private void addClsesIfNotExists(Collection<Cls> collection) {
                for (Cls cls : collection) {
                    if (JavaCodeGeneratorPanel.this.clses.contains(cls)) continue;
                    JavaCodeGeneratorPanel.this.clses.add(cls);
                }
            }
        });
        labeledComponent.addHeaderButton(new AllowableAction("Remove class", Icons.getRemoveClsIcon(), (Selectable)this.clsesList){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = this.getSelection();
                if (collection != null) {
                    JavaCodeGeneratorPanel.this.clses.removeAll(collection);
                }
                ComponentUtilities.clearListValues(JavaCodeGeneratorPanel.this.clsesList);
                ComponentUtilities.addListValues(JavaCodeGeneratorPanel.this.clsesList, JavaCodeGeneratorPanel.this.clses);
                if (JavaCodeGeneratorPanel.this.clses.size() == 0) {
                    JavaCodeGeneratorPanel.this.generateAllClses.setSelected(true);
                    JavaCodeGeneratorPanel.this.clsesList.setBackground(Color.LIGHT_GRAY);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.generateAllClses = new JRadioButton("all classes");
        this.generateSelectedClses = new JRadioButton("selected classes");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.generateAllClses);
        buttonGroup.add(this.generateSelectedClses);
        jPanel.add(this.generateAllClses);
        jPanel.add(this.generateSelectedClses);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = ComponentFactory.createLabel();
        ComponentUtilities.setSmallLabelFont(jLabel);
        jLabel.setText("Generate classes for:");
        jPanel2.add(jLabel);
        jPanel2.add(jPanel);
        this.generateDependentClasses = new JCheckBox("Generate dependent classes");
        this.generateDependentClasses.setEnabled(false);
        labeledComponent.setHeaderComponent(jPanel2);
        labeledComponent.setFooterComponent(this.generateDependentClasses);
        return labeledComponent;
    }

    private JPanel createCheckBoxPanel(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", component);
        jPanel.add("Center", new JPanel());
        jPanel.setPreferredSize(new Dimension(300, 24));
        return jPanel;
    }

    public void ok() {
        File file = null;
        String string = this.rootFolderTextField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        this.options.setOutputFolder(file);
        this.options.setSetMode(this.setCheckBox.isSelected());
        this.options.setFactoryClassName(this.factoryClassNameTextField.getText());
        String string2 = this.packageTextField.getText().trim();
        this.options.setPackage(string2.length() > 0 ? string2 : null);
        this.options.setClses(this.getClses());
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    public Collection<Cls> getClses() {
        ArrayList<Cls> arrayList;
        HashSet<Cls> hashSet = new HashSet<Cls>();
        hashSet.addAll(this.clses);
        if (this.clses.size() == 0) {
            for (Cls cls : this.kb.getClses()) {
                if (cls.isSystem()) continue;
                hashSet.add(cls);
            }
        }
        if (this.generateDependentClasses.isSelected()) {
            arrayList = new HashSet();
            this.getDependentClasses(this.clses, arrayList);
            hashSet.addAll(arrayList);
        }
        arrayList = new ArrayList<Cls>(hashSet);
        Collections.sort(arrayList, new FrameComparator());
        return arrayList;
    }

    private void getDependentClasses(Collection<Cls> collection, Collection<Cls> collection2) {
        for (Cls cls : collection) {
            Collection<Slot> collection3 = cls.getTemplateSlots();
            for (Slot slot : collection3) {
                ValueType valueType = slot.getValueType();
                HashSet<Cls> hashSet = new HashSet<Cls>();
                if (valueType == ValueType.INSTANCE) {
                    hashSet.addAll(cls.getTemplateSlotAllowedClses(slot));
                } else if (valueType == ValueType.CLS) {
                    hashSet.addAll(cls.getTemplateSlotAllowedParents(slot));
                }
                hashSet.removeAll(collection2);
                collection2.addAll(hashSet);
                this.getDependentClasses(hashSet, collection2);
            }
        }
    }
}

