/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.FrameWithBrowserTextComparator;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetOwnSlotValuesBrowserTextJob
extends ProtegeJob {
    private static final long serialVersionUID = 2958930580121193877L;
    protected Frame frame;
    protected Slot slot;
    protected boolean directValues = false;

    public GetOwnSlotValuesBrowserTextJob(KnowledgeBase knowledgeBase, Frame frame, Slot slot, boolean bl) {
        super(knowledgeBase);
        this.frame = frame;
        this.slot = slot;
        this.directValues = bl;
    }

    @Override
    public Collection<FrameWithBrowserText> run() throws ProtegeException {
        ArrayList<FrameWithBrowserText> arrayList = new ArrayList<FrameWithBrowserText>();
        this.addRequestsToFrameCalculator(this.frame);
        Collection collection = this.getValues();
        for (Object e : collection) {
            if (e instanceof Frame) {
                Frame frame = (Frame)e;
                arrayList.add(new FrameWithBrowserText(frame, frame.getBrowserText(), ((Instance)frame).getDirectTypes()));
                this.addRequestsToFrameCalculator(frame);
                continue;
            }
            arrayList.add(new FrameWithBrowserText(null, e.toString(), null));
        }
        Collections.sort(arrayList, new FrameWithBrowserTextComparator());
        return arrayList;
    }

    protected Collection getValues() {
        return this.directValues ? this.frame.getDirectOwnSlotValues(this.slot) : this.frame.getOwnSlotValues(this.slot);
    }

    private void addRequestsToFrameCalculator(Frame frame) {
        if (!this.getKnowledgeBase().getProject().isMultiUserServer()) {
            return;
        }
        Server server = Server.getInstance();
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = server.getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(remoteSession);
        FrameCalculator frameCalculator = serverFrameStore.getFrameCalculator();
        frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
    }

    @Override
    public Collection<FrameWithBrowserText> execute() throws ProtegeException {
        return (Collection)super.execute();
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        LocalizeUtils.localize(this.frame, knowledgeBase);
        LocalizeUtils.localize(this.slot, knowledgeBase);
    }
}

