/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacketHeader {
    private static Logger log = Log.getLogger(PacketHeader.class);
    public static byte[] ALIGNMENT = new byte[]{76, 58, 116, 88};
    private static int BYTES_IN_INT = 4;
    private static int BITS_IN_BYTE = 8;
    private static int BYTE_MASK = 255;
    private int size;
    private int compressedSize;

    public PacketHeader(int n, int n2) {
        this.size = n;
        this.compressedSize = n2;
    }

    public static PacketHeader read(InputStream inputStream) throws IOException {
        for (byte by : ALIGNMENT) {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("No packet found");
            }
            if ((byte)n == by) continue;
            throw new IOException("Packet header out of alignment between reader and writer (Thread = " + Thread.currentThread().getName() + ")");
        }
        int n = PacketHeader.readInt(inputStream);
        int n2 = PacketHeader.readInt(inputStream);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Read compressed packet header, size = " + n + " compressed size = " + n2);
        }
        return new PacketHeader(n, n2);
    }

    public void write(OutputStream outputStream) throws IOException {
        for (byte by : ALIGNMENT) {
            outputStream.write(by);
        }
        PacketHeader.writeInt(outputStream, this.size);
        PacketHeader.writeInt(outputStream, this.compressedSize);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Wrote compressed packet header, size = " + this.size + " compressed size = " + this.compressedSize);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    private static int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int[] nArray = new int[BYTES_IN_INT];
        for (n2 = 0; n2 < BYTES_IN_INT; ++n2) {
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException("Could not read compressed packet header");
            }
            nArray[n2] = n;
        }
        for (n2 = BYTES_IN_INT - 1; n2 >= 0; --n2) {
            n3 <<= BITS_IN_BYTE;
            n = nArray[n2];
            n3 += n < 0 ? 256 + n : n;
        }
        return n3;
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        for (int i = 0; i < BYTES_IN_INT - 1; ++i) {
            outputStream.write(n & BYTE_MASK);
            n >>= BITS_IN_BYTE;
        }
        outputStream.write(n);
    }
}

