/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege;

import edu.stanford.smi.protege.exception.ModificationException;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.SplashScreen;
import edu.stanford.smi.protege.ui.WelcomeDialog;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Application {
    private static transient Logger log = Log.getLogger(Application.class);
    private static JFrame _mainFrame;
    private static SplashScreen _splashScreen;
    private static WelcomeDialog _welcome;
    private static final String projectFileExtension = ".pprj";
    private static final String propertyOptionsPrefix = "-prop";
    private static final String serverPropertyOptionsPrefix = "-server";
    private static final String serverUserProperty = "-server.user";
    private static final String serverPasswordProperty = "-server.password";
    private static final String serverHostProperty = "-server.host";
    private static final String serverprojectProperty = "-server.project";

    private static void initialize() {
        try {
            SystemUtilities.initGraphics();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", exception);
        }
    }

    public static Component getMainWindow() {
        Window window = _splashScreen != null ? _splashScreen : _mainFrame;
        return window;
    }

    private static URI getProjectURI(String[] stringArray) {
        URI uRI = null;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            if (string.startsWith(propertyOptionsPrefix) || string.startsWith(serverPropertyOptionsPrefix)) {
                return null;
            }
            if (!string.endsWith(projectFileExtension)) {
                string = string + projectFileExtension;
            }
            uRI = URIUtilities.createURI(string);
        }
        return uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(String[] stringArray) {
        Object object;
        Application.parseOptions(stringArray);
        _mainFrame = ComponentFactory.createMainFrame();
        _mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjectManager.getProjectManager().exitApplicationRequest();
            }
        });
        Application.restoreMainframeRectangle();
        ProjectManager.getProjectManager().setRootPane(_mainFrame.getRootPane());
        Project project = null;
        if (stringArray.length > 0) {
            object = stringArray[0];
            boolean bl = false;
            try {
                bl = new File((String)object).exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                int n = ((String)object).lastIndexOf(46);
                if (n > 0 && n < ((String)object).length() - 1 && !((String)object).endsWith(projectFileExtension)) {
                    String string = ((String)object).substring(n + 1);
                    Iterator iterator = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames().iterator();
                    while (iterator.hasNext() && project == null) {
                        Class clazz = (Class)iterator.next();
                        project = Application.useCreateProjectFromFilePlugin(clazz, string, (String)object);
                        if (project == null) continue;
                        String string2 = ((String)object).substring(0, n) + projectFileExtension;
                        project.setProjectFilePath(string2);
                        ProjectManager.getProjectManager().setCurrentProject(project, false);
                    }
                }
            } else {
                boolean bl2 = false;
                try {
                    project = Application.getRemoteProject(stringArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl2 = true;
                }
                if (project == null && !bl2) {
                    return;
                }
            }
        }
        if (project != null) {
            Application.showMainFrame();
        } else {
            object = Application.getProjectURI(stringArray);
            if (object != null) {
                try {
                    ProjectManager.getProjectManager().loadProject((URI)object);
                }
                finally {
                    Application.showMainFrame();
                }
            } else {
                Application.showMainFrame();
                if (!SystemUtilities.isApplet()) {
                    String string = ApplicationProperties.getString("ui.welcomedialog.start.in.server.panel", "false");
                    if (string.equalsIgnoreCase("true")) {
                        ProjectManager.getProjectManager().openRemoteProjectRequest();
                    } else if (ApplicationProperties.getWelcomeDialogShow()) {
                        _welcome = new WelcomeDialog(_mainFrame, "Welcome to " + Text.getProgramName(), true);
                        _welcome.setLocationRelativeTo(_mainFrame);
                        _welcome.setVisible(true);
                    }
                } else {
                    ProjectManager.getProjectManager().openRemoteProjectRequest();
                }
            }
        }
    }

    private static Project getRemoteProject(String[] stringArray) {
        Project project = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            try {
                if (string5.startsWith(serverHostProperty)) {
                    string = Application.extractValue(string5);
                    continue;
                }
                if (string5.startsWith(serverUserProperty)) {
                    string2 = Application.extractValue(string5);
                    continue;
                }
                if (string5.startsWith(serverPasswordProperty)) {
                    string3 = Application.extractValue(string5);
                    continue;
                }
                if (!string5.startsWith(serverprojectProperty)) continue;
                string4 = Application.extractValue(string5);
                continue;
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.WARNING, "Error at parsing argument: " + string5 + ". This argument will be ignored.", throwable);
            }
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException("Insufficient arguments");
        }
        project = ProjectManager.getProjectManager().openRemoteProjectRequest(string, string2, string3, string4);
        if (project == null) {
            Application.showMainFrame();
            MessageError messageError = new MessageError("Loading remote project " + string4 + " from server " + string + " failed.\n" + "Please check your username and password and try again.");
            ProjectManager.getProjectManager().displayErrors("Could not load remote project " + string4, CollectionUtilities.createCollection(messageError));
        }
        return project;
    }

    private static String extractValue(String string) {
        int n = string.indexOf("=");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        return null;
    }

    public static Project useCreateProjectFromFilePlugin(Class clazz, String string, String string2) {
        if (clazz != null) {
            try {
                CreateProjectFromFilePlugin createProjectFromFilePlugin;
                Object t = clazz.newInstance();
                if (t instanceof CreateProjectFromFilePlugin && PluginUtilities.isSuitableCreateProjectFromFilePlugin(createProjectFromFilePlugin = (CreateProjectFromFilePlugin)t, string)) {
                    File file = new File(string2);
                    ArrayList arrayList = new ArrayList();
                    Project project = createProjectFromFilePlugin.createProject(file, arrayList);
                    Log.handleErrors(log, Level.WARNING, arrayList);
                    return project;
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Warning: Failed handle argument with " + clazz, exception);
            }
        }
        return null;
    }

    public static WelcomeDialog getWelcomeDialog() {
        return _welcome;
    }

    private static void restoreMainframeRectangle() {
        ApplicationProperties.restoreMainFrameProperties(_mainFrame);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Dimension dimension = _mainFrame.getSize();
        dimension.width = Math.min(dimension.width, rectangle.width);
        dimension.height = Math.min(dimension.height, rectangle.height);
        _mainFrame.setSize(dimension);
        Point point = _mainFrame.getLocation();
        point.x = Math.max(rectangle.x, point.x);
        point.y = Math.max(rectangle.y, point.y);
        _mainFrame.setLocation(point);
    }

    public static void main(final String[] stringArray) {
        ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Safe Thread Group"){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.getLogger().log(Level.SEVERE, "Uncaught Exception", throwable);
                Application.handleModificationException(throwable);
            }
        };
        Thread thread = new Thread(threadGroup, "Safe Main Thread"){

            public void run() {
                try {
                    Application.realmain(stringArray);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        SystemUtilities.sleepMsec(5000);
    }

    public static void realmain(String[] stringArray) {
        Application.initialize();
        _splashScreen = new SplashScreen();
        try {
            Application.init(stringArray);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", exception);
        }
        _splashScreen.dispose();
        _splashScreen = null;
    }

    private static void parseOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                int n;
                if (!string.startsWith(propertyOptionsPrefix) || (n = string.indexOf("=")) == -1) continue;
                String string2 = string.substring(5, n);
                String string3 = string.substring(n + 1);
                ApplicationProperties.setString(string2, string3);
                continue;
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.WARNING, "Error at parsing or setting application property: " + string + ". This option will be ignored.", throwable);
            }
        }
    }

    public static void repaint() {
        if (_mainFrame != null) {
            _mainFrame.repaint();
        }
    }

    private static void showMainFrame() {
        _splashScreen.setVisible(false);
        _mainFrame.setVisible(true);
        ProjectManager.getProjectManager().bringErrorFrameToFront();
    }

    public static void shutdown() {
        _mainFrame.dispatchEvent(new WindowEvent(_mainFrame, 201));
    }

    private static boolean handleModificationException(Throwable throwable) {
        boolean bl = false;
        for (Throwable throwable2 = throwable; !bl && throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof ModificationException)) continue;
            if (_mainFrame != null) {
                ModalDialog.showMessageDialog((Component)_mainFrame, "You do not have permission to make this modification.", "Write error");
            }
            bl = true;
            break;
        }
        return bl;
    }
}

