/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.AbstractWidget;
import edu.stanford.smi.protege.widget.TabWidget;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTabWidget
extends AbstractWidget
implements TabWidget {
    private static final long serialVersionUID = 6679591990743134105L;
    private Icon _icon;
    private String _label;
    private String _shortDescription;
    private JTree _clsTree;
    private Selectable _instanceSelectable;

    public JButton addMainWindowToolBarButton(Action action) {
        JButton jButton;
        JToolBar jToolBar = this.getMainWindowToolBar();
        if (jToolBar == null) {
            Log.getLogger().warning("Cannot find window tool bar");
            jButton = null;
        } else {
            jButton = ComponentFactory.addToolBarButton(jToolBar, action);
        }
        return jButton;
    }

    public void setLabel(String string) {
        this._label = string;
    }

    public String getLabel() {
        return this._label == null ? super.getLabel() : this._label;
    }

    public static boolean isSuitable(Project project, Collection collection) {
        return true;
    }

    public boolean canClose() {
        return true;
    }

    public boolean canSave() {
        return true;
    }

    protected JSplitPane createLeftRightSplitPane(String string, int n) {
        JSplitPane jSplitPane = ComponentFactory.createLeftRightSplitPane();
        this.setSplitPane(jSplitPane, string, n);
        return jSplitPane;
    }

    protected JSplitPane createTopBottomSplitPane(String string, int n) {
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane();
        this.setSplitPane(jSplitPane, string, n);
        return jSplitPane;
    }

    public Icon getIcon() {
        return this._icon;
    }

    protected JMenuBar getMainWindowMenuBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMenuBar();
    }

    protected JToolBar getMainWindowToolBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMainToolBar();
    }

    protected JToolBar getUserToolBar(String string) {
        return ProjectManager.getProjectManager().getUserToolBar(string);
    }

    protected void addUserToolBar(JToolBar jToolBar) {
        ProjectManager.getProjectManager().addUserToolBar(jToolBar);
    }

    protected void removeUserToolBar(JToolBar jToolBar) {
        ProjectManager.getProjectManager().removeUserToolBar(jToolBar);
    }

    public void removeMainWindowToolBarButton(JButton jButton) {
        JToolBar jToolBar = this.getMainWindowToolBar();
        if (jToolBar != null) {
            jToolBar.remove(jButton);
        }
    }

    public void save() {
    }

    public void close() {
    }

    public String getShortDescription() {
        return this._shortDescription;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    private void setSplitPane(JSplitPane jSplitPane, String string, int n) {
    }

    public boolean configure() {
        ModalDialog.showMessageDialog(this, "No configuration options are available for this tab.");
        return true;
    }

    public void setup(WidgetDescriptor widgetDescriptor, Project project) {
        super.setup(widgetDescriptor, false, project);
    }

    public void setShortDescription(String string) {
        this._shortDescription = string;
    }

    protected void setClsTree(JTree jTree) {
        this._clsTree = jTree;
        this._clsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                AbstractTabWidget.this.notifySelectionListeners();
            }
        });
        if (this.getProject().isMultiUserClient()) {
            this._clsTree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                }

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    final WaitCursor waitCursor = new WaitCursor((JTree)treeExpansionEvent.getSource());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Toolkit.getDefaultToolkit().sync();
                            waitCursor.hide();
                        }
                    });
                }
            });
        }
    }

    protected void setInstanceSelectable(Selectable selectable) {
        this._instanceSelectable = selectable;
        this._instanceSelectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                AbstractTabWidget.this.notifySelectionListeners();
            }
        });
    }

    public Collection getSelectedInstances() {
        return this._instanceSelectable == null ? null : this._instanceSelectable.getSelection();
    }

    public JTree getClsTree() {
        return this._clsTree;
    }

    public Collection getSelection() {
        if (this._clsTree == null) {
            return Collections.EMPTY_LIST;
        }
        TreePath treePath = this._clsTree.getSelectionPath();
        return treePath == null ? Collections.EMPTY_LIST : ComponentUtilities.getObjectPath(treePath);
    }

    public void synchronizeClsTree(Collection collection) {
        if (this._clsTree != null) {
            ComponentUtilities.setSelectedObjectPath(this._clsTree, collection);
        }
    }

    public void synchronizeToInstances(Collection collection) {
        if (this._instanceSelectable instanceof JList) {
            JList jList = (JList)((Object)this._instanceSelectable);
            ComponentUtilities.setSelectedValues(jList, collection);
        }
    }
}

