/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.storage.database.RobustConnection;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.logging.Level;

public class RawDb_Test
extends APITestCase {
    private Random r = new Random();

    private RobustConnection createRobustConnection() throws SQLException {
        return new RobustConnection(RawDb_Test.getDBProperty("driver"), RawDb_Test.getDBProperty("url"), RawDb_Test.getDBProperty("user"), RawDb_Test.getDBProperty("password"), new SillyTransactionStatusMonitor(), null);
    }

    public void testCaseSensitivity() {
        try {
            for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
                RawDb_Test.setDBType(dBType);
                if (!RawDb_Test.dbConfigured()) continue;
                RobustConnection robustConnection = this.createRobustConnection();
                Statement statement = robustConnection.getStatement();
                try {
                    robustConnection.getStatement().executeUpdate("DROP TABLE test");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.createFrameNameTable(robustConnection, statement);
                statement.executeUpdate("INSERT INTO test VALUES ('aa')");
                statement.executeUpdate("INSERT INTO test VALUES ('aA')");
                statement.executeUpdate("INSERT INTO test VALUES ('Aa')");
                statement.executeUpdate("INSERT INTO test VALUES ('AA')");
                ResultSet resultSet = statement.executeQuery("SELECT str FROM test WHERE  str = 'aa'");
                boolean bl = false;
                while (resultSet.next()) {
                    if (resultSet.getString(1).equals("aa")) {
                        bl = true;
                        continue;
                    }
                    RawDb_Test.fail((String)("database column " + robustConnection.getFrameNameType() + " is not case sensitive."));
                }
                if (bl) continue;
                RawDb_Test.fail((String)"database query failed!");
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Exception caught", throwable);
            RawDb_Test.fail((String)throwable.getMessage());
        }
    }

    public void testMaxCharSize() {
        try {
            for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
                RawDb_Test.setDBType(dBType);
                if (!RawDb_Test.dbConfigured()) continue;
                RobustConnection robustConnection = this.createRobustConnection();
                Statement statement = robustConnection.getStatement();
                try {
                    statement.executeUpdate("DROP TABLE test");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.createShortValueTable(robustConnection, statement);
                int n = robustConnection.getMaxVarcharSize();
                String string = "hello";
                statement.executeUpdate("INSERT INTO test VALUES ('" + string + "')");
                String string2 = this.createRandomString(this.r.nextInt(n - 1) + 1);
                statement.executeUpdate("INSERT INTO test VALUES ('" + string2 + "')");
                String string3 = this.createRandomString(n);
                statement.executeUpdate("INSERT INTO test VALUES ('" + string3 + "')");
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                ResultSet resultSet = statement.executeQuery("select * from test");
                while (resultSet.next()) {
                    String string4 = resultSet.getString("str");
                    if (string4.equals(string)) {
                        bl = true;
                        continue;
                    }
                    if (string4.equals(string2)) {
                        bl2 = true;
                        continue;
                    }
                    if (string4.equals(string3)) {
                        bl3 = true;
                        continue;
                    }
                    RawDb_Test.fail((String)("shouldn't get " + string4));
                }
                RawDb_Test.assertTrue((bl && bl2 && bl3 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Exception caught", throwable);
            RawDb_Test.fail((String)throwable.getMessage());
        }
    }

    private void createFrameNameTable(RobustConnection robustConnection, Statement statement) throws SQLException {
        String string = "CREATE TABLE test ( str " + robustConnection.getFrameNameType() + ")";
        if (robustConnection.isMySql() && robustConnection.getDatabaseMajorVersion() == 5) {
            string = string + " ENGINE = INNODB";
        }
        statement.executeUpdate(string);
    }

    private void createShortValueTable(RobustConnection robustConnection, Statement statement) throws SQLException {
        String string = "CREATE TABLE test ( str " + robustConnection.getShortValueType() + ")";
        if (robustConnection.isMySql() && robustConnection.getDatabaseMajorVersion() == 5) {
            string = string + " ENGINE = INNODB";
        }
        statement.executeUpdate(string);
    }

    private String createRandomString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 97;
        }
        return new String(cArray);
    }

    private class SillyTransactionStatusMonitor
    extends TransactionMonitor {
        private TransactionIsolationLevel level = TransactionIsolationLevel.REPEATABLE_READ;

        private SillyTransactionStatusMonitor() {
        }

        public TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException {
            return this.level;
        }

        public void setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
            this.level = transactionIsolationLevel;
        }
    }
}

