/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ArchiveProject;
import edu.stanford.smi.protege.action.Clear;
import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.CreateProject;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.OpenProject;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.RevertProject;
import edu.stanford.smi.protege.action.SaveProject;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.StringUtilities;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ProjectToolBar
extends JToolBar {
    private static final long serialVersionUID = -252712597962765189L;

    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
        this.setRollover(true);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
        this.setAlignmentX(0.5f);
    }

    public ProjectToolBar() {
        this.addButton(new CreateProject(true));
        this.addButton(new OpenProject(true));
        this.addButton(new SaveProject(true));
        this.addSeparator();
        this.addButton(new Cut(true));
        this.addButton(new Copy(true));
        this.addButton(new Paste(true));
        this.addButton(new Clear(true));
        this.addSeparator();
        this.addButton(new ArchiveProject(true));
        this.addButton(new RevertProject(true));
        this.addSeparator();
        this.addButton(new UndoAction(true));
        this.addButton(new RedoAction(true));
        this.addSeparator();
    }

    public void addButton(Action action) {
        JButton jButton = ComponentFactory.addLargeToolBarButton(this, action);
        jButton.setFocusable(false);
    }

    public void addToggleButton(Action action) {
        ComponentFactory.addLargeToggleToolBarButton(this, action);
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

