/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatableReadCache<S, V, R>
implements Cache<S, V, R> {
    private Map<S, Map<V, CacheResult<R>>> repeatableReadCacheMap = new HashMap<S, Map<V, CacheResult<R>>>();
    private Cache<S, V, R> delegate;

    public RepeatableReadCache(Cache<S, V, R> cache) {
        this.delegate = cache;
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        Map<V, CacheResult<R>> map = this.repeatableReadCacheMap.get(s);
        if (map == null) {
            return this.delegate.readCache(s, v);
        }
        if (!map.containsKey(v)) {
            return new CacheResult<Object>(null, false);
        }
        return map.get(v);
    }

    @Override
    public void updateCache(S s, V v) {
        if (this.getTransactionNesting(s) == 0) {
            this.delegate.updateCache(s, v);
        }
    }

    @Override
    public void updateCache(S s, V v, R r) {
        Map<CacheResult<R>, CacheResult<R>> map = this.repeatableReadCacheMap.get(s);
        if (map != null) {
            map.put((CacheResult<R>)v, new CacheResult<R>(r, true));
        } else {
            this.delegate.updateCache(s, v, r);
        }
    }

    @Override
    public void modifyCache(S s, V v) {
        Map<V, CacheResult<R>> map = this.repeatableReadCacheMap.get(s);
        if (map != null) {
            map.remove(v);
        }
        this.delegate.modifyCache(s, v);
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        Map<CacheResult<R>, CacheResult<R>> map = this.repeatableReadCacheMap.get(s);
        if (map != null) {
            map.put((CacheResult<R>)v, new CacheResult<R>(r, true));
        }
        this.delegate.modifyCache(s, v, r);
    }

    @Override
    public void invalidate(S s) {
        this.delegate.invalidate(s);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S s) {
        if (this.getTransactionNesting(s) == 0) {
            this.repeatableReadCacheMap.put(s, new HashMap());
        }
        this.delegate.beginTransaction(s);
    }

    @Override
    public void commitTransaction(S s) {
        this.delegate.commitTransaction(s);
        this.decrementTransaction(s);
    }

    @Override
    public void rollbackTransaction(S s) {
        this.delegate.rollbackTransaction(s);
        this.decrementTransaction(s);
    }

    @Override
    public int getTransactionNesting(S s) {
        return this.delegate.getTransactionNesting(s);
    }

    @Override
    public void flush() {
        this.repeatableReadCacheMap.clear();
        this.delegate.flush();
    }

    private void decrementTransaction(S s) {
        if (this.getTransactionNesting(s) == 0) {
            this.repeatableReadCacheMap.remove(s);
        }
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

