/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.Policy_Test;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;

public class MetaProject_Test
extends SimpleTestCase {
    public static final String METAPROJECT = "junit/pprj/policy/metaproject.pprj";
    public static final String NATASHA = "Natasha Noy";
    public static final String NEWSPAPER = "Newspaper";
    public static final String NEW_USER_NAME = "MyUser";
    public static final String NEW_USER_PASS = "MyPassword";
    public static final String NEW_PROJECT_NAME = "MyProject";
    public static final String NEW_PROJECT_LOCATION = "in_same_directory.pprj";
    public static final String NEW_OPERATION_NAME = "MyOperation";
    public static final Operation ALT_READ = new UnbackedOperationImpl("AltRead", null);
    public static final String NEW_GROUP_NAME = "MyGroup";

    public void test_createUser() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        MetaProject_Test.assertNotNull((Object)metaProjectImpl.getUser(NATASHA));
        User user = metaProjectImpl.createUser(NEW_USER_NAME, NEW_USER_PASS);
        MetaProject_Test.assertTrue((boolean)metaProjectImpl.getUsers().contains(user));
        User user2 = metaProjectImpl.getUser(NEW_USER_NAME);
        MetaProject_Test.assertTrue((boolean)user2.equals(user));
    }

    public void test_createProject() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        ProjectInstance projectInstance = metaProjectImpl.createProject(NEW_PROJECT_NAME);
        MetaProject_Test.assertTrue((boolean)metaProjectImpl.getProjects().contains(projectInstance));
        MetaProject_Test.assertEquals((String)projectInstance.getName(), (String)NEW_PROJECT_NAME);
        ProjectInstance projectInstance2 = metaProjectImpl.getProject(NEW_PROJECT_NAME);
        MetaProject_Test.assertTrue((boolean)projectInstance2.equals(projectInstance));
        projectInstance.setLocation(NEW_PROJECT_LOCATION);
        MetaProject_Test.assertEquals((String)NEW_PROJECT_LOCATION, (String)projectInstance.getLocation());
        Log.getLogger().info("Create project: " + projectInstance.getName() + " in location: " + projectInstance.getLocation());
    }

    public void test_createOperation() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        Operation operation = metaProjectImpl.createOperation(NEW_OPERATION_NAME);
        MetaProject_Test.assertTrue((boolean)metaProjectImpl.getOperations().contains(operation));
        Operation operation2 = metaProjectImpl.getOperation(NEW_OPERATION_NAME);
        MetaProject_Test.assertTrue((boolean)operation2.equals(operation));
    }

    public void test_createGroup() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        Group group = metaProjectImpl.createGroup(NEW_GROUP_NAME);
        MetaProject_Test.assertTrue((boolean)metaProjectImpl.getGroups().contains(group));
        Group group2 = metaProjectImpl.getGroup(NEW_GROUP_NAME);
        MetaProject_Test.assertTrue((boolean)group2.equals(group));
        MetaProject_Test.assertTrue((boolean)metaProjectImpl.getGroups().contains(group));
        User user = metaProjectImpl.createUser(NEW_USER_NAME, NEW_USER_PASS);
        User user2 = metaProjectImpl.getUser(NATASHA);
        group.addMember(user);
        group.addMember(user2);
        MetaProject_Test.assertEquals((int)group.getMembers().size(), (int)2);
    }

    public void test_createPolicies() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        ProjectInstance projectInstance = metaProjectImpl.createProject(NEW_PROJECT_NAME);
        ProjectInstance projectInstance2 = metaProjectImpl.getProject(NEWSPAPER);
        projectInstance2.setAnnotationProject(projectInstance);
        MetaProject_Test.assertEquals((Object)projectInstance, (Object)projectInstance2.getAnnotationProject());
        User user = metaProjectImpl.createUser(NEW_USER_NAME, NEW_USER_PASS);
        User user2 = metaProjectImpl.getUser(NATASHA);
        Group group = metaProjectImpl.createGroup(NEW_GROUP_NAME);
        group.addMember(user);
        group.addMember(user2);
        Operation operation = metaProjectImpl.createOperation(NEW_OPERATION_NAME);
        GroupOperation groupOperation = metaProjectImpl.createGroupOperation();
        groupOperation.setAllowedGroup(group);
        groupOperation.addAllowedOperation(operation);
        groupOperation.addAllowedOperation(metaProjectImpl.getOperation(ALT_READ.getName()));
        MetaProject_Test.assertTrue((groupOperation.getAllowedOperations().size() == 2 ? 1 : 0) != 0);
        projectInstance.addAllowedGroupOperations(groupOperation);
        Policy policy = metaProjectImpl.getPolicy();
        Policy_Test.checkAuthorization(policy, user2, operation, projectInstance, true);
        Policy_Test.checkAuthorization(policy, user, operation, projectInstance, true);
        Policy_Test.checkAuthorization(policy, user, MetaProjectConstants.OPERATION_WRITE, projectInstance, false);
    }
}

