/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledComponent
extends JComponent {
    private static final long serialVersionUID = 5999709474215501024L;
    private List<Action> actions = new ArrayList<Action>();
    private JComponent _header;
    private JToolBar _toolBar;
    private JLabel _label;
    private JComponent _headerComponentHolder;
    private JComponent _centerComponentHolder;
    private JComponent _footerComponentHolder;
    private boolean _isVerticallyStretchable;
    private boolean _isSwapedHeader;

    public LabeledComponent(String string, Component component) {
        this(string, component, component instanceof JScrollPane);
    }

    public LabeledComponent(String string, Component component, boolean bl) {
        this(string, component, bl, false);
    }

    public LabeledComponent(String string, Component component, boolean bl, boolean bl2) {
        this._isSwapedHeader = bl2;
        this._isVerticallyStretchable = bl || component instanceof JScrollPane;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createHeader(), "North");
        this.add((Component)this.createCenterComponentHolder(), "Center");
        this.add((Component)this.createFooterComponentHolder(), "South");
        this.setHeaderLabel(string);
        this.setCenterComponent(component);
    }

    public LabeledComponent(String string, JScrollPane jScrollPane) {
        this(string, jScrollPane, true);
    }

    public JButton addHeaderButton(Action action) {
        JButton jButton = null;
        if (action != null) {
            this.actions.add(action);
            jButton = ComponentFactory.addToolBarButton(this._toolBar, action);
        }
        return jButton;
    }

    public void addHeaderSeparator() {
        this._toolBar.addSeparator();
    }

    public JToggleButton addHeaderToggleButton(Action action) {
        JToggleButton jToggleButton = null;
        if (action != null) {
            this.actions.add(action);
            jToggleButton = ComponentFactory.addToggleToolBarButton(this._toolBar, action);
        }
        return jToggleButton;
    }

    private JComponent createCenterComponentHolder() {
        this._centerComponentHolder = new JPanel();
        this._centerComponentHolder.setLayout(new BorderLayout());
        return this._centerComponentHolder;
    }

    private JComponent createFooterComponentHolder() {
        this._footerComponentHolder = new JPanel();
        this._footerComponentHolder.setLayout(new BorderLayout());
        return this._footerComponentHolder;
    }

    private JComponent createHeader() {
        this._header = new JPanel(){
            private static final long serialVersionUID = 7429097535969923450L;

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Math.max(dimension.height, 25);
                return dimension;
            }
        };
        this._header.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeaderLabel(), this._isSwapedHeader ? "East" : "West");
        jPanel.add((Component)this.createHeaderComponentHolder(), "Center");
        this._header.add((Component)jPanel, "Center");
        this._header.add((Component)this.createHeaderToolbar(), this._isSwapedHeader ? "West" : "East");
        return this._header;
    }

    private JComponent createHeaderComponentHolder() {
        this._headerComponentHolder = new JPanel();
        this._headerComponentHolder.setLayout(new BorderLayout());
        return this._headerComponentHolder;
    }

    private JComponent createHeaderLabel() {
        this._label = ComponentFactory.createLabel();
        ComponentUtilities.setSmallLabelFont(this._label);
        this._label.setBorder(BorderFactory.createEmptyBorder(0, 4, 2, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._label, "South");
        return jPanel;
    }

    private JComponent createHeaderToolbar() {
        this._toolBar = ComponentFactory.createToolBar();
        return this._toolBar;
    }

    public Component getCenterComponent() {
        int n = this._centerComponentHolder.getComponentCount();
        Component component = n == 0 ? null : this._centerComponentHolder.getComponent(0);
        return component;
    }

    public Component getFooterComponent() {
        int n = this._footerComponentHolder.getComponentCount();
        return n == 0 ? (Component)null : this._footerComponentHolder.getComponent(0);
    }

    public Collection<Action> getHeaderButtonActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    public Collection getHeaderButtons() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < this._toolBar.getComponentCount(); ++i) {
            Component component = this._toolBar.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    public boolean hasHeaderButton(Icon icon) {
        boolean bl = false;
        for (AbstractButton abstractButton : this.getHeaderButtons()) {
            if (!abstractButton.getIcon().equals(icon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Component getHeaderComponent() {
        int n = this._headerComponentHolder.getComponentCount();
        return n == 0 ? (Component)null : this._headerComponentHolder.getComponent(0);
    }

    public String getHeaderLabel() {
        return this._label.getText();
    }

    public void setComponentsEnabled(boolean bl) {
        this._label.setEnabled(bl);
        this.getCenterComponent().setEnabled(bl);
        this._toolBar.setEnabled(bl);
    }

    public boolean isVerticallyStretchable() {
        return this._isVerticallyStretchable;
    }

    public boolean isSwapedHeader() {
        return this._isSwapedHeader;
    }

    public void removeHeaderButton(int n) {
        int n2 = -1;
        for (int i = 0; i < this._toolBar.getComponentCount(); ++i) {
            Component component = this._toolBar.getComponent(i);
            if (!(component instanceof AbstractButton) || ++n2 != n) continue;
            this._toolBar.remove(component);
            break;
        }
    }

    public void removeAllHeaderButtons() {
        this._toolBar.removeAll();
    }

    public void setCenterComponent(Component component) {
        this._centerComponentHolder.removeAll();
        if (component != null) {
            String string = this._isVerticallyStretchable ? "Center" : "North";
            this._centerComponentHolder.add(component, string);
        }
        this.revalidate();
        this.repaint();
    }

    public void setFooterComponent(JComponent jComponent) {
        this._footerComponentHolder.removeAll();
        if (jComponent != null) {
            this._footerComponentHolder.add(jComponent);
        }
    }

    public void setHeaderComponent(JComponent jComponent) {
        this.setHeaderComponent(jComponent, "Center");
    }

    public void setHeaderComponent(JComponent jComponent, String string) {
        this._headerComponentHolder.removeAll();
        if (jComponent == null) {
            this._headerComponentHolder.setBorder(null);
        } else {
            this._headerComponentHolder.add((Component)jComponent, string);
            this._headerComponentHolder.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        }
    }

    public void setHeaderIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.adjustToolTipText();
    }

    private void adjustToolTipText() {
        if (this._header.getPreferredSize().width > this._header.getSize().width) {
            if (this._label.getToolTipText() == null) {
                this._label.setToolTipText(this._label.getText());
            }
        } else {
            this._label.setToolTipText(null);
        }
    }

    public void setHeaderLabel(String string) {
        this._label.setText(string);
        this._label.setVisible(string != null);
    }

    public void setVerticallyStretchable(boolean bl) {
        if (bl != this._isVerticallyStretchable) {
            this._isVerticallyStretchable = bl;
            this.setCenterComponent(this.getCenterComponent());
        }
    }
}

