/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Map;

public class LocalizeUtils {
    public static void localize(Object object, KnowledgeBase knowledgeBase) {
        if (object != null) {
            if (object instanceof Collection) {
                LocalizeUtils.localizeCollection((Collection)object, knowledgeBase);
            } else if (object instanceof Map) {
                LocalizeUtils.localizeMap((Map)object, knowledgeBase);
            } else if (object instanceof Localizable) {
                ((Localizable)object).localize(knowledgeBase);
            } else if (!(object instanceof Remote && object instanceof Proxy || LocalizeUtils.isPrimative(object))) {
                Log.getLogger().warning("Unhandled localization: " + object);
            }
        }
    }

    private static boolean isPrimative(Object object) {
        return object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Float;
    }

    private static void localizeCollection(Collection collection, KnowledgeBase knowledgeBase) {
        for (Object e : collection) {
            LocalizeUtils.localize(e, knowledgeBase);
        }
    }

    private static void localizeMap(Map map, KnowledgeBase knowledgeBase) {
        for (Map.Entry entry : map.entrySet()) {
            LocalizeUtils.localize(entry.getKey(), knowledgeBase);
            LocalizeUtils.localize(entry.getValue(), knowledgeBase);
        }
    }
}

