/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DoubleClickListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.ShowInstanceListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.AbstractWidget;
import edu.stanford.smi.protege.widget.ButtonConfigurationPanel;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public abstract class AbstractSlotWidget
extends AbstractWidget
implements SlotWidget {
    private static final long serialVersionUID = 1790525704709652862L;
    public static final String READ_ONLY_WIDGET_PROPERTY = "readOnly_configured";
    private Collection _buttonInfo;
    private Cls _cls;
    private Slot _slot;
    private Instance _instance;
    private Cls _associatedCls;
    private boolean _isBusy;
    private int _preferredColumns = 0;
    private int _preferredRows = 0;
    private static final int NORMAL_BORDER_SIZE = 5;
    private static final int SELECTED_BORDER_SIZE = 3;
    private static final Border NORMAL_BORDER;
    private DoubleClickListener _doubleClickListener;
    private ShowInstanceListener _showInstanceListener;
    private String TOOLTIP_TEXT_PROPERTY = "tooltip_text";
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (AbstractWidget.equals(clsEvent.getSlot(), AbstractSlotWidget.this.getSlot())) {
                AbstractSlotWidget.this.updateBorder(AbstractSlotWidget.this.getValues());
            }
        }
    };
    private ClsListener _associatedClsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (AbstractWidget.equals(clsEvent.getFacet(), AbstractSlotWidget.this._slot.getAssociatedFacet())) {
                AbstractSlotWidget.this.loadValues();
            }
        }
    };

    protected AbstractSlotWidget() {
        this.setNormalBorder();
    }

    public void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        if (this.getAssociatedCls() != null) {
            this.getAssociatedCls().removeClsListener(this._associatedClsListener);
        }
    }

    protected Action getDoubleClickAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -1888883411836752455L;

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSlotWidget.this.handleDoubleClick();
            }
        };
    }

    public static int getSelectionBorderSize() {
        return 3;
    }

    protected void handleDoubleClick() {
        Object x = CollectionUtilities.getFirstItem(this.getSelection());
        if (x != null) {
            if (this._doubleClickListener == null) {
                this.showInstance((Instance)x);
            } else {
                this._doubleClickListener.onDoubleClick(x);
            }
        }
    }

    public void setDoubleClickListener(DoubleClickListener doubleClickListener) {
        this._doubleClickListener = doubleClickListener;
    }

    public void setInvalidValueBorder() {
        this.setSelectedBorder(Color.red);
    }

    public void setNormalBorder() {
        this.setBorder(NORMAL_BORDER);
    }

    public void setSelectedBorder() {
        this.setSelectedBorder(Colors.getFormColor());
    }

    public void setSelectedBorder(Color color) {
        int n = 5;
        int n2 = 3;
        int n3 = n - n2;
        MatteBorder matteBorder = BorderFactory.createMatteBorder(n2, n2, n2, n2, color);
        Border border = BorderFactory.createEmptyBorder(n3, n3, n3, n3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, matteBorder);
        this.setBorder(compoundBorder);
    }

    public String getDefaultToolTip() {
        return this.getPropertyList().getString(this.TOOLTIP_TEXT_PROPERTY);
    }

    public void setDefaultToolTip(String string) {
        this.getPropertyList().setString(this.TOOLTIP_TEXT_PROPERTY, string);
    }

    protected void updateBorder(Collection collection) {
        String string = this.getDefaultToolTip();
        String string2 = null;
        Instance instance = this.getInstance();
        if (instance != null && (string2 = this.getKnowledgeBase().getInvalidOwnSlotValuesText(instance, this.getSlot(), collection)) != null) {
            string = string2;
        }
        this.setToolTipText(string);
        if (string2 == null) {
            this.setNormalBorder();
        } else {
            this.setInvalidValueBorder();
        }
        this.repaint();
    }

    public void setShowInstanceListener(ShowInstanceListener showInstanceListener) {
        this._showInstanceListener = showInstanceListener;
    }

    public void showInstance(Instance instance) {
        if (this._showInstanceListener == null) {
            super.showInstance(instance);
        } else {
            this._showInstanceListener.show(instance);
        }
    }

    public void addButtonConfiguration(Action action) {
        this.addButtonConfiguration(action, true);
    }

    public void addButtonConfiguration(Action action, boolean bl) {
        if (this._buttonInfo == null) {
            this._buttonInfo = new ArrayList();
        }
        this._buttonInfo.add(new ButtonInfo(action, bl));
        this.recordDefault(action, bl);
        String string = this.getButtonDescription(action);
        if (string != null) {
            action.putValue("ShortDescription", string);
        }
    }

    public boolean allowsMultipleValues() {
        boolean bl = this._associatedCls == null ? this._slot.getAllowsMultipleValues() : this._associatedCls.getTemplateSlotAllowsMultipleValues(this._slot);
        return bl;
    }

    public boolean configure() {
        WidgetConfigurationPanel widgetConfigurationPanel = this.createWidgetConfigurationPanel();
        int n = ModalDialog.showDialog(this, widgetConfigurationPanel, "Configure " + this.getLabel(), 11, null, false);
        return n == 1;
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = new WidgetConfigurationPanel(this);
        if (this._buttonInfo != null) {
            ButtonConfigurationPanel buttonConfigurationPanel = new ButtonConfigurationPanel(this.getPropertyList());
            widgetConfigurationPanel.addTab("Buttons", buttonConfigurationPanel);
            for (ButtonInfo buttonInfo : this._buttonInfo) {
                String string = (String)buttonInfo.action.getValue("Name");
                String string2 = (String)buttonInfo.action.getValue("ShortDescription");
                buttonConfigurationPanel.addButton(string, string2, buttonInfo.defaultState);
            }
        }
        return widgetConfigurationPanel;
    }

    protected boolean displayButton(String string) {
        Boolean bl = this.getPropertyList().getBoolean(string);
        return bl == null ? true : bl;
    }

    public boolean displayButton(Action action) {
        Boolean bl = this.getPropertyList().getBoolean(AbstractSlotWidget.getDisplayPropertyName(action));
        return bl == null ? true : bl;
    }

    public Cls getAssociatedCls() {
        return this._associatedCls;
    }

    public String getButtonDescription(Action action) {
        return this.getPropertyList().getString(ButtonConfigurationPanel.getDescriptionPropertyName((String)action.getValue("Name")));
    }

    public Cls getCls() {
        return this._cls;
    }

    private static String getDisplayPropertyName(Action action) {
        return ButtonConfigurationPanel.getDisplayPropertyName((String)action.getValue("Name"));
    }

    public static Object getFirstItem(Collection collection) {
        return CollectionUtilities.getFirstItem(collection);
    }

    protected String getInvalidValueText(Collection collection) {
        int n = collection.size();
        int n2 = this.getMinimumCardinality();
        int n3 = this.getMaximumCardinality();
        String string = n < n2 ? (n3 == 1 ? "Value is required" : "At least " + n2 + " value" + (n2 == 1 ? " is" : "s are") + " required") : (n3 != -1 && n > n3 ? "At most " + n3 + " values are allowed" : null);
        return string;
    }

    public String getLabel() {
        String string = super.getLabel();
        if (string == null) {
            string = this.getDefaultLabel();
        }
        return string;
    }

    protected String getDefaultLabel() {
        Slot slot = this.getSlot();
        String string = slot.getBrowserText();
        if (this.getProject().getPrettyPrintSlotWidgetLabels()) {
            string = StringUtilities.symbolToLabel(string);
        }
        return string;
    }

    protected int getMaximumCardinality() {
        return this.getCls().getTemplateSlotMaximumCardinality(this.getSlot());
    }

    protected int getMinimumCardinality() {
        return this.getCls().getTemplateSlotMinimumCardinality(this.getSlot());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this._preferredColumns > 0) {
            dimension.width = this._preferredColumns * ComponentUtilities.getStandardColumnWidth();
        }
        if (this._preferredRows > 0) {
            dimension.height = this._preferredRows * ComponentUtilities.getStandardRowHeight();
        }
        return dimension;
    }

    public Slot getSlot() {
        return this._slot;
    }

    public boolean isSlotAtCls() {
        return this._associatedCls != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValues() {
        if (this.getInstance() != null && !this._isBusy) {
            this._isBusy = true;
            try {
                this.setWidgetValues();
            }
            finally {
                this._isBusy = false;
            }
        }
    }

    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.isDesignTime()) {
            this.getDescriptor().setBounds(this.getBounds());
        }
    }

    private void recordDefault(Action action, boolean bl) {
        boolean bl2;
        String string = AbstractSlotWidget.getDisplayPropertyName(action);
        Boolean bl3 = this.getPropertyList().getBoolean(string);
        boolean bl4 = bl2 = bl3 == null && !bl;
        if (bl2) {
            this.getPropertyList().setBoolean(string, bl);
        }
    }

    protected static void setAllowed(AllowableAction allowableAction, boolean bl) {
        if (allowableAction != null) {
            allowableAction.setAllowed(bl);
        }
    }

    public void setAssociatedCls(Cls cls) {
        if (this._associatedCls == null && cls == null || this._associatedCls != null && this._associatedCls.equals(cls)) {
            return;
        }
        if (this._associatedCls != null) {
            this._associatedCls.removeClsListener(this._associatedClsListener);
        }
        this._associatedCls = cls;
        if (this._associatedCls != null) {
            this._associatedCls.addClsListener(this._associatedClsListener);
        }
        this.loadValues();
    }

    public void setCls(Cls cls) {
        this._cls = cls;
    }

    public void setEditable(boolean bl) {
    }

    public void setInstance(Instance instance) {
        this._instance = instance;
        this.loadValues();
    }

    public void setInstanceValues() {
        if (this._slot != null) {
            ArrayList arrayList = new ArrayList(this.getValues());
            if (this._associatedCls == null) {
                ArrayList arrayList2 = new ArrayList(this._instance.getOwnSlotValues(this._slot));
                List list = this._instance.getDirectOwnSlotValues(this._slot);
                arrayList2.removeAll(list);
                arrayList.removeAll(arrayList2);
                this._instance.setDirectOwnSlotValues(this._slot, arrayList);
            } else {
                Slot slot = (Slot)this._instance;
                this._associatedCls.setTemplateFacetValues(slot, this._slot.getAssociatedFacet(), arrayList);
            }
            this.updateBorder(arrayList);
        }
    }

    protected boolean isDirectValue(Object object) {
        boolean bl = this._associatedCls == null ? this._instance.getDirectOwnSlotValues(this._slot).contains(object) : true;
        return bl;
    }

    protected boolean areDirectValues(Collection collection) {
        boolean bl;
        if (this._associatedCls == null) {
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(this._instance.getDirectOwnSlotValues(this._slot));
            bl = hashSet.isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    public void setPreferredColumns(int n) {
        this._preferredColumns = n;
    }

    public void setPreferredRows(int n) {
        this._preferredRows = n;
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this._preferredColumns = 0;
        this._preferredRows = 0;
    }

    public void setSlot(Slot slot) {
        this._slot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged() {
        if (this._instance != null && !this._isBusy) {
            this._isBusy = true;
            try {
                this.setInstanceValues();
            }
            finally {
                this._isBusy = false;
            }
        }
    }

    public void setup(WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls, Slot slot) {
        super.setup(widgetDescriptor, bl, project);
        this._cls = cls;
        this._slot = slot;
        this._cls.addClsListener(this._clsListener);
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            this.setPreferredSize(dimension);
        }
    }

    public void setWidgetValues() {
        Collection collection;
        if (this._associatedCls == null) {
            collection = new ArrayList(this._instance.getOwnSlotValues(this._slot));
            boolean bl = this._instance.isEditable();
            this.setEditable(bl &= this._slot.getValueType() == ValueType.CLS || this._instance.getOwnSlotAllowsMultipleValues(this._slot) || this._instance.getDirectType().getTemplateSlotValues(this._slot).isEmpty());
        } else {
            Slot slot = (Slot)this._instance;
            Facet facet = this._slot.getAssociatedFacet();
            if (facet == null) {
                collection = Collections.EMPTY_LIST;
                this.setEditable(false);
            } else {
                collection = this._associatedCls.getTemplateFacetValues(slot, facet);
                boolean bl = this._associatedCls.isEditable();
                this.setEditable(bl);
            }
        }
        try {
            this.setValues(collection);
            this.updateBorder(collection);
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.toString() + " at setting the widget values for instance " + this._instance + " and " + this._slot);
            this.setValues(Collections.EMPTY_LIST);
        }
    }

    public Instance getInstance() {
        return this._instance;
    }

    public void setValues(Collection collection) {
    }

    public Collection getValues() {
        return Collections.EMPTY_LIST;
    }

    public ClsWidget getClsWidget() {
        return (ClsWidget)((Object)this.getParent());
    }

    protected String localizeStandardLabel(String string, String string2, ResourceKey resourceKey) {
        if (string.equals(string2) || string.equals(this.getDefaultLabel())) {
            string = LocalizedText.getText(resourceKey);
        }
        return string;
    }

    public boolean isReadOnlyConfiguredWidget() {
        Boolean bl = this.getPropertyList().getBoolean(READ_ONLY_WIDGET_PROPERTY);
        return bl == null ? false : bl;
    }

    public void setReadOnlyWidget(boolean bl) {
        this.getPropertyList().setBoolean(READ_ONLY_WIDGET_PROPERTY, bl);
    }

    static {
        int n = 5;
        NORMAL_BORDER = BorderFactory.createEmptyBorder(n, n, n, n);
    }

    private static class ButtonInfo {
        Action action;
        boolean defaultState;

        ButtonInfo(Action action, boolean bl) {
            this.action = action;
            this.defaultState = bl;
        }
    }
}

