/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGeneratorFrameStore
extends ModificationFrameStore {
    private List<AbstractEvent> _events = new ArrayList<AbstractEvent>();
    private DefaultKnowledgeBase _kb;
    private SystemFrames _systemFrames;
    private boolean generateEventsOnDeletingFrames = false;
    private TransactionMonitor transactionMonitor;
    private boolean inReplaceFrameOperation = false;

    public EventGeneratorFrameStore(KnowledgeBase knowledgeBase) {
        this._kb = (DefaultKnowledgeBase)knowledgeBase;
        this._systemFrames = this._kb.getSystemFrames();
    }

    @Override
    public void setDelegate(FrameStore frameStore) {
        super.setDelegate(frameStore);
        if (frameStore != null) {
            this.transactionMonitor = frameStore.getTransactionStatusMonitor();
        }
    }

    @Override
    public void reinitialize() {
        this._events.clear();
    }

    @Override
    public void close() {
        super.close();
        this._events.clear();
        this._events = null;
        this._kb = null;
        this._systemFrames = null;
    }

    @Override
    public Frame getFrame(String string) {
        return this.getDelegate().getFrame(string);
    }

    @Override
    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
        this.generateCreateClsEvents(cls, collection, transactionIsolationLevel);
        return cls;
    }

    @Override
    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
        this.generateCreateSlotEvents(slot, collection, transactionIsolationLevel);
        return slot;
    }

    @Override
    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
        this.generateCreateFacetEvents(facet, collection, transactionIsolationLevel);
        return facet;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateSetDirectOwnSlotValuesEvents(frame, slot, collection, transactionIsolationLevel);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
    }

    private void generateSetDirectOwnSlotValuesEvents(Frame frame, Slot slot, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateOwnSlotValuesChangedEvent(frame, slot, transactionIsolationLevel);
        this.generateFrameEvent(105, frame, transactionIsolationLevel);
        Slot slot2 = (Slot)CollectionUtilities.getFirstItem(this.getDirectOwnSlotValues(slot, this._systemFrames.getInverseSlotSlot()));
        if (slot2 != null) {
            List list = this.getDirectOwnSlotValues(frame, slot);
            for (Frame frame2 : collection) {
                if (list.contains(frame2)) continue;
                this.generateFrameEvent(110, frame2, slot2, transactionIsolationLevel);
            }
            for (Frame frame2 : list) {
                if (collection.contains(frame2)) continue;
                this.generateFrameEvent(110, frame2, slot2, transactionIsolationLevel);
            }
        }
    }

    private void generateDeleteFrameKbEvent(int n, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateKbEvent(n, frame, frame.getName(), transactionIsolationLevel);
    }

    private void generateDeleteClsEvents(Cls cls, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateDeleteFrameKbEvent(602, cls, transactionIsolationLevel);
        for (Cls cls2 : this.getDirectSuperclasses(cls)) {
            this.generateClsEvent(304, cls2, cls, transactionIsolationLevel);
        }
        this.generateDeleteInstanceEvents(cls, transactionIsolationLevel);
    }

    private void generateDeleteSimpleInstanceEvents(SimpleInstance simpleInstance, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateDeleteFrameKbEvent(608, simpleInstance, transactionIsolationLevel);
        this.generateDeleteInstanceEvents(simpleInstance, transactionIsolationLevel);
    }

    private void generateDeleteSlotEvents(Slot slot, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateDeleteFrameKbEvent(604, slot, transactionIsolationLevel);
        for (Frame frame : this.getDelegate().getFramesWithDirectOwnSlotValue(this._systemFrames.getDirectTemplateSlotsSlot(), slot)) {
            if (!(frame instanceof Cls)) continue;
            this.generateClsEvent(309, (Cls)frame, slot, transactionIsolationLevel);
        }
        for (Frame frame : this.getDirectSuperslots(slot)) {
            this.generateSlotEvent(408, slot, frame, transactionIsolationLevel);
        }
        this.generateDeleteInstanceEvents(slot, transactionIsolationLevel);
    }

    private void generateDeleteFacetEvents(Facet facet, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateDeleteFrameKbEvent(606, facet, transactionIsolationLevel);
        this.generateDeleteInstanceEvents(facet, transactionIsolationLevel);
    }

    private void generateDeleteInstanceEvents(Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateRemoveDirectInstanceEvents(instance, transactionIsolationLevel);
        for (Reference reference : this.getReferences(instance)) {
            this.removeReference(reference, instance, transactionIsolationLevel);
        }
        this.generateFrameEvent(102, instance, instance.getName(), transactionIsolationLevel);
    }

    private void generateRemoveDirectInstanceEvents(Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
        for (Cls cls : this.getDirectTypes(instance)) {
            this.generateClsEvent(306, cls, instance, transactionIsolationLevel);
        }
    }

    private void removeReference(Reference reference, Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
        Frame frame = reference.getFrame();
        Slot slot = reference.getSlot();
        Facet facet = reference.getFacet();
        boolean bl = reference.isTemplate();
        this.removeReference(frame, slot, facet, bl, instance, transactionIsolationLevel);
    }

    private void removeReference(Frame frame, Slot slot, Facet facet, boolean bl, Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
        if (facet == null) {
            if (bl) {
                this.removeTemplateSlotValueReference(frame, slot, instance, transactionIsolationLevel);
            } else {
                this.removeOwnSlotValueReference(frame, slot, instance, transactionIsolationLevel);
            }
        } else if (bl) {
            this.removeTemplateFacetValueReference(frame, slot, facet, instance, transactionIsolationLevel);
        }
    }

    private void removeOwnSlotValueReference(Frame frame, Slot slot, Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateFrameEvent(110, frame, slot, transactionIsolationLevel);
    }

    private void removeTemplateSlotValueReference(Frame frame, Slot slot, Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
    }

    private void removeTemplateFacetValueReference(Frame frame, Slot slot, Facet facet, Instance instance, TransactionIsolationLevel transactionIsolationLevel) {
    }

    @Override
    public void deleteCls(Cls cls) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateDeleteClsEvents(cls, transactionIsolationLevel);
        this.getDelegate().deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateDeleteSlotEvents(slot, transactionIsolationLevel);
        this.getDelegate().deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateDeleteFacetEvents(facet, transactionIsolationLevel);
        this.getDelegate().deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateDeleteSimpleInstanceEvents(simpleInstance, transactionIsolationLevel);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
        this.generateCreateSimpleInstanceEvents(simpleInstance, collection, transactionIsolationLevel);
        return simpleInstance;
    }

    private void generateCreateClsEvents(Cls cls, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateCreateInstanceEvents(601, cls, collection, transactionIsolationLevel);
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            this.generateClsEvent(303, cls2, cls, transactionIsolationLevel);
            this.generateOwnSlotValuesChangedEvent(cls2, this._systemFrames.getDirectSubclassesSlot(), transactionIsolationLevel);
        }
    }

    private void generateCreateFacetEvents(Facet facet, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateCreateInstanceEvents(605, facet, collection, transactionIsolationLevel);
    }

    private void generateCreateSlotEvents(Slot slot, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateCreateInstanceEvents(603, slot, collection, transactionIsolationLevel);
        for (Frame frame : this.getDelegate().getFramesWithDirectOwnSlotValue(this._systemFrames.getDirectTemplateSlotsSlot(), slot)) {
            if (!(frame instanceof Cls)) continue;
            this.generateClsEvent(308, (Cls)frame, slot, transactionIsolationLevel);
        }
        for (Frame frame : slot.getDirectSuperslots()) {
            this.generateSlotEvent(405, (Slot)frame, slot, transactionIsolationLevel);
            this.generateOwnSlotValuesChangedEvent(frame, this._systemFrames.getDirectSubslotsSlot(), transactionIsolationLevel);
        }
    }

    private void generateCreateSimpleInstanceEvents(SimpleInstance simpleInstance, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateCreateInstanceEvents(607, simpleInstance, collection, transactionIsolationLevel);
    }

    private void generateCreateInstanceEvents(int n, Frame frame, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateKbEvent(n, frame, transactionIsolationLevel);
        for (Cls cls : collection) {
            this.generateClsEvent(305, cls, frame, transactionIsolationLevel);
            this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectInstancesSlot(), transactionIsolationLevel);
        }
    }

    private void generateReplacedFrameEvents(Frame frame, Frame frame2, TransactionIsolationLevel transactionIsolationLevel) {
        String string = frame.getName();
        this.generateFrameEvent(101, frame, string, frame2, transactionIsolationLevel);
        this.generateKbEvent(101, frame, string, frame2);
    }

    private void generateReplacingFrameEvents(Frame frame, Frame frame2, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateReplacingFrameAsValueEvents(frame, frame2, transactionIsolationLevel);
        if (frame instanceof Slot) {
            this.generateReplacingSlotEvents((Slot)frame, transactionIsolationLevel);
        }
    }

    private void generateReplacingFrameAsValueEvents(Frame frame, Frame frame2, TransactionIsolationLevel transactionIsolationLevel) {
        Set<Reference> set = this.getDelegate().getReferences(frame);
        if (set == null) {
            return;
        }
        for (Reference reference : set) {
            if (reference.isTemplate()) continue;
            Frame frame3 = reference.getFrame();
            Slot slot = reference.getSlot();
            Collection collection = this.getDelegate().getOwnSlotValues(frame3, slot);
            if (collection == null || !collection.contains(frame)) continue;
            ArrayList<Frame> arrayList = new ArrayList<Frame>(collection);
            arrayList.remove(frame);
            arrayList.add(frame2);
            this.generateFrameEvent(110, frame3, slot, arrayList, transactionIsolationLevel);
        }
    }

    private void generateReplacingSlotEvents(Slot slot, TransactionIsolationLevel transactionIsolationLevel) {
        Set<Frame> set = this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
        if (set == null) {
            return;
        }
        for (Frame frame : set) {
            this.generateFrameEvent(110, frame, slot, transactionIsolationLevel);
        }
    }

    private void generateKbEvent(int n, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, n, frame), transactionIsolationLevel);
    }

    private void generateKbEvent(int n, Frame frame, String string, TransactionIsolationLevel transactionIsolationLevel) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, n, frame, (Object)string), transactionIsolationLevel);
    }

    private void generateKbEvent(int n, Frame frame, String string, Frame frame2) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, n, frame, (Object)string, (Object)frame2));
    }

    private boolean generateEvent(Frame frame) {
        return !frame.isBeingDeleted() || this.generateEventsOnDeletingFrames;
    }

    private void generateFrameEvent(int n, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateFrameEvent(n, frame, null, null, transactionIsolationLevel);
    }

    private void generateFrameEvent(int n, Frame frame, Object object, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateFrameEvent(n, frame, object, null, transactionIsolationLevel);
    }

    private void generateFrameEvent(int n, Frame frame, Object object, Object object2, TransactionIsolationLevel transactionIsolationLevel) {
        if (this.generateEvent(frame)) {
            this.addEvent(new FrameEvent(frame, n, object, object2), transactionIsolationLevel);
        }
    }

    private void generateClsEvent(int n, Cls cls, Frame frame, Frame frame2, TransactionIsolationLevel transactionIsolationLevel) {
        if (this.generateEvent(cls)) {
            this.addEvent(new ClsEvent(cls, n, (Object)frame, (Object)frame2), transactionIsolationLevel);
        }
    }

    private void generateClsEvent(int n, Cls cls, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateClsEvent(n, cls, frame, null, transactionIsolationLevel);
    }

    private void generateSlotEvent(int n, Slot slot, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        if (this.generateEvent(slot)) {
            this.addEvent(new SlotEvent(slot, n, frame), transactionIsolationLevel);
        }
    }

    private void generateInstanceEvent(int n, Instance instance, Frame frame, TransactionIsolationLevel transactionIsolationLevel) {
        if (this.generateEvent(instance)) {
            this.addEvent(new InstanceEvent(instance, n, (Object)frame), transactionIsolationLevel);
        }
    }

    @Override
    public List<AbstractEvent> getEvents() {
        List<AbstractEvent> list = this._events;
        this._events = new ArrayList<AbstractEvent>();
        return list;
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        Collection collection = this.getSlotsToBeAdded(cls, cls2);
        this.getDelegate().addDirectSuperclass(cls, cls2);
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateClsEvent(301, cls, cls2, transactionIsolationLevel);
        this.generateClsEvent(303, cls2, cls, transactionIsolationLevel);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 308, collection, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, cls2, this._systemFrames.getDirectSuperclassesSlot(), transactionIsolationLevel);
    }

    private Collection getSlotsToBeAdded(Cls cls, Cls cls2) {
        HashSet hashSet = new HashSet(this.getTemplateSlots(cls2));
        hashSet.removeAll(this.getTemplateSlots(cls));
        return hashSet;
    }

    private void generateSuperclassTemplateSlotChangedEvents(Cls cls, int n, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        for (Slot slot : collection) {
            this.generateClsEvent(n, cls, slot, transactionIsolationLevel);
        }
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Frame frame2, Slot slot, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateOwnSlotValuesChangedEvent(frame, slot, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent(frame2, slot.getInverseSlot(), transactionIsolationLevel);
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot, TransactionIsolationLevel transactionIsolationLevel) {
        ArrayList arrayList = null;
        if (this.getValues(frame, slot)) {
            arrayList = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        }
        this.generateOwnSlotValuesChangedEvent(frame, slot, arrayList, transactionIsolationLevel);
    }

    private boolean getValues(Frame frame, Slot slot) {
        return !slot.equals(this._systemFrames.getDirectSubclassesSlot()) && !slot.equals(this._systemFrames.getDirectInstancesSlot());
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot, Collection collection, TransactionIsolationLevel transactionIsolationLevel) {
        this.generateFrameEvent(110, frame, slot, collection, transactionIsolationLevel);
        for (Slot slot2 : slot.getSuperslots()) {
            this.generateFrameEvent(110, frame, slot2, collection, transactionIsolationLevel);
        }
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        HashSet<Slot> hashSet = new HashSet<Slot>(cls.getTemplateSlots());
        this.getDelegate().removeDirectSuperclass(cls, cls2);
        hashSet.removeAll(cls.getTemplateSlots());
        this.generateClsEvent(302, cls, cls2, transactionIsolationLevel);
        this.generateClsEvent(304, cls2, cls, transactionIsolationLevel);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 309, hashSet, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, cls2, this._systemFrames.getDirectSuperclassesSlot(), transactionIsolationLevel);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
        this.generateOwnSlotValuesChangedEvent(frame, slot, transactionIsolationLevel);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
        this.generateClsEvent(307, cls, cls2, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectSubclassesSlot(), transactionIsolationLevel);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
        this.generateSlotEvent(409, slot, slot2, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent(slot, this._systemFrames.getDirectSubslotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectSuperslot(slot, slot2);
        this.generateSlotEvent(407, slot, slot2, transactionIsolationLevel);
        this.generateSlotEvent(405, slot2, slot, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)slot2, this._systemFrames.getDirectSuperslotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectSuperslot(slot, slot2);
        this.generateSlotEvent(408, slot, slot2, transactionIsolationLevel);
        this.generateSlotEvent(406, slot2, slot, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)slot2, this._systemFrames.getDirectSuperslotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectType(instance, cls);
        this.generateInstanceEvent(202, instance, cls, transactionIsolationLevel);
        this.generateClsEvent(305, cls, instance, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, cls, this._systemFrames.getDirectTypesSlot(), transactionIsolationLevel);
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectType(instance, cls);
        this.generateInstanceEvent(203, instance, cls, transactionIsolationLevel);
        this.generateClsEvent(306, cls, instance, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, cls, this._systemFrames.getDirectTypesSlot(), transactionIsolationLevel);
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectType(instance, cls, n);
        this.generateOwnSlotValuesChangedEvent(instance, this._systemFrames.getDirectTypesSlot(), transactionIsolationLevel);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.generateClsEvent(308, cls, slot, transactionIsolationLevel);
        this.generateSlotEvent(401, slot, cls, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.generateClsEvent(309, cls, slot, transactionIsolationLevel);
        this.generateSlotEvent(402, slot, cls, transactionIsolationLevel);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectTemplateSlotsSlot(), transactionIsolationLevel);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
        this.generateClsEvent(310, cls, slot, transactionIsolationLevel);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
        this.generateClsEvent(313, cls, slot, facet, transactionIsolationLevel);
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            this.generateClsEvent(313, cls, slot, facet, transactionIsolationLevel);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(701, string, Boolean.FALSE, transactionIsolationLevel);
        boolean bl = this.getDelegate().beginTransaction(string);
        return bl;
    }

    private void generateTransactionEvent(int n, String string, Boolean bl, TransactionIsolationLevel transactionIsolationLevel) {
        this.addEvent(new TransactionEvent(this._kb, n, string, bl), transactionIsolationLevel);
    }

    @Override
    public boolean commitTransaction() {
        boolean bl = this.getDelegate().commitTransaction();
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(702, null, bl, transactionIsolationLevel);
        return bl;
    }

    @Override
    public boolean rollbackTransaction() {
        boolean bl = this.getDelegate().rollbackTransaction();
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(702, null, Boolean.FALSE, transactionIsolationLevel);
        return bl;
    }

    public boolean setDeletingFrameEventsEnabled(boolean bl) {
        boolean bl2 = this.generateEventsOnDeletingFrames;
        this.generateEventsOnDeletingFrames = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        String string = frame2.getFrameID().getName();
        if (this.getFrame(string) != null) {
            return;
        }
        try {
            this.generateReplacedFrameEvents(frame, frame2, transactionIsolationLevel);
        }
        finally {
            this.inReplaceFrameOperation = false;
            this.getDelegate().replaceFrame(frame, frame2);
        }
    }

    public void addCustomEvent(AbstractEvent abstractEvent) {
        TransactionIsolationLevel transactionIsolationLevel = this.transactionMonitor == null ? null : this.transactionMonitor.getTransationIsolationLevel();
        boolean bl = TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel);
        abstractEvent.setHiddenByTransaction(!bl);
        this._events.add(abstractEvent);
    }

    private void addEvent(AbstractEvent abstractEvent, TransactionIsolationLevel transactionIsolationLevel) {
        if (this.inReplaceFrameOperation) {
            abstractEvent.setReplacementEvent(true);
        }
        this._events.add(abstractEvent);
        boolean bl = TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel);
        abstractEvent.setHiddenByTransaction(!bl);
    }

    private void addEvent(AbstractEvent abstractEvent) {
        this._events.add(abstractEvent);
    }

    private TransactionIsolationLevel getTransactionIsolationLevel() {
        if (this.transactionMonitor == null) {
            return TransactionIsolationLevel.NONE;
        }
        return this.transactionMonitor.getTransationIsolationLevel();
    }
}

