/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDbFactory;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.IdleConnectionNarrowFrameStore;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseKnowledgeBaseFactory
implements KnowledgeBaseFactory2 {
    public static final String DESCRIPTION = Text.getProgramName() + " Database";
    private boolean owlMode = false;

    @Override
    public KnowledgeBase createKnowledgeBase(Collection collection) {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase(this);
        return defaultKnowledgeBase;
    }

    public Class<? extends DatabaseFrameDb> getDatabaseFrameDbClass() {
        return DefaultDatabaseFrameDb.class;
    }

    @Override
    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        return new DatabaseKnowledgeBaseSourcesEditor(string, propertyList);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public static String getDriver(PropertyList propertyList) {
        return propertyList.getString(DatabaseProperty.DRIVER_PROPERTY.getName());
    }

    public static String getPassword(PropertyList propertyList) {
        return propertyList.getString(DatabaseProperty.PASSWORD_PROPERTY.getName());
    }

    @Override
    public String getProjectFilePath() {
        return null;
    }

    public static String getTableName(PropertyList propertyList) {
        return propertyList.getString(DatabaseProperty.TABLENAME_PROPERTY.getName());
    }

    public static String getURL(PropertyList propertyList) {
        return propertyList.getString(DatabaseProperty.URL_PROPERTY.getName());
    }

    public static String getUsername(PropertyList propertyList) {
        return propertyList.getString(DatabaseProperty.USERNAME_PROPERTY.getName());
    }

    @Override
    public void includeKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = DatabaseKnowledgeBaseFactory.getDriver(propertyList);
        String string2 = DatabaseKnowledgeBaseFactory.getURL(propertyList);
        if (string != null && string2 != null) {
            String string3 = DatabaseKnowledgeBaseFactory.getUsername(propertyList);
            String string4 = DatabaseKnowledgeBaseFactory.getPassword(propertyList);
            String string5 = DatabaseKnowledgeBaseFactory.getTableName(propertyList);
            this.includeKnowledgeBase(knowledgeBase, string, string2, string3, string4, string5, collection);
        }
    }

    @Override
    public boolean isComplete(PropertyList propertyList) {
        String string = DatabaseKnowledgeBaseFactory.getTableName(propertyList);
        String string2 = DatabaseKnowledgeBaseFactory.getURL(propertyList);
        String string3 = DatabaseKnowledgeBaseFactory.getDriver(propertyList);
        return string != null && string2 != null && string3 != null;
    }

    @Override
    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = DatabaseKnowledgeBaseFactory.getDriver(propertyList);
        String string2 = DatabaseKnowledgeBaseFactory.getURL(propertyList);
        if (string != null && string2 != null) {
            String string3 = DatabaseKnowledgeBaseFactory.getUsername(propertyList);
            String string4 = DatabaseKnowledgeBaseFactory.getPassword(propertyList);
            String string5 = DatabaseKnowledgeBaseFactory.getTableName(propertyList);
            this.loadKnowledgeBase(knowledgeBase, string, string2, string3, string4, string5, collection);
        }
    }

    public void includeKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, Collection collection) {
        try {
            this.initializeKB(knowledgeBase, string, string2, string3, string4, string5, true);
        }
        catch (Exception exception) {
            String string6 = "Unable to load included knowledgebase " + string2;
            Log.getLogger().log(Level.WARNING, string6, exception);
            collection.add(new MessageError(exception, string6));
        }
    }

    private static MergingNarrowFrameStore getMergingFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        return MergingNarrowFrameStore.get(defaultKnowledgeBase);
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, Collection collection) {
        try {
            this.initializeKB(knowledgeBase, string, string2, string3, string4, string5, false);
        }
        catch (Exception exception) {
            String string6 = "Unable to load knowledgebase " + string2;
            Log.getLogger().log(Level.WARNING, string6, exception);
            collection.add(new MessageError(exception, string6));
        }
    }

    @Override
    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        if (knowledgeBase instanceof DefaultKnowledgeBase) {
            DatabaseFrameDb databaseFrameDb = DatabaseKnowledgeBaseFactory.getDatabaseFrameDb(knowledgeBase);
            if (databaseFrameDb == null) {
                this.copyKnowledgeBase(knowledgeBase, propertyList, collection);
            } else if (!databaseFrameDb.getTableName().equals(DatabaseKnowledgeBaseFactory.getTableName(propertyList))) {
                this.copyKnowledgeBase(knowledgeBase, propertyList, collection);
            }
        } else {
            this.copyKnowledgeBase(knowledgeBase, propertyList, collection);
        }
    }

    protected static DatabaseFrameDb getDatabaseFrameDb(KnowledgeBase knowledgeBase) {
        NarrowFrameStore narrowFrameStore = MergingNarrowFrameStore.get(knowledgeBase);
        while ((narrowFrameStore = narrowFrameStore.getDelegate()) != null) {
            if (!(narrowFrameStore instanceof DatabaseFrameDb)) continue;
            return (DatabaseFrameDb)narrowFrameStore;
        }
        return null;
    }

    public static void setDriver(PropertyList propertyList, String string) {
        propertyList.setString(DatabaseProperty.DRIVER_PROPERTY.getName(), string);
    }

    public static void setPassword(PropertyList propertyList, String string) {
        propertyList.setString(DatabaseProperty.PASSWORD_PROPERTY.getName(), string);
    }

    public static void setTablename(PropertyList propertyList, String string) {
        propertyList.setString(DatabaseProperty.TABLENAME_PROPERTY.getName(), string);
    }

    public static void setURL(PropertyList propertyList, String string) {
        propertyList.setString(DatabaseProperty.URL_PROPERTY.getName(), string);
    }

    public static void setUsername(PropertyList propertyList, String string) {
        propertyList.setString(DatabaseProperty.USERNAME_PROPERTY.getName(), string);
    }

    public static void setSources(PropertyList propertyList, String string, String string2, String string3, String string4, String string5) {
        DatabaseKnowledgeBaseFactory.setDriver(propertyList, string);
        DatabaseKnowledgeBaseFactory.setURL(propertyList, string2);
        DatabaseKnowledgeBaseFactory.setTablename(propertyList, string3);
        DatabaseKnowledgeBaseFactory.setUsername(propertyList, string4);
        DatabaseKnowledgeBaseFactory.setPassword(propertyList, string5);
    }

    @Override
    public void prepareToSaveInFormat(KnowledgeBase knowledgeBase, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
    }

    @Override
    public NarrowFrameStore createNarrowFrameStore(String string) {
        DatabaseFrameDb databaseFrameDb = DatabaseFrameDbFactory.createDatabaseFrameDb(this.getDatabaseFrameDbClass());
        ValueCachingNarrowFrameStore valueCachingNarrowFrameStore = new ValueCachingNarrowFrameStore(databaseFrameDb);
        IdleConnectionNarrowFrameStore idleConnectionNarrowFrameStore = new IdleConnectionNarrowFrameStore(valueCachingNarrowFrameStore);
        idleConnectionNarrowFrameStore.setName(string);
        return idleConnectionNarrowFrameStore;
    }

    protected void initializeKB(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, boolean bl) {
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        FrameFactory frameFactory = defaultKnowledgeBase.getFrameFactory();
        DatabaseFrameDb databaseFrameDb = DatabaseKnowledgeBaseFactory.getDatabaseFrameDb(defaultKnowledgeBase);
        databaseFrameDb.initialize(frameFactory, string, string2, string3, string4, string5, bl);
        knowledgeBase.flushCache();
    }

    private void copyKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = DatabaseKnowledgeBaseFactory.getDriver(propertyList);
        String string2 = DatabaseKnowledgeBaseFactory.getURL(propertyList);
        String string3 = DatabaseKnowledgeBaseFactory.getUsername(propertyList);
        String string4 = DatabaseKnowledgeBaseFactory.getPassword(propertyList);
        String string5 = DatabaseKnowledgeBaseFactory.getTableName(propertyList);
        this.copyKnowledgeBase(knowledgeBase, string, string2, string3, string4, string5, collection);
    }

    private void copyKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, Collection collection) {
        try {
            DatabaseFrameDb databaseFrameDb = DatabaseFrameDbFactory.createDatabaseFrameDb(this.getDatabaseFrameDbClass());
            databaseFrameDb.initialize(knowledgeBase.getFrameFactory(), string, string2, string3, string4, string5, false);
            databaseFrameDb.overwriteKB(knowledgeBase, true);
            databaseFrameDb.close();
        }
        catch (Exception exception) {
            String string6 = "Errors at copying knowledgebase " + string2;
            Log.getLogger().log(Level.WARNING, string6, exception);
            collection.add(new MessageError(exception, string6));
        }
    }

    protected void setOwlMode(boolean bl) {
        this.owlMode = bl;
    }

    public boolean owlMode() {
        return this.owlMode;
    }
}

