/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;

public class Applet
extends JApplet {
    private static final long serialVersionUID = 7286186605066367207L;

    private String getProjectName() {
        return this.getParameter("project_name");
    }

    private URL getProjectURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBase(), this.getProjectName());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().severe(Log.toString(malformedURLException));
        }
        return uRL;
    }

    public void init() {
        try {
            SystemUtilities.initGraphics();
            SystemUtilities.setApplet(true);
            URL uRL = this.getProjectURL();
            this.setup(uRL);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            SystemUtilities.pause();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        Applet applet = new Applet();
        jFrame.getContentPane().add(applet);
        applet.setup(Applet.getURL(stringArray));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static URL getURL(String[] stringArray) {
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().severe(Log.toString(malformedURLException));
        }
        return uRL;
    }

    private void setup(final URL uRL) {
        JButton jButton = new JButton(Icons.getLogoBannerIcon());
        jButton.setFocusPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = uRL == null ? new String[]{} : new String[]{uRL.toString()};
                Application.main(stringArray);
            }
        });
        this.getContentPane().add(jButton);
    }
}

