/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceAdapter;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotAdapter;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.ui.FrameNameComparator;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public class DefaultKnowledgeBase_Test
extends APITestCase {
    public void testFilteredInverseSlotValueNotifications() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Slot slot2 = this.createSlotOnCls(cls);
        slot.setInverseSlot(slot2);
        slot.setAllowedClses(this.getDomainKB().getRootClses());
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        Instance instance4 = this.createInstance(cls);
        instance.setOwnSlotValues(slot, DefaultKnowledgeBase_Test.makeList(instance2, instance3));
        final Integer[] integerArray = new Integer[]{new Integer(0)};
        FrameAdapter frameAdapter = new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent frameEvent) {
                integerArray[0] = new Integer(integerArray[0] + 1);
            }
        };
        this.getDomainKB().addFrameListener(frameAdapter);
        instance.addOwnSlotValue(slot, instance4);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)integerArray[0]);
    }

    public void testGetOwnSlotValuesWithSubslotInCoreProtege() {
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot();
        slot2.addDirectSuperslot(slot);
        Instance instance = this.getDomainKB().getRootCls().createDirectInstance("Person");
        Instance instance2 = this.getDomainKB().getRootCls().createDirectInstance("Team");
        instance2.addOwnSlotValue(slot2, instance);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getOwnSlotValues(slot).size());
        instance2.addOwnSlotValue(slot, instance);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getDirectOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getDirectOwnSlotValues(slot2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)instance2.getOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getOwnSlotValues(slot2).size());
    }

    public void testInferredInverseSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Cls cls2 = this.createCls();
        Slot slot2 = this.createSlotOnCls(cls2);
        Instance instance = this.createInstance(cls2);
        slot2.setInverseSlot(slot);
        slot.setAllowedClses(DefaultKnowledgeBase_Test.makeList(cls2));
        cls.setTemplateSlotValues(slot, DefaultKnowledgeBase_Test.makeList(instance));
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(), instance.getOwnSlotValues(slot2));
        Instance instance2 = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(instance2), instance.getOwnSlotValues(slot2));
    }

    public void testAddDirectTypeSave() {
        Cls cls = this.createCls();
        String string = cls.getName();
        Cls cls2 = this.createCls();
        String string2 = cls2.getName();
        Instance instance = this.createInstance(cls);
        String string3 = instance.getName();
        instance.addDirectType(cls2);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls, cls2), instance.getDirectTypes());
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(string);
        cls2 = this.getCls(string2);
        instance = this.getInstance(string3);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls, cls2), instance.getDirectTypes());
    }

    public void testGetValueTypeByOwnSlotValue() {
        Slot slot = this.createSlot();
        ValueType valueType = slot.getValueType();
        DefaultKnowledgeBase_Test.assertEquals((Object)valueType, (Object)ValueType.STRING);
        Slot slot2 = this.getSlot(":SLOT-VALUE-TYPE");
        slot.setDirectOwnSlotValues(slot2, Collections.EMPTY_LIST);
        List list = slot.getDirectOwnSlotValues(slot2);
        DefaultKnowledgeBase_Test.assertEqualsList(list, Collections.EMPTY_LIST);
    }

    public void testDeleteFromCache() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        Cls cls = null;
        String string = "foo";
        Instance instance = knowledgeBase.createInstance(string, cls);
        String string2 = instance.getName();
        instance = knowledgeBase.getInstance(string2);
        instance.delete();
        Instance instance2 = this.createInstance(string2, cls);
        instance2 = this.getInstance(string2);
        DefaultKnowledgeBase_Test.assertEquals((String)string, (String)instance2.getName());
    }

    public void testOwnSlotValueChangedEventOnInverseSlot() {
        final int[] nArray = new int[1];
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.INSTANCE);
        Slot slot2 = this.createSlot();
        slot2.setValueType(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        cls.addDirectTemplateSlot(slot);
        cls2.addDirectTemplateSlot(slot2);
        Instance instance = cls.createDirectInstance(null);
        Instance instance2 = cls2.createDirectInstance(null);
        instance.setDirectOwnSlotValue(slot, instance2);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance.getDirectOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getDirectOwnSlotValues(slot2).size());
        this.getDomainKB().addFrameListener(new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent frameEvent) {
                nArray[0] = nArray[0] + 1;
            }
        });
        instance.setDirectOwnSlotValue(slot, null);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)instance.getDirectOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)instance2.getDirectOwnSlotValues(slot2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)nArray[0]);
    }

    public void testRemoveFrameStore() {
        final boolean[] blArray = new boolean[]{false};
        FrameStoreAdapter frameStoreAdapter = new FrameStoreAdapter(){

            public Frame getFrame(String string) {
                blArray[0] = true;
                return super.getFrame(string);
            }
        };
        this.getDomainKB().insertFrameStore(frameStoreAdapter);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertTrue((boolean)blArray[0]);
        blArray[0] = false;
        this.getDomainKB().removeFrameStore(frameStoreAdapter);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertFalse((boolean)blArray[0]);
    }

    public void testRemoveFrameStoreWithPosition() {
        final boolean[] blArray = new boolean[]{false};
        FrameStoreAdapter frameStoreAdapter = new FrameStoreAdapter(){

            public Frame getFrame(String string) {
                blArray[0] = true;
                return super.getFrame(string);
            }
        };
        this.getDomainKB().insertFrameStore(frameStoreAdapter, 3);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertTrue((boolean)blArray[0]);
        blArray[0] = false;
        this.getDomainKB().removeFrameStore(frameStoreAdapter);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertFalse((boolean)blArray[0]);
    }

    public void testGetOverriddenDefaultValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setDefaultValues(DefaultKnowledgeBase_Test.makeList("foo"));
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList("bar"));
        Cls cls2 = this.createSubCls(cls);
        cls2.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList("baz"));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("bar"), cls.getTemplateSlotDefaultValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("baz"), cls2.getTemplateSlotDefaultValues(slot));
    }

    public void testGetOwnSlotDefaultValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setDefaultValues(DefaultKnowledgeBase_Test.makeList("foo"));
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("foo"), instance.getOwnSlotDefaultValues(slot));
    }

    public void testGetDomain() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Cls cls3 = this.createSubCls(cls2);
        Cls cls4 = this.createSubCls(cls3);
        Slot slot = this.createSlotOnCls(cls2);
        Collection collection = slot.getDomain();
        DefaultKnowledgeBase_Test.assertFalse((boolean)collection.contains(cls));
        DefaultKnowledgeBase_Test.assertTrue((boolean)collection.contains(cls2));
        DefaultKnowledgeBase_Test.assertTrue((boolean)collection.contains(cls3));
        DefaultKnowledgeBase_Test.assertTrue((boolean)collection.contains(cls4));
        DefaultKnowledgeBase_Test.assertFalse((boolean)collection.contains(this.getDomainKB().getRootCls()));
    }

    public void testUndoCreateCls() {
        this.enableUndo();
        Cls cls = this.createCls();
        Cls cls2 = this.getCls(":STANDARD-CLASS");
        Cls cls3 = this.createSubCls(cls2);
        Cls cls4 = this.createSubClsWithType(cls, cls3);
        String string = cls4.getName();
        Cls cls5 = this.createCls();
        String string2 = cls5.getName();
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string2));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        this.redo();
        Cls cls6 = (Cls)this.getFrame(string);
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls6);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls), cls6.getDirectSuperclasses());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls3), cls6.getDirectTypes());
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string2));
        this.redo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string2));
    }

    private void enableUndo() {
        this.getDomainKB().setUndoEnabled(true);
    }

    private void undo() {
        DefaultKnowledgeBase_Test.assertTrue((boolean)this.getDomainKB().getCommandManager().canUndo());
        this.getDomainKB().getCommandManager().undo();
    }

    private void redo() {
        DefaultKnowledgeBase_Test.assertTrue((boolean)this.getDomainKB().getCommandManager().canRedo());
        this.getDomainKB().getCommandManager().redo();
    }

    public void testUndoDeleteCls() {
        Cls cls = this.createCls();
        Cls cls2 = this.getCls(":STANDARD-CLASS");
        Cls cls3 = this.createSubCls(cls2);
        Cls cls4 = this.createSubClsWithType(cls, cls3);
        String string = cls4.getName();
        this.enableUndo();
        this.getDomainKB().deleteCls(cls4);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        this.undo();
        Cls cls5 = this.getCls(string);
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls5);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls), cls5.getDirectSuperclasses());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls3), cls5.getDirectTypes());
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
    }

    public void testUndoDeleteInstanceWithReferences() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Instance instance = cls.createDirectInstance(null);
        Instance instance2 = cls.createDirectInstance(null);
        instance.setOwnSlotValue(slot, instance2);
        instance2.setOwnSlotValue(slot, instance);
        this.enableUndo();
        this.delete(instance2);
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertTrue((boolean)instance2.isDeleted());
        this.undo();
        DefaultKnowledgeBase_Test.assertEquals((Object)instance2, (Object)instance.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertEquals((Object)instance, (Object)instance2.getOwnSlotValue(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertTrue((boolean)instance2.isDeleted());
    }

    public void testDeleteClsWithSlots() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Slot slot2 = this.createSlotOnCls(cls);
        this.enableUndo();
        this.delete(cls);
        this.undo();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(slot, slot2), cls.getDirectTemplateSlots());
        this.redo();
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.isDeleted());
        this.undo();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(slot, slot2), cls.getDirectTemplateSlots());
    }

    public void testUndoDeleteWithFacetOverrides() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        slot.setAllowedClses(this.getDomainKB().getRootClses());
        cls.setTemplateSlotAllowedClses(slot, DefaultKnowledgeBase_Test.makeList(cls2));
        this.enableUndo();
        this.delete(cls2);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.undo();
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(cls2), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.undo();
        String string = cls.getName();
        this.delete(cls);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getCls(string));
        this.undo();
        cls = this.getCls(string);
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.isDeleted());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls2), cls.getTemplateSlotAllowedClses(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getCls(string));
    }

    public void testFoo() {
        Cls cls = this.createCls("A");
        Cls cls2 = this.createCls("B");
        this.enableUndo();
        this.delete(cls);
        this.undo();
        this.delete(cls2);
        this.undo();
    }

    public void testDeleteAfterUndo() {
        Cls cls = this.createCls();
        String string = cls.getName();
        Cls cls2 = this.createCls();
        String string2 = cls2.getName();
        this.enableUndo();
        this.delete(cls);
        this.delete(cls2);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string2));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string2));
        this.undo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string2));
        this.redo();
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string2));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(string));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string2));
        this.delete(cls2);
        this.undo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(string2));
    }

    public void testGetClsCount() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        int n = knowledgeBase.getClsCount();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertEquals((int)(n + 1), (int)knowledgeBase.getClsCount());
        knowledgeBase.deleteCls(cls);
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)knowledgeBase.getClsCount());
    }

    public void testGetSlotCount() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        int n = knowledgeBase.getSlotCount();
        Slot slot = this.createSlot();
        DefaultKnowledgeBase_Test.assertEquals((int)(n + 1), (int)knowledgeBase.getSlotCount());
        knowledgeBase.deleteSlot(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)knowledgeBase.getSlotCount());
    }

    public void testGetFacetCount() {
    }

    public void testGetSimpleInstanceCount() {
    }

    public void testGetFrameCount() {
    }

    public void testGetClses() {
    }

    public void testGetSlots() {
    }

    public void testGetFacets() {
    }

    public void testGetFrames() {
    }

    public void testGetFrameByID() {
    }

    public void testGetFrameByName() {
    }

    public void testGetFrameName() {
    }

    public void testCreateCls() {
    }

    public void testCreateSlot() {
    }

    public void testCreateFacet() {
    }

    public void testCreateSimpleInstance() {
    }

    public void testDeleteSlot() {
    }

    public void testDeleteFacet() {
    }

    public void testDeleteSimpleInstance() {
    }

    public void testAddInverseSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        instance.addOwnSlotValue(slot, instance2);
        DefaultKnowledgeBase_Test.assertSame((String)"forward", (Object)instance2, (Object)instance.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertSame((String)"backward", (Object)instance, (Object)instance2.getOwnSlotValue(slot2));
    }

    public void testAddOwnSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        instance.setOwnSlotValue(slot, instance2);
        instance.addOwnSlotValue(slot, instance3);
        DefaultKnowledgeBase_Test.assertEquals((String)"pass 1", (int)2, (int)instance.getOwnSlotValues(slot).size());
        instance.setOwnSlotValue(slot, instance2);
        instance.addOwnSlotValue(slot, instance3);
        DefaultKnowledgeBase_Test.assertEquals((String)"pass 2", (int)2, (int)instance.getOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertSame((String)"add doesn't replace", (Object)instance2, (Object)instance.getOwnSlotValue(slot));
    }

    public void testAreValidOwnSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.INTEGER);
        slot.setMinimumValue(new Integer(2));
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertFalse((String)"1", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(1))));
        DefaultKnowledgeBase_Test.assertTrue((String)"2", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(2))));
        DefaultKnowledgeBase_Test.assertTrue((String)"3", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(3))));
    }

    public void testCreateSubslot() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE, cls);
        Slot slot2 = this.createSubSlot(slot);
        DefaultKnowledgeBase_Test.assertSame((String)"a type", (Object)ValueType.INSTANCE, (Object)slot.getValueType());
        DefaultKnowledgeBase_Test.assertSame((String)"b type", (Object)ValueType.INSTANCE, (Object)slot2.getValueType());
        DefaultKnowledgeBase_Test.assertTrue((String)"a cardinality", (boolean)slot.getAllowsMultipleValues());
        DefaultKnowledgeBase_Test.assertTrue((String)"b cardinality", (boolean)slot2.getAllowsMultipleValues());
    }

    public void testDeleteCls() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        Cls cls3 = this.createSubCls(cls);
        Instance instance = this.createInstance(cls2);
        Instance instance2 = this.createInstance(cls3);
        int n = this.getFrameCount();
        try {
            this.deleteFrame(cls2);
            DefaultKnowledgeBase_Test.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with direct instance", (int)n, (int)this.getFrameCount());
        try {
            this.deleteFrame(cls);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with indirect instance", (int)n, (int)this.getFrameCount());
        this.deleteFrame(instance);
        this.deleteFrame(cls2);
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with no direct instance", (int)(n -= 2), (int)this.getFrameCount());
        this.deleteFrame(instance2);
        this.deleteFrame(cls);
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with no instances", (int)(n -= 3), (int)this.getFrameCount());
    }

    public void testDeleteClsEvent() {
        final KnowledgeBaseEvent[] knowledgeBaseEventArray = new KnowledgeBaseEvent[1];
        Cls cls = this.createCls();
        String string = cls.getName();
        KnowledgeBaseAdapter knowledgeBaseAdapter = new KnowledgeBaseAdapter(){

            public void clsDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
                knowledgeBaseEventArray[0] = knowledgeBaseEvent;
            }
        };
        cls.getKnowledgeBase().addKnowledgeBaseListener(knowledgeBaseAdapter);
        this.clearEvents();
        this.deleteFrame(cls);
        cls.getKnowledgeBase().removeKnowledgeBaseListener(knowledgeBaseAdapter);
        DefaultKnowledgeBase_Test.assertNotNull((String)"fired", (Object)knowledgeBaseEventArray[0]);
        DefaultKnowledgeBase_Test.assertEquals((String)"name available", (String)string, (String)knowledgeBaseEventArray[0].getOldName());
    }

    public void testFacetOverrides() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        Slot slot = this.createSingleValuedSlot(ValueType.ANY);
        cls.addDirectTemplateSlot(slot);
        Facet facet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.ANY, (Object)slot.getValueType());
        DefaultKnowledgeBase_Test.assertFalse((String)"a not overridden", (boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not overridden", (boolean)cls2.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"a not directly overridden", (boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not directly overridden", (boolean)cls2.hasDirectlyOverriddenTemplateSlot(slot));
        cls.setTemplateSlotValueType(slot, ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.ANY, (Object)slot.getValueType());
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.FLOAT, (Object)cls.getTemplateSlotValueType(slot));
        DefaultKnowledgeBase_Test.assertTrue((String)"a overridden", (boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertTrue((String)"b overridden", (boolean)cls2.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertTrue((String)"a directly overridden", (boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not directly overridden", (boolean)cls2.hasDirectlyOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertTrue((String)"a valueType overridden", (boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertTrue((String)"a valueType directly overridden", (boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertTrue((String)"b valueType overridden", (boolean)cls2.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((String)"b valueType direct overridden", (boolean)cls2.hasDirectlyOverriddenTemplateFacet(slot, facet));
    }

    public void testIsDirectlyOverriddenFacet() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        cls.addDirectTemplateSlot(slot);
        cls2.setTemplateSlotDefaultValues(slot, Collections.singleton(cls));
        for (Facet facet : cls2.getTemplateFacets(slot)) {
            boolean bl = cls2.hasOverriddenTemplateFacet(slot, facet);
            boolean bl2 = facet.getName().equals(":DEFAULTS");
            DefaultKnowledgeBase_Test.assertEquals((String)("facet: " + facet), (boolean)bl2, (boolean)bl);
        }
    }

    public void testGetMatchingReferences() {
        Slot slot = this.createMultiValuedSlot(ValueType.STRING);
        Cls cls = this.createCls();
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        instance.addOwnSlotValue(slot, "zabcy");
        instance2.addOwnSlotValue(slot, "abcz");
        instance3.addOwnSlotValue(slot, "qqq");
        DefaultKnowledgeBase_Test.assertEquals((String)"exact", (int)0, (int)this.getDomainKB().getMatchingReferences("z", 0).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"starts", (int)1, (int)this.getDomainKB().getMatchingReferences("z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains", (int)2, (int)this.getDomainKB().getMatchingReferences("*z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains insensitive", (int)2, (int)this.getDomainKB().getMatchingReferences("*Z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains 2", (int)2, (int)this.getDomainKB().getMatchingReferences("*abc*", -1).size());
    }

    public void testGetFramesWithValue() {
        Slot slot = this.createMultiValuedSlot(ValueType.STRING);
        Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        Cls cls = this.createCls();
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        instance.addOwnSlotValue(slot, "abc");
        instance2.addOwnSlotValue(slot, "abc");
        instance3.addOwnSlotValue(slot, "abc");
        instance2.addOwnSlotValue(slot2, instance);
        DefaultKnowledgeBase_Test.assertEquals((String)"string match", (int)3, (int)this.getDomainKB().getFramesWithValue(slot, null, false, "abc").size());
        DefaultKnowledgeBase_Test.assertEquals((String)"frame match", (int)1, (int)this.getDomainKB().getFramesWithValue(slot2, null, false, instance).size());
    }

    public void testGetInstances() {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(this.getProject().getSources().getKnowledgeBase().getInstances());
        Collections.sort(arrayList, new FrameNameComparator());
        for (Instance instance : arrayList) {
            DefaultKnowledgeBase_Test.assertNotNull((Object)instance.getName());
        }
    }

    public void testGetMatchingFrameNames() {
    }

    public void testInverseSlotRelationship() {
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createSingleValuedSlot(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        DefaultKnowledgeBase_Test.assertSame((String)"created", (Object)slot, (Object)slot2.getInverseSlot());
        slot.setInverseSlot(null);
        DefaultKnowledgeBase_Test.assertNull((String)"null", (Object)slot2.getInverseSlot());
    }

    public void testJavaPackagesOnInstance() {
        Class<TestSimpleInstance> clazz = TestSimpleInstance.class;
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.getProject().addJavaPackageName(string2);
        Cls cls = this.getCls(string3);
        if (cls == null) {
            cls = this.createCls(string3);
        }
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertEquals(clazz, instance.getClass());
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(string3);
        DefaultKnowledgeBase_Test.assertNotNull((String)"after reload", (Object)cls);
        for (Instance instance2 : cls.getDirectInstances()) {
            DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + instance2), (boolean)clazz.isInstance(instance));
        }
        this.getProject().removeJavaPackageName(string2);
    }

    public void testJavaPackagesOnCls() {
        Class<TestCls> clazz = TestCls.class;
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.getProject().addJavaPackageName(string2);
        Cls cls = this.getCls(":STANDARD-CLASS");
        Cls cls2 = this.getCls(string3);
        if (cls2 == null) {
            cls2 = this.createCls(string3, cls);
        }
        Cls cls3 = this.createClsWithType(cls2);
        DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + cls3), (boolean)clazz.isInstance(cls3));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls2 = this.getCls(string3);
        DefaultKnowledgeBase_Test.assertNotNull((String)"after reload", (Object)cls2);
        for (Cls cls4 : cls2.getDirectInstances()) {
            DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + cls4.getClass()), (boolean)clazz.isInstance(cls4));
        }
        this.getProject().removeJavaPackageName(string2);
    }

    public void testJavaPackagesCreateClsEvent() {
        final Class<TestCls> clazz = TestCls.class;
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.getProject().addJavaPackageName(string2);
        Cls cls = this.getCls(":STANDARD-CLASS");
        Cls cls2 = this.getCls(string3);
        if (cls2 == null) {
            cls2 = this.createCls(string3, cls);
        }
        KnowledgeBaseAdapter knowledgeBaseAdapter = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                Assert.assertTrue((boolean)clazz.isInstance(knowledgeBaseEvent.getCls()));
                DefaultKnowledgeBase_Test.this.recordEventFired(knowledgeBaseEvent);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(knowledgeBaseAdapter);
        this.clearEvents();
        Cls cls3 = this.createClsWithType(cls2);
        DefaultKnowledgeBase_Test.assertTrue((boolean)clazz.isInstance(cls3));
        this.assertEventFired(601);
    }

    public void testCreateClsEvent() {
        KnowledgeBaseAdapter knowledgeBaseAdapter = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                Assert.assertNotNull((Object)knowledgeBaseEvent.getCls());
                DefaultKnowledgeBase_Test.this.recordEventFired(knowledgeBaseEvent);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(knowledgeBaseAdapter);
        this.clearEvents();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls);
        this.assertEventFired(601);
    }

    public void testFrameFactoryCreateClsEvent() {
        this.getDomainKB().setFrameFactory(new TestFrameFactory(this.getDomainKB()));
        KnowledgeBaseAdapter knowledgeBaseAdapter = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                Assert.assertTrue((boolean)(knowledgeBaseEvent.getCls() instanceof TestCls));
                DefaultKnowledgeBase_Test.this.recordEventFired(knowledgeBaseEvent);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(knowledgeBaseAdapter);
        this.clearEvents();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)(cls instanceof TestCls));
        this.assertEventFired(601);
    }

    public void testModificationSlots() throws ParseException {
        String string = ApplicationProperties.getUserName();
        Date date = new Date();
        SystemUtilities.sleepMsec(100);
        KnowledgeBase knowledgeBase = this.getDomainKB();
        knowledgeBase.setModificationRecordUpdatingEnabled(true);
        Cls cls = this.createSubCls(this.getCls(":STANDARD-CLASS"));
        cls.addDirectTemplateSlot(this.getSlot(":CREATOR"));
        cls.addDirectTemplateSlot(this.getSlot(":CREATION-TIMESTAMP"));
        cls.addDirectTemplateSlot(this.getSlot(":MODIFIER"));
        cls.addDirectTemplateSlot(this.getSlot(":MODIFICATION-TIMESTAMP"));
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        Cls cls2 = (Cls)this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertEquals((String)"creator", (String)string, (String)knowledgeBase.getFrameCreator(cls2));
        String string2 = knowledgeBase.getFrameCreationTimestamp(cls2);
        DefaultKnowledgeBase_Test.assertNotNull((String)"creation stamp", (Object)string2);
        Date date2 = new StandardDateFormat().parse(string2);
        SystemUtilities.sleepMsec(100);
        Date date3 = new Date();
        DefaultKnowledgeBase_Test.assertTrue((String)("create timestamp after begin: " + date2 + " - " + date), (boolean)date2.after(date));
        DefaultKnowledgeBase_Test.assertTrue((String)("create timestamp before end: " + date2 + " - " + date3), (boolean)date2.before(date3));
        cls2.addDirectTemplateSlot(slot);
        SystemUtilities.sleepMsec(100);
        String string3 = knowledgeBase.getFrameLastModifier(cls2);
        DefaultKnowledgeBase_Test.assertEquals((String)"name", (String)string, (String)string3);
        String string4 = knowledgeBase.getFrameLastModificationTimestamp(cls2);
        DefaultKnowledgeBase_Test.assertNotNull((String)"timestamp", (Object)string4);
        Date date4 = new StandardDateFormat().parse(string4);
        SystemUtilities.sleepMsec(100);
        Date date5 = new Date();
        DefaultKnowledgeBase_Test.assertTrue((String)("mod timestamp after begin: " + date4 + " - " + date), (boolean)date4.after(date));
        DefaultKnowledgeBase_Test.assertTrue((String)("mod timestamp before end: " + date4 + " - " + date5), (boolean)date4.before(date5));
        knowledgeBase.setModificationRecordUpdatingEnabled(false);
    }

    public void testRecursiveDelete() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        this.createSubCls(cls2);
        int n = this.getFrameCount();
        this.deleteFrame(cls2);
        int n2 = n - 2;
        DefaultKnowledgeBase_Test.assertEquals((int)n2, (int)this.getFrameCount());
        DefaultKnowledgeBase_Test.saveAndReload();
        DefaultKnowledgeBase_Test.assertEquals((int)n2, (int)this.getFrameCount());
    }

    public void testRemoveInverseSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createSingleValuedSlot(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        instance.setOwnSlotValues(slot, Collections.singleton(instance2));
        instance.setOwnSlotValue(slot, null);
        DefaultKnowledgeBase_Test.assertNull((String)"forward", (Object)instance.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertNull((String)"backward", (Object)instance2.getOwnSlotValue(slot2));
    }

    public void testRemoveOwnSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        arrayList.add(instance2);
        arrayList.add(instance3);
        instance.setOwnSlotValues(slot, arrayList);
        instance.removeOwnSlotValue(slot, instance3);
        DefaultKnowledgeBase_Test.assertEquals((String)"size", (int)1, (int)instance.getOwnSlotValueCount(slot));
        DefaultKnowledgeBase_Test.assertEquals((String)"1st value", (Object)instance2, (Object)instance.getOwnSlotValue(slot));
        instance.setOwnSlotValues(slot, arrayList);
        instance.removeOwnSlotValue(slot, instance2);
        DefaultKnowledgeBase_Test.assertEquals((String)"size", (int)1, (int)instance.getOwnSlotValueCount(slot));
        DefaultKnowledgeBase_Test.assertEquals((String)"2nd value", (Object)instance3, (Object)instance.getOwnSlotValue(slot));
    }

    public void testSaveLoadTemplateSlotValues() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        String string = cls2.getName();
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        String string2 = slot.getName();
        cls2.addDirectTemplateSlot(slot);
        Set<Cls> set = Collections.singleton(cls);
        slot.setValues(set);
        cls2.setTemplateSlotValues(slot, set);
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(string2);
        cls2 = this.getCls(string);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)slot.getValues().size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)cls2.getTemplateSlotValues(slot).size());
    }

    public void testSetInverseSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        String string = slot.getName();
        String string2 = slot2.getName();
        String string3 = instance.getName();
        String string4 = instance2.getName();
        instance.setOwnSlotValue(slot, instance2);
        DefaultKnowledgeBase_Test.assertSame((String)"set with value", (Object)instance, (Object)instance2.getOwnSlotValue(slot2));
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getOwnSlotValues(slot2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance.getOwnSlotValues(slot).size());
        instance.setOwnSlotValue(slot, null);
        DefaultKnowledgeBase_Test.assertNull((Object)instance2.getOwnSlotValue(slot2));
        instance.setOwnSlotValue(slot, instance2);
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(string);
        slot2 = this.getSlot(string2);
        instance = this.getInstance(string3);
        instance2 = this.getInstance(string4);
        DefaultKnowledgeBase_Test.assertEquals((Object)instance, (Object)instance2.getOwnSlotValue(slot2));
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance2.getOwnSlotValues(slot2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instance.getOwnSlotValues(slot).size());
    }

    public void testSetInverseSlotValues1N() {
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)slot.getMaximumCardinality());
        slot.setInverseSlot(slot2);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        String string = slot.getName();
        String string2 = slot2.getName();
        String string3 = instance.getName();
        String string4 = instance2.getName();
        String string5 = instance3.getName();
        instance2.setOwnSlotValue(slot, instance3);
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to c", (Object)instance3, (Object)instance2.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertEquals((String)"c connected to b", (Object)instance2, (Object)instance3.getOwnSlotValue(slot2));
        instance.setOwnSlotValues(slot2, Collections.singleton(instance2));
        DefaultKnowledgeBase_Test.assertEquals((String)"size b", (int)1, (int)instance2.getOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to a", (Object)instance, (Object)instance2.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertNull((String)"c disconnected", (Object)instance3.getOwnSlotValue(slot2));
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(string);
        slot2 = this.getSlot(string2);
        instance = this.getInstance(string3);
        instance2 = this.getInstance(string4);
        instance3 = this.getInstance(string5);
        DefaultKnowledgeBase_Test.assertEquals((String)"size b", (int)1, (int)instance2.getOwnSlotValues(slot).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to a", (Object)instance, (Object)instance2.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertNull((String)"c disconnected", (Object)instance3.getOwnSlotValue(slot2));
    }

    public void testSetInverseSlotValuesNN() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        slot.setInverseSlot(slot2);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        String string = slot2.getName();
        String string2 = instance.getName();
        String string3 = instance2.getName();
        instance.setOwnSlotValues(slot, Collections.singleton(instance2));
        DefaultKnowledgeBase_Test.assertEquals((String)"set with values", (Object)instance, (Object)instance2.getOwnSlotValue(slot2));
        instance.setOwnSlotValues(slot, Collections.EMPTY_LIST);
        DefaultKnowledgeBase_Test.assertNull((String)"set with empty collection", (Object)instance2.getOwnSlotValue(slot2));
        instance.setOwnSlotValues(slot, Collections.singleton(instance2));
        DefaultKnowledgeBase_Test.saveAndReload();
        slot2 = this.getSlot(string);
        instance = this.getInstance(string2);
        instance2 = this.getInstance(string3);
        DefaultKnowledgeBase_Test.assertEquals((String)"set with values", (Object)instance, (Object)instance2.getOwnSlotValue(slot2));
    }

    public void testSetOwnSlotValue() {
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.INSTANCE);
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        instance.setOwnSlotValue(slot, instance2);
        Collection collection = instance.getOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)collection.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)instance2, CollectionUtilities.getFirstItem(collection));
        instance.setOwnSlotValue(slot, instance);
        collection = instance.getOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)collection.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)instance, CollectionUtilities.getFirstItem(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOwnSlotValues() {
        this.getDomainKB().setValueChecking(true);
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.STRING);
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        instance.setOwnSlotValues(slot, arrayList);
        arrayList.add("");
        try {
            instance.setOwnSlotValues(slot, arrayList);
            DefaultKnowledgeBase_Test.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.getDomainKB().setValueChecking(false);
        }
    }

    public void testSubslots() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        String string = instance.getName();
        Slot slot = this.createMultiValuedSlot(ValueType.STRING);
        Slot slot2 = this.createSubSlot(slot);
        String string2 = "a";
        String string3 = "b";
        String string4 = slot.getName();
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        instance.setOwnSlotValue(slot, string2);
        instance.setOwnSlotValue(slot2, string3);
        Collection collection = instance.getOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((String)"a", (int)2, (int)collection.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"a contains", (boolean)collection.contains(string2));
        Collection collection2 = instance.getOwnSlotValues(slot2);
        DefaultKnowledgeBase_Test.assertEquals((String)"b", (int)1, (int)collection2.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"b contains", (boolean)collection2.contains(string3));
        Collection collection3 = instance.getOwnSlotAndSubslotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((String)"a and b", (int)2, (int)collection3.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"a and b contains 1", (boolean)collection3.contains(string2));
        DefaultKnowledgeBase_Test.assertTrue((String)"a and b contains 2", (boolean)collection3.contains(string3));
        Collection collection4 = instance.getOwnSlotAndSubslotValues(slot2);
        DefaultKnowledgeBase_Test.assertEquals((String)"b but not a", (int)1, (int)collection4.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"b but not a contains 2", (boolean)collection4.contains(string3));
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(string4);
        instance = this.getInstance(string);
        DefaultKnowledgeBase_Test.assertNotNull((String)"slot a", (Object)slot);
        collection3 = instance.getOwnSlotAndSubslotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((String)"save", (int)2, (int)collection3.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"save value 1", (boolean)collection3.contains(string2));
        DefaultKnowledgeBase_Test.assertTrue((String)"save value 2", (boolean)collection3.contains(string3));
    }

    public void testGetSuperslots() {
        Slot slot = this.createSlot();
        Slot slot2 = this.createSubSlot(slot);
        Slot slot3 = this.createSubSlot(slot2);
        Collection collection = slot3.getSuperslots();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(slot, slot2), collection);
    }

    public void testTopLevelGetTemplateSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        List list = DefaultKnowledgeBase_Test.makeList("foo", "bar");
        slot.setValues(list);
        Collection collection = slot.getValues();
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection);
        cls.addDirectTemplateSlot(slot);
        Collection collection2 = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection2);
    }

    public void testGetTemplateSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        List list = DefaultKnowledgeBase_Test.makeList("foo", "bar");
        cls.setTemplateSlotValues(slot, list);
        Collection collection = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection);
        Collection collection2 = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)collection2.size());
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection2);
    }

    public void testAddTemplateSlotValue() {
        String string = "foo";
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.addTemplateSlotValue(slot, string);
        Collection collection = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)collection.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)string, CollectionUtilities.getFirstItem(collection));
    }

    public void testValueTypeOverride() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        String string = cls.getName();
        String string2 = slot.getName();
        cls.addDirectTemplateSlot(slot);
        Facet facet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = (Cls)this.getFrame(string);
        slot = (Slot)this.getFrame(string2);
        facet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertFalse((String)"facet direct override 2", (boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((String)"facet override 2", (boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((String)"slot override 2", (boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"slot direct override 2", (boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
    }

    public void testTemplateSlotValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("foo");
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        String string = cls.getName();
        String string2 = slot.getName();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValues(slot, arrayList);
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getDirectTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(string);
        slot = this.getSlot(string2);
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getDirectTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateSlotValues(slot));
    }

    public void testTemplateSlotValue2() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("foo");
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        Facet facet = this.getFacet(":VALUES");
        String string = cls.getName();
        String string2 = slot.getName();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateFacetValues(slot, facet, arrayList);
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getDirectTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(string);
        slot = this.getSlot(string2);
        facet = this.getFacet(":VALUES");
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getDirectTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateFacetValues(slot, facet));
    }

    public void testSetDirectTypeEvent() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        Cls cls2 = this.createCls();
        ClsAdapter clsAdapter = new ClsAdapter(){

            public void directInstanceRemoved(ClsEvent clsEvent) {
                super.directInstanceRemoved(clsEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }
        };
        cls.addClsListener(clsAdapter);
        ClsAdapter clsAdapter2 = new ClsAdapter(){

            public void directInstanceAdded(ClsEvent clsEvent) {
                super.directInstanceAdded(clsEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }
        };
        cls2.addClsListener(clsAdapter2);
        InstanceAdapter instanceAdapter = new InstanceAdapter(){

            public void directTypeAdded(InstanceEvent instanceEvent) {
                super.directTypeAdded(instanceEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(instanceEvent);
            }

            public void directTypeRemoved(InstanceEvent instanceEvent) {
                super.directTypeRemoved(instanceEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(instanceEvent);
            }
        };
        instance.addInstanceListener(instanceAdapter);
        this.clearEvents();
        instance.setDirectType(cls2);
        this.assertEventFired(306);
        this.assertEventFired(305);
        this.assertEventFired(202);
        this.assertEventFired(203);
    }

    public void testAddFrameListener() {
        FrameAdapter frameAdapter = new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent frameEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(frameEvent);
            }
        };
        Slot slot = this.createSlot();
        Frame frame = this.createFrame();
        frame.addFrameListener(frameAdapter);
        this.clearEvents();
        frame.setOwnSlotValue(slot, "foo");
        this.assertEventFired(110);
        frame.removeFrameListener(frameAdapter);
        this.clearEvents();
        frame.setOwnSlotValue(slot, "bar");
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addFrameListener(frameAdapter);
        frame.setOwnSlotValue(slot, "baz");
        this.assertEventFired(110);
    }

    public void testAddSlotListener() {
        SlotAdapter slotAdapter = new SlotAdapter(){

            public void templateSlotClsAdded(SlotEvent slotEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(slotEvent);
            }

            public void templateSlotClsRemoved(SlotEvent slotEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(slotEvent);
            }
        };
        Slot slot = this.createSlot();
        Cls cls = this.createCls();
        slot.addSlotListener(slotAdapter);
        this.clearEvents();
        cls.addDirectTemplateSlot(slot);
        this.assertEventFired(401);
        slot.removeSlotListener(slotAdapter);
        this.clearEvents();
        cls.removeDirectTemplateSlot(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addSlotListener(slotAdapter);
        cls.addDirectTemplateSlot(slot);
        this.assertEventFired(401);
    }

    public void testAddClsListener() {
        ClsAdapter clsAdapter = new ClsAdapter(){

            public void directSuperclassAdded(ClsEvent clsEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }

            public void directSuperclassRemoved(ClsEvent clsEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }
        };
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        cls.addClsListener(clsAdapter);
        this.clearEvents();
        cls.addDirectSuperclass(cls2);
        this.assertEventFired(301);
        cls.removeClsListener(clsAdapter);
        this.clearEvents();
        cls.removeDirectSuperclass(cls2);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addClsListener(clsAdapter);
        cls.addDirectSuperclass(cls2);
        this.assertEventFired(301);
    }

    public void testDeleteInstanceEvent() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        KnowledgeBaseAdapter knowledgeBaseAdapter = new KnowledgeBaseAdapter(){

            public void instanceDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
                super.instanceDeleted(knowledgeBaseEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(knowledgeBaseEvent);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(knowledgeBaseAdapter);
        ClsAdapter clsAdapter = new ClsAdapter(){

            public void directInstanceRemoved(ClsEvent clsEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }
        };
        this.getDomainKB().addClsListener(cls, clsAdapter);
        this.clearEvents();
        this.getDomainKB().deleteInstance(instance);
        this.assertEventFired(608);
        this.assertEventFired(306);
    }

    public void testAddSuperclassEvents() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        this.getDomainKB().addClsListener(new ClsAdapter(){

            public void directSuperclassAdded(ClsEvent clsEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }

            public void directSubclassAdded(ClsEvent clsEvent) {
                DefaultKnowledgeBase_Test.this.recordEventFired(clsEvent);
            }
        });
        this.clearEvents();
        cls.addDirectSuperclass(cls2);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)this.getEventCount());
        this.assertEventFired(301);
        this.assertEventFired(303);
    }

    public void testAddSuperslotEvents() {
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot();
        this.getDomainKB().addSlotListener(new SlotAdapter(){

            public void directSuperslotAdded(SlotEvent slotEvent) {
                super.directSuperslotAdded(slotEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(slotEvent);
            }

            public void directSubslotAdded(SlotEvent slotEvent) {
                super.directSubslotAdded(slotEvent);
                DefaultKnowledgeBase_Test.this.recordEventFired(slotEvent);
            }
        });
        this.clearEvents();
        slot.addDirectSuperslot(slot2);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)this.getEventCount());
        this.assertEventFired(407);
        this.assertEventFired(405);
    }

    public void testSetBadOwnSlotValue() {
        this.getDomainKB().setValueChecking(true);
        Frame frame = this.createFrame();
        Slot slot = this.createSlot();
        Object object = new Object();
        try {
            frame.setOwnSlotValue(slot, object);
            DefaultKnowledgeBase_Test.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetBadFrameName() {
        String string = "foo";
        String string2 = "foo * foo";
        KnowledgeBase knowledgeBase = this.getDomainKB();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)knowledgeBase.isValidFrameName(string, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)knowledgeBase.getInvalidFrameNameDescription(string, cls));
        DefaultKnowledgeBase_Test.assertTrue((boolean)knowledgeBase.isValidFrameName(string2, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)knowledgeBase.getInvalidFrameNameDescription(string2, cls));
        knowledgeBase.setFrameNameValidator(new FrameNameValidator(){

            public String getErrorMessage(String string, Frame frame) {
                return this.isValid(string, frame) ? null : "Contains a *";
            }

            public boolean isValid(String string, Frame frame) {
                return string.indexOf("*") == -1;
            }
        });
        DefaultKnowledgeBase_Test.assertTrue((boolean)knowledgeBase.isValidFrameName(string, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)knowledgeBase.getInvalidFrameNameDescription(string, cls));
        DefaultKnowledgeBase_Test.assertFalse((boolean)knowledgeBase.isValidFrameName(string2, cls));
        DefaultKnowledgeBase_Test.assertNotNull((Object)knowledgeBase.getInvalidFrameNameDescription(string2, cls));
    }

    public void testDefaultClsMetaCls() {
        Cls cls = this.createCls();
        Cls cls2 = cls.getDirectType();
        Cls cls3 = (Cls)this.getFrame(":STANDARD-CLASS");
        DefaultKnowledgeBase_Test.assertEquals((Object)cls2, (Object)cls3);
        Cls cls4 = this.createCls(null, cls3);
        this.getDomainKB().setDefaultClsMetaCls(cls4);
        Cls cls5 = this.createCls(null, cls);
        DefaultKnowledgeBase_Test.assertEquals((Object)cls5.getDirectType(), (Object)cls3);
        Cls cls6 = this.createCls();
        DefaultKnowledgeBase_Test.assertEquals((Object)cls6.getDirectType(), (Object)cls4);
    }

    public void testRecursiveEquivalentClassesDelete() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Cls cls3 = this.createSubCls(cls2);
        int n = this.getFrameCount();
        Cls cls4 = this.createSubCls(cls2);
        cls3.addDirectSuperclass(cls4);
        cls4.addDirectSuperclass(cls3);
        cls4.addDirectSuperclass(cls);
        cls4.delete();
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)this.getFrameCount());
    }

    public void testDirectDomainForSubslots() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        Slot slot2 = this.createSubSlot(slot);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Collection collection = slot2.getDirectDomain();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls), collection);
    }

    public void testRemoveTemplateSlotEvent() {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        final Cls cls = this.createCls();
        final Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.addClsListener(new ClsAdapter(){

            public void templateSlotRemoved(ClsEvent clsEvent) {
                super.templateSlotRemoved(clsEvent);
                Collection collection = slot.getDirectDomain();
                Assert.assertFalse((boolean)collection.contains(cls));
                booleanArray[0] = Boolean.TRUE;
            }
        });
        cls.removeDirectTemplateSlot(slot);
        DefaultKnowledgeBase_Test.assertTrue((boolean)booleanArray[0]);
    }

    public void testModifyReturnedCollection() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.checkUnmodifiable(instance, slot, 0);
        instance.setOwnSlotValue(slot, "foo");
        DefaultKnowledgeBase_Test.checkUnmodifiable(instance, slot, 1);
    }

    private static void checkUnmodifiable(Instance instance, Slot slot, int n) {
        Collection collection = instance.getDirectOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.checkUnmodifiable(collection);
        collection = instance.getDirectOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)collection.size());
        collection = instance.getOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)collection.size());
        DefaultKnowledgeBase_Test.checkUnmodifiable(collection);
        DefaultKnowledgeBase_Test.assertEquals((int)n, (int)collection.size());
    }

    private static void checkUnmodifiable(Collection collection) {
        try {
            collection.add(new Object());
            DefaultKnowledgeBase_Test.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFrameStoreInsertion() {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        FrameStore frameStore = ((DefaultKnowledgeBase)this.getDomainKB()).getHeadFrameStore();
        FrameStoreAdapter frameStoreAdapter = new FrameStoreAdapter(){

            public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
                booleanArray[0] = Boolean.TRUE;
                return this.getDelegate().createSlot(frameID, collection, collection2, bl);
            }
        };
        this.getDomainKB().insertFrameStore(frameStoreAdapter);
        DefaultKnowledgeBase_Test.assertEquals((Object)frameStore, (Object)frameStoreAdapter.getDelegate());
        this.getDomainKB().createSlot(null);
        DefaultKnowledgeBase_Test.assertTrue((boolean)booleanArray[0]);
    }

    public void testStrangeOverride() {
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.STRING);
        Cls cls = this.createCls();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValueType(slot, ValueType.INSTANCE);
        Cls cls2 = this.createCls();
        Collection<Cls> collection = CollectionUtilities.createCollection(cls2);
        cls.setTemplateSlotAllowedClses(slot, collection);
        Collection collection2 = cls.getTemplateSlotAllowedClses(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(collection, collection2);
    }

    public void testSetValueType() {
        Cls cls = this.createCls();
        Collection<Cls> collection = CollectionUtilities.createCollection(this.createCls());
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotAllowedClses(slot, collection);
        cls.setTemplateSlotValueType(slot, ValueType.INSTANCE);
        Collection collection2 = cls.getTemplateSlotAllowedClses(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(collection, collection2);
    }

    public void testSaveAndLoadAllowedValues() {
        Cls cls = this.createCls();
        String string = cls.getName();
        Slot slot = this.createSlot();
        String string2 = slot.getName();
        cls.addDirectTemplateSlot(slot);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("a");
        arrayList.add("b");
        cls.setTemplateSlotAllowedValues(slot, arrayList);
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateSlotAllowedValues(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(string2);
        cls = this.getCls(string);
        DefaultKnowledgeBase_Test.assertEqualsList(arrayList, cls.getTemplateSlotAllowedValues(slot));
    }

    public void testHasSuperclass() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        Cls cls3 = this.createSubCls(cls);
        Cls cls4 = this.createSubCls(cls2);
        cls4.addDirectSuperclass(cls3);
        Cls cls5 = this.createSubCls(cls4);
        Cls cls6 = this.createCls();
        Cls cls7 = this.createSubCls(cls5);
        cls7.addDirectSuperclass(cls6);
        Cls cls8 = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls4.hasSuperclass(cls));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls5.hasSuperclass(cls2));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls5.hasSuperclass(cls3));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls5.hasSuperclass(cls4));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls7.hasSuperclass(cls));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls7.hasSuperclass(cls3));
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls7.hasSuperclass(cls6));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls7.hasSuperclass(cls8));
    }

    public void testTopLevelDefaultValueClear() {
        Integer n = new Integer(1);
        List list = DefaultKnowledgeBase_Test.makeList(n);
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.INTEGER);
        slot.setDefaultValues(list);
        DefaultKnowledgeBase_Test.assertEqualsList(list, slot.getDefaultValues());
        slot.setValueType(ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), slot.getDefaultValues());
    }

    public void testTemplateSlotDefaultValueClear() {
        Integer n = new Integer(1);
        List list = DefaultKnowledgeBase_Test.makeList(n);
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValueType(slot, ValueType.INTEGER);
        cls.setTemplateSlotDefaultValues(slot, list);
        DefaultKnowledgeBase_Test.assertEqualsList(list, cls.getTemplateSlotDefaultValues(slot));
        cls.setTemplateSlotValueType(slot, ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), cls.getTemplateSlotDefaultValues(slot));
    }

    public void testDefaultAndTemplateInstanceClear() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        Cls cls2 = this.createCls();
        Slot slot = this.createSlot();
        cls2.addDirectTemplateSlot(slot);
        cls2.setTemplateSlotAllowedClses(slot, DefaultKnowledgeBase_Test.makeList(cls));
        cls2.setTemplateSlotValues(slot, DefaultKnowledgeBase_Test.makeList(instance));
        cls2.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList(instance));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(instance), cls2.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(instance), cls2.getTemplateSlotDefaultValues(slot));
        cls2.setTemplateSlotValueType(slot, ValueType.STRING);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), cls2.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), cls2.getTemplateSlotDefaultValues(slot));
    }

    public void testClearSlotValuesOnValueTypeChange() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.STRING);
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        String string = "foo";
        instance.setOwnSlotValue(slot, string);
        DefaultKnowledgeBase_Test.assertEquals((Object)string, (Object)instance.getOwnSlotValue(slot));
        slot.setValueType(ValueType.INTEGER);
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
        Integer n = new Integer(1);
        instance.setOwnSlotValue(slot, n);
        DefaultKnowledgeBase_Test.assertEquals((Object)n, (Object)instance.getOwnSlotValue(slot));
        cls.setTemplateSlotValueType(slot, ValueType.STRING);
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
    }

    public void testFacetOverride() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.INSTANCE);
        slot.setAllowedClses(Collections.singleton(cls));
        cls.setTemplateSlotAllowedClses(slot, Collections.singleton(cls2));
        Facet facet = this.getProject().getKnowledgeBase().getFacet(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        cls.setTemplateSlotAllowedClses(slot, Collections.EMPTY_LIST);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
    }

    public void testSubSubslot() {
        Cls cls = this.createCls();
        List list = DefaultKnowledgeBase_Test.makeList(cls);
        Slot slot = this.createSlot();
        slot.setAllowedClses(list);
        Slot slot2 = this.createSubSlot(slot);
        Slot slot3 = this.createSubSlot(slot2);
        Collection collection = slot2.getAllowedClses();
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection);
        Collection collection2 = slot3.getAllowedClses();
        DefaultKnowledgeBase_Test.assertEqualsList(list, collection2);
    }

    public void testCreateEvent() {
        Cls cls = this.createCls();
        cls.addFrameListener(new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent frameEvent) {
                if (frameEvent.getSlot().equals(DefaultKnowledgeBase_Test.this.getSlot(":DIRECT-INSTANCES"))) {
                    DefaultKnowledgeBase_Test.this.recordEventFired(frameEvent);
                }
            }
        });
        this.clearEvents();
        cls.createDirectInstance(null);
        this.assertEventFired(110);
    }

    public void testSetAllowedClsesOverride() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        List list = DefaultKnowledgeBase_Test.makeList(cls);
        List list2 = DefaultKnowledgeBase_Test.makeList(cls2);
        Slot slot = this.createSlotOnCls(cls);
        slot.setAllowedClses(list);
        DefaultKnowledgeBase_Test.assertEqualsSet(list, slot.getAllowedClses());
        cls.setTemplateSlotAllowedClses(slot, list);
        DefaultKnowledgeBase_Test.assertEqualsSet(list, cls.getTemplateSlotAllowedClses(slot));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
        cls.setTemplateSlotAllowedClses(slot, list2);
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.hasOverriddenTemplateSlot(slot));
        cls.setTemplateSlotAllowedClses(slot, list);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
    }

    public void testAllowedClsesAsSet() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        List list = DefaultKnowledgeBase_Test.makeList(cls, cls);
        slot.setAllowedClses(list);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(cls), (Object)slot.getAllowedClses());
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(cls), (Object)cls.getTemplateSlotAllowedClses(slot));
        cls.setTemplateSlotAllowedClses(slot, list);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(cls), (Object)cls.getTemplateSlotAllowedClses(slot));
    }

    public static class TestSimpleInstance
    extends DefaultSimpleInstance
    implements TestInterface {
        private static final long serialVersionUID = 1300758264519841291L;

        public TestSimpleInstance(KnowledgeBase knowledgeBase, FrameID frameID) {
            super(knowledgeBase, frameID);
        }
    }

    public static class TestFacet
    extends DefaultFacet
    implements TestInterface {
        private static final long serialVersionUID = -1492240588930520569L;

        public TestFacet(KnowledgeBase knowledgeBase, FrameID frameID) {
            super(knowledgeBase, frameID);
        }
    }

    public static class TestSlot
    extends DefaultSlot
    implements TestInterface {
        private static final long serialVersionUID = -1815103988108933212L;

        public TestSlot(KnowledgeBase knowledgeBase, FrameID frameID) {
            super(knowledgeBase, frameID);
        }
    }

    public static class TestCls
    extends DefaultCls
    implements TestInterface {
        private static final long serialVersionUID = -1423984723632122772L;

        public TestCls(KnowledgeBase knowledgeBase, FrameID frameID) {
            super(knowledgeBase, frameID);
        }
    }

    static interface TestInterface {
    }

    static class TestFrameFactory
    implements FrameFactory {
        private KnowledgeBase kb;

        TestFrameFactory(KnowledgeBase knowledgeBase) {
            this.kb = knowledgeBase;
        }

        public void addJavaPackage(String string) {
            throw new UnsupportedOperationException();
        }

        public Cls createCls(FrameID frameID, Collection collection) {
            return new TestCls(this.kb, frameID);
        }

        public Facet createFacet(FrameID frameID, Collection collection) {
            return new TestFacet(this.kb, frameID);
        }

        public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
            return new TestSimpleInstance(this.kb, frameID);
        }

        public Slot createSlot(FrameID frameID, Collection collection) {
            return new TestSlot(this.kb, frameID);
        }

        public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
            return clazz.isAssignableFrom(TestInterface.class);
        }

        public void removeJavaPackage(String string) {
            throw new UnsupportedOperationException();
        }

        public int getJavaClassId(Frame frame) {
            throw new UnsupportedOperationException();
        }

        public Frame createFrameFromClassId(int n, FrameID frameID) {
            throw new UnsupportedOperationException();
        }

        public Collection getClsJavaClassIds() {
            return null;
        }

        public Collection getSlotJavaClassIds() {
            return null;
        }

        public Collection getFacetJavaClassIds() {
            return null;
        }

        public Collection getSimpleInstanceJavaClassIds() {
            return null;
        }

        public Frame replaceFrameWithFrameNamed(Frame frame, String string) {
            throw new UnsupportedOperationException();
        }

        public Frame rename(Frame frame, String string) {
            throw new UnsupportedOperationException();
        }
    }
}

