/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class FrameID
implements Serializable,
Localizable {
    private static final long serialVersionUID = -3804918126573053937L;
    private String name;
    private int hashCode;
    private static WeakHashMap<String, WeakReference<String>> identityMap = new WeakHashMap();

    public FrameID(String string) {
        this.name = string;
        if (string != null) {
            this.intern();
            this.hashCode = string.hashCode() + 42;
        } else {
            this.hashCode = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FrameID)) {
            return false;
        }
        FrameID frameID = (FrameID)object;
        return this.name == frameID.name;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "FrameID(" + this.name + ")";
    }

    public void localize(KnowledgeBase knowledgeBase) {
        if (this.name != null) {
            this.intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intern() {
        WeakHashMap<String, WeakReference<String>> weakHashMap = identityMap;
        synchronized (weakHashMap) {
            WeakReference<String> weakReference = identityMap.get(this.name);
            String string = null;
            if (weakReference != null && (string = (String)weakReference.get()) != null) {
                this.name = string;
            } else {
                identityMap.put(this.name, new WeakReference<String>(this.name));
            }
        }
    }
}

