/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.admin.UserInfoTableModel;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.job.GetFrameCalculatorStatisticsJob;
import edu.stanford.smi.protege.server.job.GetProjectsStatusMapJob;
import edu.stanford.smi.protege.server.job.GetTransactionIsolationLevelJob;
import edu.stanford.smi.protege.server.job.GetUserInfoJob;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ProjectsServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = -3092833104709366831L;
    private DefaultTableModel prjsTableModel;
    private UserInfoTableModel userInfoTableModel;
    private JTextField serverRoundTripField;
    private JTextField transactionIsolationLevelField;
    private JTextField timeToFrameCacheField;
    private LabeledComponent userInfoLC;
    private AllowableAction stopProjectAction;
    private AllowableAction startProjectAction;
    private SelectableTable projectsTable;

    public ProjectsServerPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        super(remoteServer, remoteSession);
    }

    protected JComponent createCenterComponent() {
        this.projectsTable = this.createProjectsTable();
        this.projectsTable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                int n = ProjectsServerPanel.this.projectsTable.getSelectedRow();
                ProjectsServerPanel.this.updateUserInfoPanel(n);
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent("Remote projects", new JScrollPane(this.projectsTable), true);
        labeledComponent.addHeaderButton(this.getViewAction(this.projectsTable));
        labeledComponent.addHeaderButton(this.getStopProjectAction(this.projectsTable));
        labeledComponent.addHeaderButton(this.getStartProjectAction(this.projectsTable));
        labeledComponent.setPreferredSize(new Dimension(800, 300));
        JComponent jComponent = this.createUserInfoPanel();
        this.userInfoLC = new LabeledComponent("Details (no project selected)", new JScrollPane(jComponent), true);
        this.userInfoLC.setPreferredSize(new Dimension(800, 300));
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane(labeledComponent, this.userInfoLC, false);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    private JComponent createUserInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setPreferredSize(new Dimension(750, 250));
        jPanel.add(new LabeledComponent("Statistics", this.createNumbersPanel(), true));
        jPanel.add(new LabeledComponent("Users", new JScrollPane(this.createUserInfoTable()), true));
        return jPanel;
    }

    private SelectableTable createUserInfoTable() {
        this.userInfoTableModel = new UserInfoTableModel();
        SelectableTable selectableTable = new SelectableTable();
        selectableTable.setModel(this.userInfoTableModel);
        return selectableTable;
    }

    private SelectableTable createProjectsTable() {
        SelectableTable selectableTable = ComponentFactory.createSelectableTable(null);
        selectableTable.setAutoCreateColumnsFromModel(true);
        selectableTable.setModel(this.createProjectsTableModel());
        return selectableTable;
    }

    private TableModel createProjectsTableModel() {
        this.prjsTableModel = new DefaultTableModel();
        this.prjsTableModel.addColumn("Project");
        this.prjsTableModel.addColumn("Status");
        this.prjsTableModel.addColumn("Sessions");
        this.fillProjectsTableModel();
        return this.prjsTableModel;
    }

    private JComponent createNumbersPanel() {
        int n = 8;
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        jPanel.add(new JLabel("Estimated round trip time for this admin client (ms):"));
        this.serverRoundTripField = this.createOutputTextField(n);
        jPanel.add(this.serverRoundTripField);
        jPanel.add(new JLabel("Milliseconds to calculate frame cache:"));
        this.timeToFrameCacheField = this.createOutputTextField(n);
        jPanel.add(this.timeToFrameCacheField);
        jPanel.add(new JLabel("Transaction Isolation Level:"));
        this.transactionIsolationLevelField = this.createOutputTextField(n);
        jPanel.add(this.transactionIsolationLevelField);
        return jPanel;
    }

    private JTextField createOutputTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEnabled(false);
        jTextField.setHorizontalAlignment(2);
        return jTextField;
    }

    private void fillProjectsTableModel() {
        this.prjsTableModel.setRowCount(0);
        try {
            Map map = (Map)new GetProjectsStatusMapJob(this.getServer(), this.getSession()).execute();
            for (String string : map.keySet()) {
                Collection<Object> collection = new ArrayList();
                try {
                    collection = this.getServer().getCurrentSessions(string, this.getSession());
                }
                catch (RemoteException remoteException) {
                    Log.getLogger().log(Level.WARNING, "Error at getting the sessions for the remote project " + string, remoteException);
                    this.treatPossibleConnectionLostException(remoteException);
                }
                this.prjsTableModel.addRow(new Object[]{string, map.get(string), collection});
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at getting projects status from server.", exception);
            this.treatPossibleConnectionLostException(exception);
        }
    }

    private void updateUserInfoPanel(int n) {
        if (n < 0) {
            this.userInfoLC.setHeaderLabel("Details (no project selected)");
            this.userInfoTableModel.setUserInfo(null, null);
            return;
        }
        this.serverRoundTripField.setText("(not computed)");
        this.transactionIsolationLevelField.setText("(not computed)");
        this.timeToFrameCacheField.setText("(not computed)");
        String string = this.getProject(n);
        this.userInfoLC.setHeaderLabel("Details on project: " + string);
        Map map = null;
        FrameCalculatorStats frameCalculatorStats = null;
        try {
            TransactionIsolationLevel transactionIsolationLevel;
            map = (Map)new GetUserInfoJob(this.getServer(), this.getSession(), string).execute();
            long l = System.currentTimeMillis();
            frameCalculatorStats = (FrameCalculatorStats)new GetFrameCalculatorStatisticsJob(this.getServer(), this.getSession(), string).execute();
            long l2 = System.currentTimeMillis() - l;
            this.serverRoundTripField.setText("" + l2);
            if (frameCalculatorStats != null) {
                this.timeToFrameCacheField.setText("" + frameCalculatorStats.getPrecalculateTime());
            }
            if ((transactionIsolationLevel = (TransactionIsolationLevel)new GetTransactionIsolationLevelJob(this.getServer(), this.getSession(), string).execute()) != null) {
                this.transactionIsolationLevelField.setText("" + transactionIsolationLevel);
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Failed to get user info from server for project " + string, throwable);
            this.treatPossibleConnectionLostException(throwable);
        }
        this.userInfoTableModel.setUserInfo(map, frameCalculatorStats);
    }

    private AllowableAction getStopProjectAction(final SelectableTable selectableTable) {
        this.stopProjectAction = new AllowableAction("Stop project(s)", Icons.getCancelIcon(), selectableTable){
            private static final long serialVersionUID = 4683660482257589346L;

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = selectableTable.getSelectedRows();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(ProjectsServerPanel.this.getProject(nArray[i]));
                }
                ShutDownPanel shutDownPanel = new ShutDownPanel(arrayList);
                int n = ModalDialog.showDialog(ProjectsServerPanel.this, shutDownPanel, "Shut down project(s)", 11);
                if (n == 1) {
                    int n2 = shutDownPanel.getShutdownInSec();
                    for (String string : arrayList) {
                        this.shutDownProject(string, n2);
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            private void shutDownProject(String string, int n) {
                try {
                    ProjectsServerPanel.this.getServer().shutdownProject(ProjectsServerPanel.this.getSession(), string, n);
                }
                catch (RemoteException remoteException) {
                    Log.getLogger().log(Level.WARNING, "Could not shut down remote project " + string, remoteException);
                    ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Shutting down the remote project " + string + " failed. \nSee console and log for more details.");
                    ProjectsServerPanel.this.treatPossibleConnectionLostException(remoteException);
                }
            }

            public void onSelectionChange() {
                int[] nArray = selectableTable.getSelectedRows();
                if (nArray == null || nArray.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    if (ProjectsServerPanel.this.isStopAllowed(nArray[i])) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.stopProjectAction;
    }

    private AllowableAction getStartProjectAction(final SelectableTable selectableTable) {
        this.startProjectAction = new AllowableAction("Start project or cancel shut down", Icons.getOkIcon(), selectableTable){
            private static final long serialVersionUID = 4714705761432268351L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = selectableTable.getSelectedRow();
                String string = ProjectsServerPanel.this.getProject(n);
                ServerProject.ProjectStatus projectStatus = ProjectsServerPanel.this.getProjectStatus(n);
                if (projectStatus.equals(ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE)) {
                    this.handleStartProject(string);
                    return;
                }
                if (projectStatus.equals(ServerProject.ProjectStatus.SHUTTING_DOWN)) {
                    this.handleCancelShutdown(string);
                    return;
                }
            }

            private void handleStartProject(String string) {
                int n = JOptionPane.showConfirmDialog(ProjectsServerPanel.this, "Start selected project(s)?", "Confirm start projects", 2);
                if (n == 0) {
                    try {
                        ProjectsServerPanel.this.getServer().setProjectStatus(string, ServerProject.ProjectStatus.READY, ProjectsServerPanel.this.getSession());
                    }
                    catch (RemoteException remoteException) {
                        Log.getLogger().log(Level.WARNING, "Could not start remote project " + string, remoteException);
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Could not start remote project " + string + ".\n" + "See console and logs for more information.");
                        ProjectsServerPanel.this.treatPossibleConnectionLostException(remoteException);
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            private void handleCancelShutdown(String string) {
                int n = JOptionPane.showConfirmDialog(ProjectsServerPanel.this, "Remote project " + string + " is in the process of shutting down.\n" + "Do you want to cancel the shut down operation?\n" + "Click on OK to cancel the operation.", "Cancel shut down", 2);
                boolean bl = false;
                if (n == 0) {
                    try {
                        bl = ProjectsServerPanel.this.getServer().cancelShutdownProject(ProjectsServerPanel.this.getSession(), string);
                    }
                    catch (RemoteException remoteException) {
                        Log.getLogger().log(Level.WARNING, "Could not cancel shut down for remote project " + string, remoteException);
                        ProjectsServerPanel.this.treatPossibleConnectionLostException(remoteException);
                    }
                    if (!bl) {
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Could not cancel shut down of project " + string);
                    } else {
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Canceling the shut down of project " + string + " was successful.");
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            public void onSelectionChange() {
                int[] nArray = selectableTable.getSelectedRows();
                if (nArray == null || nArray.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    if (ProjectsServerPanel.this.isStartAllowed(nArray[i])) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.startProjectAction;
    }

    private AllowableAction getViewAction(final SelectableTable selectableTable) {
        return new ViewAction((Selectable)selectableTable){
            private static final long serialVersionUID = 4851439229648071746L;

            public void onView() {
                int n = selectableTable.getSelectedRow();
                ComponentFactory.showTableRowInDialog(selectableTable.getModel(), n, ProjectsServerPanel.this);
            }
        };
    }

    public void refresh() {
        String string = this.getSelectedProject();
        try {
            this.fillProjectsTableModel();
            this.prjsTableModel.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            this.treatPossibleConnectionLostException(throwable);
        }
        this.setProjectTableSelection(string);
    }

    private String getSelectedProject() {
        int n = this.projectsTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return (String)this.prjsTableModel.getValueAt(n, 0);
    }

    private void setProjectTableSelection(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.prjsTableModel.getRowCount(); ++i) {
            String string2 = (String)this.prjsTableModel.getValueAt(i, 0);
            if (string2 == null || !string2.equals(string)) continue;
            this.projectsTable.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private ServerProject.ProjectStatus getProjectStatus(int n) {
        return (ServerProject.ProjectStatus)this.prjsTableModel.getValueAt(n, 1);
    }

    private String getProject(int n) {
        return (String)this.prjsTableModel.getValueAt(n, 0);
    }

    private boolean isStopAllowed(int n) {
        return this.getProjectStatus(n).equals(ServerProject.ProjectStatus.READY) && (RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) || RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), this.getProject(n), MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT));
    }

    private boolean isStartAllowed(int n) {
        return !(!this.getProjectStatus(n).equals(ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE) && !this.getProjectStatus(n).equals(ServerProject.ProjectStatus.SHUTTING_DOWN) || !RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), this.getProject(n), MetaProjectConstants.OPERATION_START_REMOTE_PROJECT));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShutDownPanel
    extends JPanel {
        private static final long serialVersionUID = 5895752980483951552L;
        private final JTextField minsTextField = new JTextField(5);

        ShutDownPanel(Collection<String> collection) {
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            JLabel jLabel = new JLabel("Shutdown time (in minutes):");
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)this);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)this);
            springLayout.putConstraint("West", (Component)this.minsTextField, 5, "East", (Component)jLabel);
            springLayout.putConstraint("North", (Component)this.minsTextField, 3, "North", (Component)this);
            this.minsTextField.setText("10");
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : collection) {
                stringBuffer.append(string);
                stringBuffer.append("<br>");
            }
            JLabel jLabel2 = new JLabel("<html><b>Are you sure you want to shut down the following project(s)? <br><br>" + stringBuffer + "</b><br>" + "This will affect all the users connected currently to the listed project(s).</html>");
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)this);
            springLayout.putConstraint("North", (Component)jLabel2, 20, "South", (Component)jLabel);
            springLayout.putConstraint("East", (Component)this, 5, "East", (Component)jLabel2);
            springLayout.putConstraint("South", (Component)this, 5, "South", (Component)jLabel2);
            this.add(jLabel);
            this.add(this.minsTextField);
            this.add(jLabel2);
        }

        int getShutdownInSec() {
            String string = this.minsTextField.getText().trim();
            return (int)(Float.valueOf(string).floatValue() * 60.0f);
        }
    }
}

