/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.server.socket.deflate.PacketHeader;
import edu.stanford.smi.protege.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressingInputStream
extends InputStream {
    private static Logger log = Log.getLogger(CompressingInputStream.class);
    protected InputStream is;
    protected byte[] buffer;
    protected int offset;
    private Inflater inflater;
    private static int counter = 0;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressingInputStream(InputStream inputStream) {
        this.is = inputStream;
        this.inflater = new Inflater();
        Class<CompressingInputStream> clazz = CompressingInputStream.class;
        synchronized (CompressingInputStream.class) {
            this.id = counter++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            this.fillBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        byte by = this.buffer[this.offset++];
        if (this.buffer.length == this.offset) {
            this.buffer = null;
        }
        return by;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer == null) {
            this.fillBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        int n3 = 0;
        for (n3 = 0; this.offset < this.buffer.length && n3 < n2; ++n3) {
            byArray[n++] = this.buffer[this.offset++];
        }
        if (this.buffer.length == this.offset) {
            this.buffer = null;
        }
        return n3;
    }

    private void fillBuffer() throws IOException {
        this.buffer = null;
        this.offset = 0;
        PacketHeader packetHeader = PacketHeader.read(this.is);
        this.buffer = new byte[packetHeader.getSize()];
        this.fillBuffer(packetHeader);
    }

    protected void fillBuffer(PacketHeader packetHeader) throws IOException {
        this.inflater.reset();
        int n = packetHeader.getCompressedSize();
        byte[] byArray = new byte[n];
        this.readFully(byArray, n);
        this.inflater.setInput(byArray);
        try {
            int n2 = this.inflater.inflate(this.buffer);
            if (n2 != packetHeader.getSize()) {
                throw new IOException("Inflated to the wrong size, expected " + packetHeader.getSize() + " bytes but got " + n2 + " bytes");
            }
        }
        catch (DataFormatException dataFormatException) {
            IOException iOException = new IOException("Compressed Data format bad: " + dataFormatException.getMessage());
            iOException.initCause(dataFormatException);
            throw iOException;
        }
        if (!this.inflater.needsInput()) {
            throw new IOException("Inflater thinks that there is more data to decompress");
        }
        this.logPacket(byArray);
    }

    protected void readFully(byte[] byArray, int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = this.is.read(byArray, i, n - i);
            if (n2 != -1) continue;
            throw new EOFException("Unabled to read entire compressed packet contents");
        }
    }

    protected void logPacket(byte[] byArray) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            int n;
            log.finest("----------------------------------------");
            log.finest("Incoming packet for reader " + this.id);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Uncompressed buffer of size ");
            stringBuffer.append(this.buffer.length);
            stringBuffer.append(": ");
            for (n = 0; n < this.buffer.length; ++n) {
                stringBuffer.append(this.buffer[n]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer.append("Compressed buffer of size ");
            stringBuffer.append(byArray.length);
            stringBuffer.append(": ");
            for (n = 0; n < byArray.length; ++n) {
                stringBuffer.append(byArray[n]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
            log.finest("----------------------------------------");
        }
        catch (Throwable throwable) {
            log.finest("Could not log exitting packet");
        }
    }
}

