/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredOperationCache
implements Cache<RemoteSession, Sft, List> {
    private FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> transactionUpdates;
    private Cache<RemoteSession, Sft, List> delegate;

    public DeferredOperationCache(Cache<RemoteSession, Sft, List> cache, FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> fifoReader) {
        this.delegate = cache;
        this.transactionUpdates = fifoReader;
    }

    @Override
    public CacheResult<List> readCache(RemoteSession remoteSession, Sft sft) {
        this.catchUp();
        return this.delegate.readCache(remoteSession, sft);
    }

    @Override
    public void updateCache(RemoteSession remoteSession, Sft sft) {
        this.catchUp();
        this.delegate.updateCache(remoteSession, sft);
    }

    @Override
    public void updateCache(RemoteSession remoteSession, Sft sft, List list) {
        this.catchUp();
        this.delegate.updateCache(remoteSession, sft, list);
    }

    @Override
    public void modifyCache(RemoteSession remoteSession, Sft sft) {
        this.catchUp();
        this.delegate.modifyCache(remoteSession, sft);
    }

    @Override
    public void modifyCache(RemoteSession remoteSession, Sft sft, List list) {
        this.catchUp();
        this.delegate.modifyCache(remoteSession, sft, list);
    }

    @Override
    public void invalidate(RemoteSession remoteSession) {
        this.catchUp();
        this.delegate.invalidate(remoteSession);
    }

    @Override
    public boolean isInvalid() {
        this.catchUp();
        return this.delegate.isInvalid();
    }

    @Override
    public void flush() {
        while (this.transactionUpdates.read() != null) {
        }
        this.delegate.flush();
    }

    @Override
    public void startCompleteCache() {
        this.catchUp();
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.catchUp();
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.catchUp();
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        this.catchUp();
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(RemoteSession remoteSession) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public void commitTransaction(RemoteSession remoteSession) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public void rollbackTransaction(RemoteSession remoteSession) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public int getTransactionNesting(RemoteSession remoteSession) {
        this.catchUp();
        return this.delegate.getTransactionNesting(remoteSession);
    }

    private void catchUp() {
        SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate;
        while ((serializedCacheUpdate = this.transactionUpdates.read()) != null) {
            serializedCacheUpdate.performUpdate(this.delegate);
        }
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

