/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DatabaseKnowledgeBaseSourcesEditor
extends KnowledgeBaseSourcesEditor {
    private static final long serialVersionUID = -1850928285684275958L;
    public static final String DEFAULT_TABLE_NAME = "ProtegeTable";
    private JTextField _driverComponent;
    private JTextField _urlComponent;
    private JTextField _tableNameComponent;
    private JTextField _usernameComponent;
    private JTextField _passwordComponent;

    public DatabaseKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        super(string, propertyList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 1));
        jPanel.add(this.createDriverComponent());
        jPanel.add(this.createURLComponent());
        jPanel.add(this.createTableNameComponent());
        jPanel.add(this.createUsernameComponent());
        jPanel.add(this.createPasswordComponent());
        this.add(jPanel);
    }

    public Component createDriverComponent() {
        this._driverComponent = ComponentFactory.createTextField();
        String string = DatabaseKnowledgeBaseFactory.getDriver(this.getSources());
        if (string == null) {
            string = DatabaseProperty.getProperty(DatabaseProperty.DRIVER_PROPERTY);
        }
        this._driverComponent.setText(string);
        return new LabeledComponent(DatabaseProperty.DRIVER_PROPERTY.getTitle(), this._driverComponent);
    }

    private Component createPasswordComponent() {
        this._passwordComponent = ComponentFactory.createPasswordField();
        String string = DatabaseKnowledgeBaseFactory.getPassword(this.getSources());
        this._passwordComponent.setText(string);
        return new LabeledComponent(DatabaseProperty.PASSWORD_PROPERTY.getTitle(), this._passwordComponent);
    }

    private Component createTableNameComponent() {
        this._tableNameComponent = ComponentFactory.createTextField();
        String string = DatabaseKnowledgeBaseFactory.getTableName(this.getSources());
        if (string == null) {
            string = this.getDefaultTableName();
        }
        this._tableNameComponent.setText(string);
        return new LabeledComponent(DatabaseProperty.TABLENAME_PROPERTY.getTitle(), this._tableNameComponent);
    }

    private Component createURLComponent() {
        this._urlComponent = ComponentFactory.createTextField();
        String string = DatabaseKnowledgeBaseFactory.getURL(this.getSources());
        if (string == null) {
            string = DatabaseProperty.getProperty(DatabaseProperty.URL_PROPERTY);
        }
        this._urlComponent.setText(string);
        return new LabeledComponent(DatabaseProperty.URL_PROPERTY.getTitle(), this._urlComponent);
    }

    private Component createUsernameComponent() {
        this._usernameComponent = ComponentFactory.createTextField();
        String string = DatabaseKnowledgeBaseFactory.getUsername(this.getSources());
        if (string == null) {
            string = DatabaseProperty.getProperty(DatabaseProperty.USERNAME_PROPERTY);
        }
        if (string == null) {
            string = SystemUtilities.getUserName();
        }
        this._usernameComponent.setText(string);
        return new LabeledComponent(DatabaseProperty.USERNAME_PROPERTY.getTitle(), this._usernameComponent);
    }

    private String getDefaultTableName() {
        String string;
        String string2 = DatabaseProperty.getProperty(DatabaseProperty.TABLENAME_PROPERTY);
        if (string2 == null && (string = this.getProjectPath()) != null) {
            string2 = FileUtilities.getBaseName(string);
        }
        if (string2 == null) {
            string2 = DatabaseProperty.TABLENAME_PROPERTY.getDefaultValue();
        }
        return string2;
    }

    protected void onProjectURIChange(URI uRI, URI uRI2) {
    }

    public void saveContents() {
        String string = this._driverComponent.getText();
        DatabaseKnowledgeBaseFactory.setDriver(this.getSources(), string);
        DatabaseProperty.setProperty(DatabaseProperty.DRIVER_PROPERTY, string);
        String string2 = this._urlComponent.getText();
        DatabaseKnowledgeBaseFactory.setURL(this.getSources(), string2);
        DatabaseProperty.setProperty(DatabaseProperty.URL_PROPERTY, string2);
        String string3 = this._tableNameComponent.getText();
        DatabaseKnowledgeBaseFactory.setTablename(this.getSources(), string3);
        DatabaseProperty.setProperty(DatabaseProperty.TABLENAME_PROPERTY, string3);
        String string4 = this._usernameComponent.getText();
        DatabaseKnowledgeBaseFactory.setUsername(this.getSources(), string4);
        DatabaseProperty.setProperty(DatabaseProperty.USERNAME_PROPERTY, string4);
        DatabaseKnowledgeBaseFactory.setPassword(this.getSources(), this._passwordComponent.getText());
    }

    public boolean validateContents() {
        boolean bl = true;
        String string = this._driverComponent.getText();
        Class clazz = SystemUtilities.forName(string);
        if (clazz == null) {
            bl = false;
            String string2 = LocalizedText.getText(ResourceKey.DATABASE_CONFIGURE_FAILED_DIALOG_DRIVER_NOT_FOUND_TEXT);
            this.complain(string2);
        } else {
            try {
                String string3 = this._urlComponent.getText();
                String string4 = this._usernameComponent.getText();
                String string5 = this._passwordComponent.getText();
                Connection connection = DriverManager.getConnection(string3, string4, string5);
                bl = this.confirmOverwriteIfNecessary(connection);
                connection.close();
            }
            catch (SQLException sQLException) {
                bl = false;
                String string6 = LocalizedText.getText(ResourceKey.DATABASE_CONFIGURE_FAILED_DIALOG_CANNOT_CREATE_CONNECTION_TEXT, sQLException.getMessage());
                this.complain(string6);
            }
        }
        return bl;
    }

    private boolean confirmOverwriteIfNecessary(Connection connection) {
        boolean bl = true;
        String string = this._tableNameComponent.getText();
        if (this.newTable(string) && DatabaseKnowledgeBaseSourcesEditor.tableExists(connection, string)) {
            String string2 = "Table already exists.  Overwrite it?";
            int n = ModalDialog.showMessageDialog((Component)this, string2, 13);
            bl = n == 2;
        }
        return bl;
    }

    private boolean newTable(String string) {
        String string2 = DatabaseKnowledgeBaseFactory.getTableName(this.getSources());
        return !string.equals(string2);
    }

    private static boolean tableExists(Connection connection, String string) {
        boolean bl = false;
        try {
            Statement statement = connection.createStatement();
            String string2 = "SELECT COUNT(*) FROM " + string;
            ResultSet resultSet = statement.executeQuery(string2);
            resultSet.close();
            statement.close();
            bl = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private void complain(String string) {
        String string2 = LocalizedText.getText(ResourceKey.ERROR_DIALOG_TITLE);
        ModalDialog.showMessageDialog((Component)this, string, string2);
    }
}

