/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DefaultRenderer
extends JComponent
implements TreeCellRenderer,
ListCellRenderer,
TableCellRenderer {
    private static final long serialVersionUID = -5077332037549517658L;
    public static final Object DROP_TARGET = new Object();
    public static final Object DROP_TARGET_AREA = new Object();
    public static final Object DROP_TARGET_AREA_ON = new Object();
    public static final Object DROP_TARGET_AREA_BELOW = new Object();
    public static final Object DROP_TARGET_AREA_ABOVE = new Object();
    protected Color _backgroundNormalColor;
    protected Color _foregroundNormalColor;
    protected Color _backgroundSelectionColor;
    protected Color _foregroundSelectionColor;
    protected Color _backgroundSelectionColorOverride;
    private static final int ICON_TEXT_GAP = 3;
    private static final int TEXT_ICON_GAP = 0;
    private static final int ICON_ICON_GAP = 0;
    private static final int TEXT_TEXT_GAP = 0;
    protected FontMetrics _fontMetrics;
    protected LookAndFeel _cachedLookAndFeel;
    protected boolean _hasFocus;
    protected boolean _isSelected;
    protected boolean _grayedText;
    protected boolean _grayedSecondaryText = true;
    protected Color _focusRectColor = Color.GRAY;
    protected List _elements = new ArrayList();
    protected Object _dropTargetArea;
    protected Color _dropTargetLineColor = Color.black;
    protected Color _treeForegroundSelectionColor;
    protected Color _treeBackgroundSelectionColor;
    protected Color _treeForegroundNormalColor;
    protected Color _treeBackgroundNormalColor;
    protected JTree _tree;
    protected int _row;
    protected Object _value;
    private boolean gettingRowBounds;

    public DefaultRenderer() {
        this.loadTreeColors();
    }

    public void setBackgroundSelectionColor(Color color) {
        this._backgroundSelectionColorOverride = color;
    }

    protected void checkDropTarget(Component component, Object object) {
        DropTarget dropTarget = component.getDropTarget();
        if (dropTarget != null && dropTarget.isActive()) {
            Object object2 = ((JComponent)component).getClientProperty(DROP_TARGET);
            this._dropTargetArea = DefaultRenderer.equals(object2, object) ? ((JComponent)component).getClientProperty(DROP_TARGET_AREA) : null;
        }
    }

    protected Object getValue() {
        return this._value;
    }

    protected void setFontStyle(int n) {
        this.setFont(this.getFont().deriveFont(n));
    }

    protected Color getBackgroundColor() {
        return this._isSelected ? this.getBackgroundSelectionColor() : this._backgroundNormalColor;
    }

    protected Color getBackgroundSelectionColor() {
        return this._backgroundSelectionColorOverride == null ? this._backgroundSelectionColor : this._backgroundSelectionColorOverride;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this._foregroundSelectionColor = jList.getSelectionForeground();
        this._backgroundSelectionColor = jList.getSelectionBackground();
        this._foregroundNormalColor = jList.getForeground();
        this._backgroundNormalColor = jList.getBackground();
        return this.setup(jList, object, bl2, bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, this._fontMetrics.getHeight());
        Object var2_2 = null;
        for (Object object : this._elements) {
            dimension.width += DefaultRenderer.getGap(var2_2, object);
            this.updateSize(dimension, object);
            var2_2 = object;
        }
        if (this._tree != null && !this.gettingRowBounds) {
            Object object;
            this.gettingRowBounds = true;
            object = this._tree.getRowBounds(this._row);
            if (object != null) {
                dimension.width = Math.max(dimension.width, DefaultRenderer.getNiceWidth(this._tree, ((Rectangle)object).x));
            }
            this.gettingRowBounds = false;
        }
        return dimension;
    }

    private static int getNiceWidth(JComponent jComponent, int n) {
        int n2;
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, jComponent);
        if (jViewport != null) {
            Rectangle rectangle = jViewport.getViewRect();
            n2 = rectangle.x + rectangle.width - n;
        } else {
            n2 = jComponent.getWidth() - n;
        }
        return n2;
    }

    private static int getGap(Object object, Object object2) {
        int n = object == null ? (object2 instanceof String ? 3 : 0) : (object instanceof Icon ? (object2 instanceof Icon ? 0 : 3) : (object2 instanceof Icon ? 0 : 0));
        return n;
    }

    private void updateSize(Dimension dimension, Object object) {
        if (object instanceof Icon) {
            DefaultRenderer.updatePreferredSize(dimension, (Icon)object);
        } else if (object instanceof String) {
            this.updatePreferredSize(dimension, (String)object);
        } else {
            Log.getLogger().warning("Strange thing in element list: " + object);
        }
    }

    private static void updatePreferredSize(Dimension dimension, Icon icon) {
        dimension.width += icon.getIconHeight();
        dimension.height = Math.max(dimension.height, icon.getIconHeight());
    }

    private void updatePreferredSize(Dimension dimension, String string) {
        dimension.width += this._fontMetrics.stringWidth(string);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this._foregroundSelectionColor = jTable.getSelectionForeground();
        this._backgroundSelectionColor = jTable.getSelectionBackground();
        this._foregroundNormalColor = jTable.getForeground();
        this._backgroundNormalColor = jTable.getBackground();
        return this.setup(jTable, object, bl2, bl);
    }

    protected Color getTextColor() {
        Color color = this._isSelected ? (this._backgroundSelectionColorOverride == null ? this._foregroundSelectionColor : this._foregroundNormalColor) : (this._grayedText ? Color.darkGray : this._foregroundNormalColor);
        return color;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this._foregroundSelectionColor = this._treeForegroundSelectionColor;
        this._backgroundSelectionColor = this._treeBackgroundSelectionColor;
        this._foregroundNormalColor = this._treeForegroundNormalColor;
        this._backgroundNormalColor = this._treeBackgroundNormalColor;
        this._tree = jTree;
        this._row = n;
        return this.setup(jTree, object, bl4, bl);
    }

    public void load(Object object) {
        this.addText(object.toString());
    }

    public void loadNull() {
        this.addText("<null>");
    }

    protected void loadTreeColors() {
        this._treeForegroundSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this._treeBackgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this._treeForegroundNormalColor = UIManager.getColor("Tree.textForeground");
        this._treeBackgroundNormalColor = UIManager.getColor("Tree.textBackground");
    }

    public void paint(Graphics graphics) {
        Object object;
        ComponentUtilities.enableTextAntialiasing(graphics);
        graphics.setFont(this.getFont());
        this._fontMetrics = graphics.getFontMetrics();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getTextColor());
        Point point = new Point();
        Object var4_4 = null;
        boolean bl = false;
        for (Object e : this._elements) {
            point.x += DefaultRenderer.getGap(var4_4, e);
            if (e instanceof Icon) {
                this.paintIcon(graphics, (Icon)e, point, dimension);
            } else if (e instanceof String) {
                object = null;
                if (bl && this._grayedSecondaryText) {
                    object = Color.gray;
                }
                this.paintString(graphics, (String)e, point, (Color)object, dimension);
                bl = true;
            }
            var4_4 = e;
        }
        if (point.x > dimension.width + 1) {
            int n = 0;
            object = "...";
            int n2 = this._fontMetrics.stringWidth((String)object);
            graphics.setColor(this.getBackgroundColor());
            graphics.fillRect(dimension.width - n2, n, n2, dimension.height);
            graphics.setColor(this.getTextColor());
            graphics.drawString((String)object, dimension.width - n2, n + this._fontMetrics.getAscent());
        }
        if (this._hasFocus) {
            graphics.setColor(this._focusRectColor);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        if (this._dropTargetArea == DROP_TARGET_AREA_ON) {
            graphics.setColor(this._dropTargetLineColor);
            graphics.drawRect(0, 0, point.x - 1, dimension.height - 1);
        } else if (this._dropTargetArea == DROP_TARGET_AREA_BELOW) {
            graphics.setColor(this._dropTargetLineColor);
            int n = dimension.height - 1;
            graphics.drawLine(0, n, dimension.width - 1, n);
        } else if (this._dropTargetArea == DROP_TARGET_AREA_ABOVE) {
            graphics.setColor(this._dropTargetLineColor);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
        }
    }

    protected void paintIcon(Graphics graphics, Icon icon, Point point, Dimension dimension) {
        int n = (dimension.height - icon.getIconHeight()) / 2;
        icon.paintIcon(this, graphics, point.x, n);
        point.x += icon.getIconWidth();
    }

    protected void paintString(Graphics graphics, String string, Point point, Dimension dimension) {
        this.paintString(graphics, string, point, null, dimension);
    }

    protected void paintString(Graphics graphics, String string, Point point, Color color, Dimension dimension) {
        if (color != null) {
            graphics.setColor(color);
        }
        int n = (dimension.height + this._fontMetrics.getAscent()) / 2 - 2;
        graphics.drawString(string, point.x, n);
        point.x += this._fontMetrics.stringWidth(string);
    }

    public void setForegroundColorOverride(Color color) {
        this._foregroundNormalColor = color;
        this._foregroundSelectionColor = color;
    }

    public void setGrayedText(boolean bl) {
        this._grayedText = bl;
    }

    public void setGrayedSecondaryText(boolean bl) {
        this._grayedSecondaryText = bl;
    }

    public void setInvalid() {
    }

    public String getMainText() {
        return (String)this.getFirst(String.class);
    }

    public Icon getMainIcon() {
        return (Icon)this.getFirst(Icon.class);
    }

    public int getIconTextGap() {
        return 3;
    }

    public int getTextIconGap() {
        return 0;
    }

    public int getTextTextGap() {
        return 0;
    }

    public int getIconIconGap() {
        return 0;
    }

    public Object getFirst(Class clazz) {
        Object var2_2 = null;
        for (Object e : this._elements) {
            if (!clazz.isInstance(e)) continue;
            var2_2 = e;
            break;
        }
        return var2_2;
    }

    private static int indexOfClass(List list, Class clazz) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(0);
            if (!clazz.isInstance(e)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setMainIcon(Icon icon) {
        int n = DefaultRenderer.indexOfClass(this._elements, Icon.class);
        if (n == 0) {
            this._elements.remove(n);
        }
        if (icon != null) {
            this._elements.add(0, icon);
        }
    }

    public void setMainText(String string) {
        int n = DefaultRenderer.indexOfClass(this._elements, String.class);
        if (n == 0 || n == 1) {
            this._elements.remove(n);
        }
        this.addText(string);
    }

    public void appendIcon(Icon icon) {
        this.addIcon(icon);
    }

    public void appendText(String string) {
        this.addText(string);
    }

    public void addIcon(Icon icon) {
        if (icon != null) {
            this._elements.add(icon);
        }
    }

    public void addText(String string) {
        if (string != null) {
            this._elements.add(string);
        }
    }

    public void setNormalForegroundColor(Color color) {
        this._foregroundNormalColor = color;
    }

    protected void loadDuplicate(Object object) {
        this.load(object);
    }

    protected Component setup(Component component, Object object, boolean bl, boolean bl2) {
        Object object2;
        this._grayedText = false;
        this._value = object;
        Font font = component.getFont();
        if (font.isBold()) {
            font = font.deriveFont(0);
        }
        this.setFont(font);
        this._hasFocus = bl;
        this._isSelected = bl2;
        this._elements.clear();
        if (object == null) {
            this.loadNull();
        } else if (object instanceof LazyTreeNode) {
            object2 = (LazyTreeNode)object;
            Object object3 = ((LazyTreeNode)object2).getUserObject();
            if (((LazyTreeNode)object2).isDuplicate()) {
                this.loadDuplicate(object3);
            } else {
                this.load(object3);
            }
        } else {
            this.load(object);
        }
        this._fontMetrics = this.getFontMetrics(this.getFont());
        object2 = UIManager.getLookAndFeel();
        if (object2 != this._cachedLookAndFeel) {
            this.loadTreeColors();
            this._cachedLookAndFeel = object2;
            this._focusRectColor = this._cachedLookAndFeel instanceof MetalLookAndFeel ? MetalLookAndFeel.getFocusColor() : Color.GRAY;
        }
        this.checkDropTarget(component, object);
        return this;
    }

    public void clear() {
        this._elements.clear();
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public boolean isOpaque() {
        return true;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void invalidate() {
    }

    public void repaint() {
    }

    public void repaint(int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, Object object, Object object2) {
    }
}

