/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMap<X, Y> {
    private Map<X, Collection<Y>> _map;

    protected MultiMap() {
        this(11);
    }

    protected MultiMap(int n) {
        this._map = new HashMap<X, Collection<Y>>(n);
    }

    public void addValue(X x, Y y) {
        Collection<Y> collection = this._map.get(x);
        if (collection == null) {
            collection = this.createCollection();
            this._map.put(x, collection);
        }
        collection.add(y);
    }

    public void addValues(X x, Collection<Y> collection) {
        Collection<Y> collection2 = this._map.get(x);
        if (collection2 == null) {
            collection2 = this.createCollection();
            this._map.put(x, collection2);
        }
        collection2.addAll(collection);
    }

    public abstract Collection<Y> createCollection();

    public Collection<X> getKeys() {
        return this._map.keySet();
    }

    public Collection<Y> getValues(X x) {
        return this._map.get(x);
    }

    public Collection<Y> removeKey(X x) {
        return this._map.remove(x);
    }

    public void removeValue(X x, Y y) {
        boolean bl;
        Collection<Y> collection = this._map.get(x);
        if (collection != null && !(bl = collection.remove(y))) {
            Log.getLogger().warning("value not found: " + y);
        }
    }

    public void removeValues(X x, Collection<Y> collection) {
        Collection<Y> collection2 = this._map.get(x);
        collection2.removeAll(collection);
    }

    public void clear() {
        this._map.clear();
    }
}

