/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.util.Log;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulateDelayOutputStream
extends FilterOutputStream {
    static Logger log = Log.getLogger(SimulateDelayOutputStream.class);
    private static int KB = 1024;
    private OutputStream os;
    private int bandwidth = ServerProperties.getKiloBytesPerSecondUpload();
    private int bytesWritten = 0;

    public SimulateDelayOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.os = outputStream;
    }

    public void write(int n) throws IOException {
        this.os.write(n);
        this.delayForDownLoad(1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.delayForDownLoad(n2);
    }

    private synchronized void delayForDownLoad(int n) {
        int n2;
        this.bytesWritten += n;
        if (this.bandwidth != 0 && (n2 = this.bytesWritten / (this.bandwidth * KB)) > 0) {
            this.bytesWritten -= n2 * this.bandwidth * KB;
            try {
                Thread.sleep(1000 * n2);
                log.info("Simulated " + n2 + " seconds of download delay");
            }
            catch (InterruptedException interruptedException) {
                log.log(Level.WARNING, "Simulation of network delay failed", interruptedException);
            }
        }
    }
}

