/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.DefaultRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OtherFacetsRenderer
extends DefaultRenderer {
    private static void addAllowedValuesText(StringBuffer stringBuffer, Cls cls, Slot slot) {
        if (OtherFacetsRenderer.equals(cls.getTemplateSlotValueType(slot), ValueType.SYMBOL)) {
            Collection collection = cls.getTemplateSlotAllowedValues(slot);
            OtherFacetsRenderer.appendValues(stringBuffer, "allowed-values", collection);
        }
    }

    private static void addDefaultValuesText(StringBuffer stringBuffer, Cls cls, Slot slot) {
        Collection collection = cls.getTemplateSlotDefaultValues(slot);
        if (!collection.isEmpty()) {
            OtherFacetsRenderer.addObjects(stringBuffer, "default", collection);
        }
    }

    private static void addObjects(StringBuffer stringBuffer, String string, Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            String string2 = e instanceof Frame ? ((Frame)e).getBrowserText() : e.toString();
            arrayList.add(string2);
        }
        OtherFacetsRenderer.appendValues(stringBuffer, string, arrayList);
    }

    private static void addRangeText(StringBuffer stringBuffer, Cls cls, Slot slot, ValueType valueType) {
        Number number = cls.getTemplateSlotMinimumValue(slot);
        Number number2 = cls.getTemplateSlotMaximumValue(slot);
        if (OtherFacetsRenderer.equals(valueType, ValueType.INTEGER)) {
            if (number != null) {
                number = new Integer(number.intValue());
            }
            if (number2 != null) {
                number2 = new Integer(number2.intValue());
            }
        }
        if (number != null) {
            stringBuffer.append("minimum=");
            stringBuffer.append(number);
        }
        if (number != null && number2 != null) {
            stringBuffer.append(", ");
        }
        if (number2 != null) {
            stringBuffer.append("maximum=");
            stringBuffer.append(number2);
        }
        if (number != null || number2 != null) {
            stringBuffer.append(' ');
        }
    }

    private static void addValuesText(StringBuffer stringBuffer, Cls cls, Slot slot) {
        Collection collection = cls.getTemplateSlotValues(slot);
        if (!collection.isEmpty()) {
            OtherFacetsRenderer.addObjects(stringBuffer, "value", collection);
        }
    }

    private static void appendValues(StringBuffer stringBuffer, String string, Collection collection) {
        boolean bl = true;
        stringBuffer.append(string);
        stringBuffer.append("=");
        if (collection.size() > 1) {
            stringBuffer.append("{");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(iterator.next());
        }
        if (collection.size() > 1) {
            stringBuffer.append("}");
        }
        stringBuffer.append(" ");
    }

    private static void addInverseSlotText(StringBuffer stringBuffer, Slot slot) {
        Slot slot2 = slot.getInverseSlot();
        if (slot2 != null) {
            stringBuffer.append("inverse-slot=");
            stringBuffer.append(slot2.getBrowserText());
            stringBuffer.append(" ");
        }
    }

    public void load(Object object) {
        FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        ValueType valueType = cls.getTemplateSlotValueType(slot);
        StringBuffer stringBuffer = new StringBuffer();
        if (OtherFacetsRenderer.equals(valueType, ValueType.INTEGER) || OtherFacetsRenderer.equals(valueType, ValueType.FLOAT)) {
            OtherFacetsRenderer.addRangeText(stringBuffer, cls, slot, valueType);
        } else if (OtherFacetsRenderer.equals(valueType, ValueType.SYMBOL)) {
            OtherFacetsRenderer.addAllowedValuesText(stringBuffer, cls, slot);
        }
        OtherFacetsRenderer.addValuesText(stringBuffer, cls, slot);
        OtherFacetsRenderer.addDefaultValuesText(stringBuffer, cls, slot);
        OtherFacetsRenderer.addInverseSlotText(stringBuffer, slot);
        if (!cls.isEditable()) {
            this.setGrayedText(true);
        }
        this.setMainText(stringBuffer.toString());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }
}

