/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerPanel;
import edu.stanford.smi.protege.server.ServerProjectPanel;
import edu.stanford.smi.protege.server.admin.ServerAdminPanel;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.Naming;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class RemoteProjectManager {
    private static RemoteProjectManager _theInstance;

    public static RemoteProjectManager getInstance() {
        if (_theInstance == null) {
            _theInstance = new RemoteProjectManager();
        }
        return _theInstance;
    }

    public Project getRemoteProject() {
        JComponent jComponent = ProjectManager.getProjectManager().getMainPanel();
        Project project = null;
        RemoteServer remoteServer = null;
        RemoteSession remoteSession = null;
        ServerPanel serverPanel = new ServerPanel();
        String string = LocalizedText.getText(ResourceKey.REMOTE_HOST_CONNECT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(jComponent, serverPanel, string, 11);
        if (n == 1) {
            remoteServer = serverPanel.getServer();
            remoteSession = serverPanel.getSession();
            if (remoteServer != null && remoteSession != null) {
                if (serverPanel.isAdminsterServerActivated()) {
                    this.showServerAdminWindow(remoteServer, remoteSession);
                } else {
                    project = this.getServerProject(jComponent, remoteServer, remoteSession);
                }
            }
        }
        return project;
    }

    public Project getServerProject(JComponent jComponent, RemoteServer remoteServer, RemoteSession remoteSession) {
        String string;
        Project project = null;
        ServerProjectPanel serverProjectPanel = new ServerProjectPanel(remoteServer, remoteSession);
        String string2 = LocalizedText.getText(ResourceKey.REMOTE_PROJECT_SELECT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(jComponent, serverProjectPanel, string2, 11);
        if (n == 1 && (string = serverProjectPanel.getProjectName()) != null) {
            project = this.connectToProject(remoteServer, remoteSession, string);
        }
        return project;
    }

    public Project getProject(String string, String string2, String string3, String string4, boolean bl) {
        Project project = null;
        try {
            RemoteServerProject remoteServerProject;
            RemoteSession remoteSession;
            RemoteServer remoteServer = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            if (remoteServer != null && (remoteSession = remoteServer.openSession(string2, SystemUtilities.getMachineIpAddress(), string3)) != null && (remoteServerProject = remoteServer.openProject(string4, remoteSession)) != null) {
                project = RemoteClientProject.createProject(remoteServer, remoteServerProject, remoteSession, bl);
            }
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return project;
    }

    public Project connectToProject(RemoteServer remoteServer, RemoteSession remoteSession, String string) {
        Project project = null;
        try {
            RemoteServerProject remoteServerProject = remoteServer.openProject(string, remoteSession);
            if (remoteServerProject == null) {
                Log.getLogger().warning("Could not open project " + string + " on server.");
                return null;
            }
            project = RemoteClientProject.createProject(remoteServer, remoteServerProject, remoteSession, true);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not connect to remote project " + string, exception);
        }
        return project;
    }

    public MetaProject connectToMetaProject(RemoteServer remoteServer, RemoteSession remoteSession) {
        Project project = null;
        try {
            RemoteServerProject remoteServerProject = remoteServer.openMetaProject(remoteSession);
            if (remoteServerProject == null) {
                Log.getLogger().warning("Could not open meta project on server.");
                return null;
            }
            project = RemoteClientProject.createProject(remoteServer, remoteServerProject, remoteSession, true);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not connect to remote meta project ", exception);
        }
        return project == null ? null : new MetaProjectImpl(project);
    }

    public void showServerAdminWindow(RemoteServer remoteServer, RemoteSession remoteSession) {
        ProjectManager.getProjectManager().setExitVMOnApplicationExit(false);
        ProjectManager.getProjectManager().exitApplicationRequest();
        JFrame jFrame = ComponentFactory.showInFrame(new ServerAdminPanel(remoteServer, remoteSession), "Administer Protege Server (Logged in as " + remoteSession.getUserName() + ")");
        jFrame.setDefaultCloseOperation(3);
        jFrame.requestFocus();
        ProjectManager.getProjectManager().setExitVMOnApplicationExit(true);
    }
}

