/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database.pool;

import edu.stanford.smi.protege.storage.database.pool.ConnectionInfo;
import edu.stanford.smi.protege.storage.database.pool.DatabaseParam;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionPool {
    private static Logger log = Log.getLogger(ConnectionPool.class);
    private static Map<DatabaseParam, ConnectionPool> connectionPoolMap = new HashMap<DatabaseParam, ConnectionPool>();
    public static final String PROPERTY_REFRESH_CONNECTIONS_TIME = "Database.refresh.connections.interval";
    public static final String PROPERTY_MAX_DB_CONNECTIONS = "Database.max.connections";
    public static final String PROPERTY_LONG_RUNNING_CONNECTIONS = "Database.long.running.connection.time";
    private static long connectionRefreshInterval;
    private static int maxOpenConnections;
    private static long connectionLongTime;
    private String driver;
    private String url;
    private String username;
    private String password;
    private int referenceCount = 0;
    private Set<Connection> idleConnections = new HashSet<Connection>();
    private Map<Connection, ConnectionInfo> connectionInfoMap = new HashMap<Connection, ConnectionInfo>();
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Protege Connection Reaper");
            thread.setDaemon(true);
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionPool getConnectionPool(String string, String string2, String string3, String string4) {
        ConnectionPool connectionPool;
        Map<DatabaseParam, ConnectionPool> map = connectionPoolMap;
        synchronized (map) {
            DatabaseParam databaseParam = new DatabaseParam(string, string2, string3, string4);
            connectionPool = connectionPoolMap.get(databaseParam);
            if (connectionPool == null) {
                connectionPool = new ConnectionPool(string, string2, string3, string4);
                connectionPoolMap.put(databaseParam, connectionPool);
            }
        }
        connectionPool.reference();
        return connectionPool;
    }

    private ConnectionPool(String string, String string2, String string3, String string4) {
        Class clazz = SystemUtilities.forName(string);
        if (clazz == null) {
            throw new RuntimeException("class not found: " + string);
        }
        this.driver = string;
        this.url = string2;
        this.username = string3;
        this.password = string4;
        this.executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ConnectionPool.this.cleanup();
                ConnectionPool.this.setReaperThreadName();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(Connection connection) {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.get(connection);
        }
        return connectionInfo != null ? connectionInfo.getId() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object;
        Connection connection = null;
        Object object2 = this;
        synchronized (object2) {
            if (!this.idleConnections.isEmpty()) {
                connection = this.idleConnections.iterator().next();
                this.idleConnections.remove(connection);
            }
        }
        if (connection == null) {
            connection = DriverManager.getConnection(this.url, this.username, this.password);
            object2 = new ConnectionInfo(connection);
            object = this;
            synchronized (object) {
                this.connectionInfoMap.put(connection, (ConnectionInfo)object2);
            }
        }
        object2 = this;
        synchronized (object2) {
            object = this.connectionInfoMap.get(connection);
            ((ConnectionInfo)object).touch();
            if (connectionLongTime > 0L) {
                ((ConnectionInfo)object).setInformedUserOfLongConnectionTime(false);
                ((ConnectionInfo)object).setConnectionCallStack(new Exception("getConnection stack trace"));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            object2 = this.connectionInfoMap.get(connection);
            log.fine("Thread " + Thread.currentThread() + " caller allocated Connection with id = " + ((ConnectionInfo)object2).getId());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetConnection(Connection connection) {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.get(connection);
            if (connectionInfo == null) {
                throw new IllegalStateException("Returning connection to the wrong pool");
            }
            this.idleConnections.add(connection);
            connectionInfo.touch();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Thread " + Thread.currentThread() + " deallocated connection with id = " + connectionInfo.getId());
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.get(connection);
            if (connectionInfo == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            connectionInfo.touch();
        }
        return connectionInfo.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(Connection connection, String string) throws SQLException {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.get(connection);
            if (connectionInfo == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            connectionInfo.touch();
        }
        return connectionInfo.getPreparedStatement(string);
    }

    public void reference() {
        ++this.referenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dereference() throws SQLException {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            Map<DatabaseParam, ConnectionPool> map = connectionPoolMap;
            synchronized (map) {
                DatabaseParam object = new DatabaseParam(this.driver, this.url, this.username, this.password);
                connectionPoolMap.remove(object);
            }
            this.executor.shutdownNow();
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                connectionInfo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatements(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.get(connection);
            if (connectionInfo == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
        }
        connectionInfo.closeStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblem(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionInfo = this.connectionInfoMap.remove(connection);
            if (connectionInfo == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            this.idleConnections.remove(connection);
        }
        connectionInfo.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long l = System.currentTimeMillis();
        ArrayList<ConnectionInfo> arrayList = new ArrayList<ConnectionInfo>();
        Iterator iterator = this;
        synchronized (iterator) {
            for (Connection connection : this.idleConnections) {
                arrayList.add(this.connectionInfoMap.get(connection));
            }
            Collections.sort(arrayList, new Comparator<ConnectionInfo>(){

                @Override
                public int compare(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) {
                    return (int)(connectionInfo.getLastAccessTime() - connectionInfo2.getLastAccessTime());
                }
            });
        }
        for (ConnectionInfo connectionInfo : arrayList) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (l - connectionInfo.getLastAccessTime() <= connectionRefreshInterval) {
                    break;
                }
                if (!this.idleConnections.contains(connectionInfo.getConnection())) {
                    continue;
                }
                this.idleConnections.remove(connectionInfo.getConnection());
                this.connectionInfoMap.remove(connectionInfo.getConnection());
            }
            try {
                connectionInfo.close();
            }
            catch (Throwable throwable) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception caught closing connection during cleanup", throwable);
            }
        }
        for (ConnectionInfo connectionInfo : arrayList) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (this.idleConnections.size() <= maxOpenConnections) {
                    break;
                }
                if (!this.idleConnections.contains(connectionInfo.getConnection())) {
                    continue;
                }
                this.idleConnections.remove(connectionInfo.getConnection());
                this.connectionInfoMap.remove(connectionInfo.getConnection());
            }
            try {
                connectionInfo.close();
            }
            catch (Throwable throwable) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception caught closing connection during cleanup", throwable);
            }
        }
        if (connectionLongTime > 0L) {
            this.checkLongRunningConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLongRunningConnections() {
        long l = System.currentTimeMillis();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (Map.Entry<Connection, ConnectionInfo> entry : this.connectionInfoMap.entrySet()) {
                Connection connection = entry.getKey();
                ConnectionInfo connectionInfo = entry.getValue();
                if (connectionInfo.getInformedUserOfLongConnectionTime() || l - connectionInfo.getLastAccessTime() <= connectionLongTime || this.idleConnections.contains(connection)) continue;
                log.log(Level.WARNING, "Connection has been reserved but idle for a long time (" + (l - connectionInfo.getLastAccessTime()) + "ms).  Call stack follows.", connectionInfo.getConnectionCallStack());
                connectionInfo.setInformedUserOfLongConnectionTime(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReaperThreadName() {
        int n;
        int n2;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            n2 = this.connectionInfoMap.size();
            n = this.idleConnections.size();
        }
        Thread.currentThread().setName("Connection Reaper [" + n2 + ", " + n + "]");
    }

    static {
        int n = ApplicationProperties.getIntegerProperty(PROPERTY_REFRESH_CONNECTIONS_TIME, 5);
        connectionRefreshInterval = n * 60 * 1000;
        maxOpenConnections = ApplicationProperties.getIntegerProperty(PROPERTY_MAX_DB_CONNECTIONS, 3);
        n = ApplicationProperties.getIntegerProperty(PROPERTY_LONG_RUNNING_CONNECTIONS, -1);
        connectionLongTime = n * 60 * 1000;
    }
}

