/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class SimpleListModel
extends AbstractListModel {
    private static final long serialVersionUID = 4610768415608528873L;
    private List _list = this.makeList();

    public SimpleListModel() {
    }

    public SimpleListModel(Collection collection) {
        this._list.addAll(collection);
    }

    protected List makeList() {
        return new ArrayList();
    }

    protected List getList() {
        return this._list;
    }

    public int addValue(Object object) {
        int n = this._list.size();
        this._list.add(n, object);
        this.fireIntervalAdded(this, n, n);
        return n;
    }

    public void addValue(Object object, int n) {
        this._list.add(n, object);
        this.fireIntervalAdded(this, n, n);
    }

    public int addValues(Collection collection) {
        int n = this._list.size();
        int n2 = n + collection.size();
        this._list.addAll(collection);
        this.fireIntervalAdded(this, n, n2);
        return n;
    }

    public void clear() {
        if (!this._list.isEmpty()) {
            int n = this._list.size() - 1;
            this._list.clear();
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    public boolean contains(Object object) {
        return this._list.contains(object);
    }

    public Object getElementAt(int n) {
        return n >= 0 && n < this._list.size() ? this._list.get(n) : null;
    }

    public int getSize() {
        return this._list.size();
    }

    public List getValues() {
        return Collections.unmodifiableList(this._list);
    }

    public int indexOf(Object object) {
        return this._list.indexOf(object);
    }

    public void moveValue(int n, int n2) {
        if (n != n2) {
            Object e = this._list.remove(n);
            if (n2 > n) {
                --n2;
            }
            this._list.add(n2, e);
            this.fireContentsChanged(this, n, n2);
        }
    }

    public int removeValue(Object object) {
        int n = this._list.indexOf(object);
        if (n != -1) {
            this._list.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
        return n;
    }

    public int removeValues(Collection collection) {
        int n = -1;
        for (Object e : collection) {
            if (n == -1) {
                n = this.indexOf(e);
            }
            this._list.remove(e);
        }
        this.fireIntervalRemoved(this, n, n);
        return n;
    }

    public void setValue(int n, Object object) {
        this._list.set(n, object);
        this.fireContentsChanged(this, n, n);
    }

    public void setValues(Collection collection) {
        this.clear();
        if (!collection.isEmpty()) {
            this._list = new ArrayList(collection);
            this.fireIntervalAdded(this, 0, collection.size() - 1);
        }
    }

    public List toList() {
        return Collections.unmodifiableList(this._list);
    }

    public String toString() {
        return "SimpleListModel";
    }
}

