/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = -6254487290721281181L;
    private final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
    private final Map cellSizes = new HashMap();

    public TextAreaRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.adaptee.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setForeground(this.adaptee.getForeground());
        this.setBackground(this.adaptee.getBackground());
        this.setBorder(this.adaptee.getBorder());
        this.setFont(this.adaptee.getFont());
        this.setText(this.adaptee.getText());
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        this.setSize(tableColumnModel.getColumn(n2).getWidth(), 100000);
        int n3 = (int)this.getPreferredSize().getHeight();
        this.addSize(jTable, n, n2, n3);
        n3 = this.findTotalMaximumRowSize(jTable, n);
        if (n3 != jTable.getRowHeight(n)) {
            jTable.setRowHeight(n, n3);
        }
        return this;
    }

    private void addSize(JTable jTable, int n, int n2, int n3) {
        HashMap<Integer, Integer> hashMap;
        HashMap<Integer, HashMap<Integer, Integer>> hashMap2 = (HashMap<Integer, HashMap<Integer, Integer>>)this.cellSizes.get(jTable);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<Integer, HashMap<Integer, Integer>>();
            this.cellSizes.put(jTable, hashMap2);
        }
        if ((hashMap = (HashMap<Integer, Integer>)hashMap2.get(new Integer(n))) == null) {
            hashMap = new HashMap<Integer, Integer>();
            hashMap2.put(new Integer(n), hashMap);
        }
        hashMap.put(new Integer(n2), new Integer(n3));
    }

    private int findTotalMaximumRowSize(JTable jTable, int n) {
        int n2 = 0;
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (!(tableCellRenderer instanceof TextAreaRenderer)) continue;
            TextAreaRenderer textAreaRenderer = (TextAreaRenderer)tableCellRenderer;
            n2 = Math.max(n2, textAreaRenderer.findMaximumRowSize(jTable, n));
        }
        return n2;
    }

    private int findMaximumRowSize(JTable jTable, int n) {
        Map map = (Map)this.cellSizes.get(jTable);
        if (map == null) {
            return 0;
        }
        Map map2 = (Map)map.get(new Integer(n));
        if (map2 == null) {
            return 0;
        }
        int n2 = 0;
        for (Map.Entry entry : map2.entrySet()) {
            int n3 = (Integer)entry.getValue();
            n2 = Math.max(n2, n3);
        }
        return n2;
    }
}

