/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameStore_Test
extends SimpleTestCase {
    private static transient Logger log = Log.getLogger(FrameStore_Test.class);
    private DefaultKnowledgeBase _kb;
    private FrameStore _testFrameStore;
    private FrameStore _modifiableFrameStore;
    private boolean _initialized = false;

    protected FrameStore_Test() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._kb = new DefaultKnowledgeBase();
        this._testFrameStore = this.createFrameStore(this._kb);
        this._modifiableFrameStore = this.getModifiableFrameStore(this._kb);
        if (this._testFrameStore != null && this._modifiableFrameStore != null) {
            this._initialized = true;
        }
        if (this._testFrameStore instanceof RemoteClientFrameStore) {
            this._kb.setGenerateEventsEnabled(false);
        }
        this._kb.setTerminalFrameStore(this._testFrameStore);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._kb.close();
        this._kb = null;
        this._testFrameStore = null;
        this._modifiableFrameStore = null;
    }

    protected FrameStore getTestFrameStore() {
        return this._testFrameStore;
    }

    protected abstract FrameStore createFrameStore(DefaultKnowledgeBase var1);

    protected FrameStore getModifiableFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        return this._testFrameStore;
    }

    protected static String createFrameName() {
        return "Frame_" + Math.random();
    }

    protected Cls createCls() {
        Cls cls = (Cls)this.getFrame(":THING");
        FrameStore_Test.assertNotNull((String)"thing", (Object)cls);
        return this.createCls(cls);
    }

    protected Slot createSlot(Slot slot) {
        return this.createSlot(null, FrameStore_Test.makeList(slot));
    }

    protected Slot createSlotOnCls(Cls cls) {
        Slot slot = this.createSlot();
        this.addTemplateSlot(cls, slot);
        return slot;
    }

    protected Slot createSlotOnCls(Cls cls, ValueType valueType, boolean bl) {
        Slot slot = this.createSlotOnCls(cls);
        this.setTypeAndCardinality(slot, valueType, bl);
        return slot;
    }

    private void setTypeAndCardinality(Slot slot, ValueType valueType, boolean bl) {
        Instance instance;
        Slot slot2 = (Slot)this._testFrameStore.getFrame(":SLOT-VALUE-TYPE");
        if (FrameStore_Test.equals(valueType, ValueType.INSTANCE)) {
            instance = (Cls)this._testFrameStore.getFrame(":THING");
            this._modifiableFrameStore.setDirectOwnSlotValues(slot, slot2, FrameStore_Test.makeList(valueType.toString(), instance));
        } else {
            this._modifiableFrameStore.setDirectOwnSlotValues(slot, slot2, FrameStore_Test.makeList(valueType.toString()));
        }
        instance = (Slot)this._testFrameStore.getFrame(":SLOT-MAXIMUM-CARDINALITY");
        Set<Integer> set = bl ? Collections.EMPTY_SET : Collections.singleton(new Integer(1));
        this._modifiableFrameStore.setDirectOwnSlotValues(slot, (Slot)instance, set);
    }

    protected Slot createSlotOnCls(Cls cls, Cls cls2) {
        Slot slot = this.createSlot(null, Collections.EMPTY_SET, cls2);
        this.addTemplateSlot(cls, slot);
        return slot;
    }

    protected void addTemplateSlot(Cls cls, Slot slot) {
        this._modifiableFrameStore.addDirectTemplateSlot(cls, slot);
    }

    protected SimpleInstance createSimpleInstance(Cls cls) {
        return this.createSimpleInstance(null, cls);
    }

    private static FrameID getID(String string) {
        if (string == null) {
            string = FrameStore_Test.createFrameName();
        }
        return new FrameID(string);
    }

    protected SimpleInstance createSimpleInstance(String string, Cls cls) {
        List list = FrameStore_Test.makeList(cls);
        return this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(string), list, true);
    }

    protected Cls createCls(Cls cls) {
        Cls cls2 = (Cls)this._testFrameStore.getFrame(":STANDARD-CLASS");
        FrameStore_Test.assertNotNull((String)"directType", (Object)cls2);
        List list = FrameStore_Test.makeList(cls2);
        List list2 = FrameStore_Test.makeList(cls);
        return this._modifiableFrameStore.createCls(FrameStore_Test.getID(FrameStore_Test.createFrameName()), list, list2, true);
    }

    protected Slot createSlot() {
        return this.createSlot((String)null);
    }

    protected Slot createSlot(String string) {
        return this.createSlot(string, Collections.EMPTY_LIST);
    }

    protected Slot createSlot(String string, Collection collection) {
        Cls cls = (Cls)this._testFrameStore.getFrame(":STANDARD-SLOT");
        return this.createSlot(string, collection, cls);
    }

    protected Slot createSlot(String string, Collection collection, Cls cls) {
        List list = FrameStore_Test.makeList(cls);
        return this._modifiableFrameStore.createSlot(FrameStore_Test.getID(string), list, collection, true);
    }

    protected Facet createFacet() {
        return this.createFacet(ValueType.STRING);
    }

    protected Facet createFacet(ValueType valueType) {
        Cls cls = (Cls)this._testFrameStore.getFrame(":STANDARD-FACET");
        return this.createFacet(valueType, cls);
    }

    protected Facet createFacet(ValueType valueType, Cls cls) {
        List list = FrameStore_Test.makeList(cls);
        Facet facet = this._modifiableFrameStore.createFacet(FrameStore_Test.getID(null), list, true);
        Cls cls2 = (Cls)this._testFrameStore.getFrame(":STANDARD-SLOT");
        Cls cls3 = this.createCls(cls2);
        Slot slot = this.createSlotOnCls(cls3);
        this.setTypeAndCardinality(slot, valueType, true);
        Slot slot2 = (Slot)this._testFrameStore.getFrame(":ASSOCIATED-FACET");
        this._modifiableFrameStore.setDirectOwnSlotValues(slot, slot2, FrameStore_Test.makeList(facet));
        return facet;
    }

    protected Frame getFrame(String string) {
        return this._testFrameStore.getFrame(string);
    }

    protected int getFrameCount() {
        return this._testFrameStore.getFrameCount();
    }

    protected String getName(Frame frame) {
        return this._testFrameStore.getFrameName(frame);
    }

    protected void setOwnSlotValue(Frame frame, Slot slot, Object object) {
        Collection<Object> collection = CollectionUtilities.createCollection(object);
        this._modifiableFrameStore.setDirectOwnSlotValues(frame, slot, collection);
    }

    public void testClosure() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        SimpleInstance simpleInstance3 = this.createSimpleInstance(cls);
        HashSet<Instance> hashSet = new HashSet<Instance>();
        hashSet.add(simpleInstance2);
        hashSet.add(simpleInstance3);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, hashSet);
        Cls cls2 = this.createCls();
        Cls cls3 = this.createCls();
        SimpleInstance simpleInstance4 = this.createSimpleInstance(cls2);
        hashSet = new HashSet();
        hashSet.add(cls2);
        hashSet.add(cls3);
        hashSet.add(simpleInstance4);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance2, slot, hashSet);
        SimpleInstance simpleInstance5 = this.createSimpleInstance(cls3);
        hashSet = new HashSet();
        hashSet.add(simpleInstance5);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance3, slot, hashSet);
        HashSet<Instance> hashSet2 = new HashSet<Instance>();
        hashSet2.add(simpleInstance2);
        hashSet2.add(simpleInstance3);
        hashSet2.add(cls2);
        hashSet2.add(cls3);
        hashSet2.add(simpleInstance4);
        hashSet2.add(simpleInstance5);
        Set set = this._kb.getDirectOwnSlotValuesClosure(simpleInstance, slot);
        FrameStore_Test.assertTrue((boolean)((Object)set).equals(hashSet2));
        if (this._testFrameStore instanceof RemoteClientFrameStore) {
            int n = 10;
            this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
            ((RemoteClientFrameStore)this._testFrameStore).flushCache();
            while (n-- > 0) {
                set = this._kb.getDirectOwnSlotValuesClosure(simpleInstance, slot);
                FrameStore_Test.assertTrue((boolean)((Object)set).equals(hashSet2));
            }
        }
    }

    public void testCreateCls() {
        if (!this._initialized) {
            return;
        }
        String string = FrameStore_Test.createFrameName();
        Cls cls = (Cls)this._testFrameStore.getFrame(":STANDARD-CLASS");
        Assert.assertNotNull("directType", cls);
        Cls cls2 = (Cls)this._testFrameStore.getFrame(":THING");
        List list = FrameStore_Test.makeList(cls2);
        List list2 = FrameStore_Test.makeList(cls);
        Cls cls3 = this._testFrameStore.createCls(FrameStore_Test.getID(string), list2, list, true);
        FrameStore_Test.assertEquals((String)"name", (String)string, (String)this.getName(cls3));
        FrameStore_Test.assertEquals((String)"direct type", (Object)cls, (Object)cls3.getDirectType());
        FrameStore_Test.assertEqualsList("parents", list, cls3.getDirectSuperclasses());
        Cls cls4 = (Cls)this._testFrameStore.getFrame(string);
        FrameStore_Test.assertEquals((String)"pointer", (Object)cls3, (Object)cls4);
    }

    public void testGetFrame() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        String string = this._testFrameStore.getFrameName(cls);
        FrameStore_Test.assertNotNull((String)"name", (Object)string);
        FrameStore_Test.assertEquals((Object)cls, (Object)this._testFrameStore.getFrame(string));
    }

    public void testCreateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-SLOT");
        List list = FrameStore_Test.makeList(cls);
        Slot slot = this._testFrameStore.createSlot(FrameStore_Test.getID(null), list, Collections.EMPTY_LIST, true);
        FrameStore_Test.assertNotNull((Object)slot);
        FrameStore_Test.assertEquals((String)"slota", (Object)slot, (Object)this.getFrame(this.getName(slot)));
        List list2 = this._testFrameStore.getDirectTypes(slot);
        FrameStore_Test.assertEquals((String)"types size", (int)1, (int)list2.size());
        FrameStore_Test.assertEquals((String)"standard slot", (Object)cls, list2.iterator().next());
        Slot slot2 = this._testFrameStore.createSlot(FrameStore_Test.getID(null), list, Collections.EMPTY_LIST, true);
        List list3 = FrameStore_Test.makeList(slot, slot2);
        String string = FrameStore_Test.createFrameName();
        Slot slot3 = this._testFrameStore.createSlot(FrameStore_Test.getID(string), list, list3, true);
        FrameStore_Test.assertNotNull((Object)slot3);
        FrameStore_Test.assertEquals((String)"slotc", (Object)slot3, (Object)this.getFrame(this.getName(slot3)));
        FrameStore_Test.assertEqualsSet("superslots", list3, this._testFrameStore.getDirectSuperslots(slot3));
    }

    public void testCreateSimpleInstance() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        List list = FrameStore_Test.makeList(cls);
        SimpleInstance simpleInstance = this._testFrameStore.createSimpleInstance(FrameStore_Test.getID(null), list, true);
        FrameStore_Test.assertNotNull((Object)simpleInstance);
        FrameStore_Test.assertEquals((Object)simpleInstance, (Object)this.getFrame(this.getName(simpleInstance)));
    }

    public void testCreateFacet() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-FACET");
        List list = FrameStore_Test.makeList(cls);
        Facet facet = this._testFrameStore.createFacet(FrameStore_Test.getID(null), list, true);
        FrameStore_Test.assertNotNull((Object)facet);
        FrameStore_Test.assertEquals((Object)facet, (Object)this.getFrame(this.getName(facet)));
    }

    public void testDeleteCls() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        FrameStore_Test.assertNotNull((Object)cls);
        String string = this.getName(cls);
        FrameStore_Test.assertNotNull((Object)string);
        this._testFrameStore.deleteCls(cls);
        FrameStore_Test.assertNull((String)"no class after delete", (Object)this.getFrame(string));
    }

    public void testDeleteSlot() {
        if (!this._initialized) {
            return;
        }
        String string = "deleteSlot";
        List list = FrameStore_Test.makeList(this.getFrame(":STANDARD-SLOT"));
        Slot slot = this._testFrameStore.createSlot(FrameStore_Test.getID(string), list, Collections.EMPTY_LIST, true);
        FrameStore_Test.assertNotNull((Object)slot);
        this._testFrameStore.deleteSlot(slot);
        FrameStore_Test.assertNull((String)"no slot after delete", (Object)this.getFrame(string));
    }

    public void testDeleteFacet() {
        if (!this._initialized) {
            return;
        }
        String string = "deleteFacet";
        List list = FrameStore_Test.makeList(this.getFrame(":STANDARD-FACET"));
        Facet facet = this._testFrameStore.createFacet(FrameStore_Test.getID(string), list, true);
        FrameStore_Test.assertNotNull((Object)facet);
        this._testFrameStore.deleteFacet(facet);
        FrameStore_Test.assertNull((String)"no facet after delete", (Object)this.getFrame(string));
    }

    public void testDeleteSimpleInstance() {
        if (!this._initialized) {
            return;
        }
        List list = FrameStore_Test.makeList(this.createCls());
        String string = "deleteSimpleInstance";
        SimpleInstance simpleInstance = this._testFrameStore.createSimpleInstance(FrameStore_Test.getID(string), list, true);
        FrameStore_Test.assertNotNull((Object)simpleInstance);
        this._testFrameStore.deleteSimpleInstance(simpleInstance);
        FrameStore_Test.assertNull((String)"no simpleInstance after delete", (Object)this.getFrame(string));
    }

    public void testGetClses() {
        if (!this._initialized) {
            return;
        }
        ArrayList<Cls> arrayList = new ArrayList<Cls>(this._testFrameStore.getClses());
        Cls cls = (Cls)this.getFrame(":THING");
        FrameStore_Test.assertNotNull((String)"thing not null", (Object)cls);
        FrameStore_Test.assertTrue((String)"thing", (boolean)arrayList.contains(cls));
        Cls cls2 = this.createCls();
        Set<Cls> set = this._testFrameStore.getClses();
        FrameStore_Test.assertEquals((String)"size", (int)(arrayList.size() + 1), (int)set.size());
        FrameStore_Test.assertTrue((String)"new class", (boolean)set.contains(cls2));
    }

    public void testGetInstances() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Set<Instance> set = this._testFrameStore.getInstances(cls);
        FrameStore_Test.assertEquals((String)"none", (int)0, (int)set.size());
        List list = FrameStore_Test.makeList(cls);
        this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(null), list, true);
        set = this._testFrameStore.getInstances(cls);
        FrameStore_Test.assertEquals((String)"after", (int)1, (int)set.size());
    }

    public void testAddDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        this._testFrameStore.addDirectTemplateSlot(cls, slot);
        List list = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size", (int)1, (int)list.size());
        FrameStore_Test.assertEquals((String)"value", (Object)slot, list.get(0));
    }

    public void testGetOwnSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        this.createSlotOnCls(cls);
        Cls cls2 = this.createCls(cls);
        this.createSlotOnCls(cls2);
        List list = FrameStore_Test.makeList(cls2);
        SimpleInstance simpleInstance = this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(null), list, true);
        Set<Slot> set = this._testFrameStore.getOwnSlots(simpleInstance);
        Set set2 = this._testFrameStore.getTemplateSlots(cls2);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)set2.size());
        HashSet<Frame> hashSet = new HashSet<Frame>(set2);
        hashSet.add(this.getFrame(":NAME"));
        hashSet.add(this.getFrame(":DIRECT-TYPE"));
        FrameStore_Test.assertEquals((String)"sets", hashSet, set);
    }

    public void testGetTemplateSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Cls cls2 = this.createCls(cls);
        Slot slot2 = this.createSlotOnCls(cls2);
        Cls cls3 = this.createCls(cls2);
        Set set = this._modifiableFrameStore.getTemplateSlots(cls3);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)set.size());
        FrameStore_Test.assertTrue((String)"slot", (boolean)set.contains(slot));
        FrameStore_Test.assertTrue((String)"slotb", (boolean)set.contains(slot2));
    }

    public void testGetDirectOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List list = FrameStore_Test.makeList(cls);
        SimpleInstance simpleInstance = this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(null), list, true);
        List list2 = FrameStore_Test.makeList("foo", "bar");
        List list3 = this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, list2);
        FrameStore_Test.assertEquals((String)"oldsize", (int)0, (int)list3.size());
        List list4 = this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
        FrameStore_Test.assertEquals((String)"newsize", (int)list2.size(), (int)list4.size());
        FrameStore_Test.assertEquals((String)"lists", (Object)list2, (Object)list4);
    }

    public void testGetReferences() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slot2 = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slot3 = (Slot)this._testFrameStore.getFrame(":DIRECT-INSTANCES");
        Facet facet = this.createFacet(ValueType.INSTANCE);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        List list = FrameStore_Test.makeList(simpleInstance2);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, list);
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot2, list);
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slot, facet, list);
        Set<Reference> set = this._testFrameStore.getReferences(simpleInstance2);
        FrameStore_Test.assertTrue((String)"own slot value", (boolean)set.contains(new ReferenceImpl(simpleInstance, slot, null, false)));
        FrameStore_Test.assertTrue((String)"type", (boolean)set.contains(new ReferenceImpl(cls, slot3, null, false)));
        FrameStore_Test.assertTrue((String)"facet value", (boolean)set.contains(new ReferenceImpl(cls, slot, facet, true)));
        FrameStore_Test.assertEquals((String)"size", (int)4, (int)set.size());
    }

    public void testGetFrames() {
        if (!this._initialized) {
            return;
        }
        Frame frame = this._testFrameStore.getFrame(":THING");
        Set<Frame> set = this._testFrameStore.getFrames();
        int n = set.size();
        FrameStore_Test.assertTrue((String)"contains thing", (boolean)set.contains(frame));
        Cls cls = this.createCls();
        this.createSlot();
        this.createSimpleInstance(cls);
        Set<Frame> set2 = this._testFrameStore.getFrames();
        FrameStore_Test.assertEquals((String)"size", (int)(n + 3), (int)set2.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering testGetOwnSlotValues");
        }
        try {
            Cls cls = this.createCls();
            Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
            List list = FrameStore_Test.makeList("foo", "bar");
            this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, list);
            SimpleInstance simpleInstance = this.createSimpleInstance(cls);
            List list2 = FrameStore_Test.makeList("foob", "baz");
            this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, list2);
            Collection collection = this._testFrameStore.getOwnSlotValues(simpleInstance, slot);
            HashSet hashSet = new HashSet(list);
            hashSet.addAll(list2);
            FrameStore_Test.assertEqualsSet("size", hashSet, collection);
        }
        finally {
            if (log.isLoggable(Level.FINE)) {
                log.fine("testGetOwnSlotValues completed...");
            }
        }
    }

    public void testSetDirectOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        List list = FrameStore_Test.makeList("foo", "bar");
        List list2 = this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
        FrameStore_Test.assertEquals((String)"no old values", (int)0, (int)list2.size());
        this._testFrameStore.setDirectOwnSlotValues(simpleInstance, slot, list);
        List list3 = this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
        FrameStore_Test.assertEqualsList("values", list, list3);
        this._testFrameStore.setDirectOwnSlotValues(simpleInstance, slot, Collections.EMPTY_SET);
        List list4 = this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot);
        FrameStore_Test.assertEquals((String)"empty values", (int)0, (int)list4.size());
    }

    public void testGetDirectTemplateSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        List list = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"old values", (int)0, (int)list.size());
        Slot slot = this.createSlotOnCls(cls);
        Slot slot2 = this.createSlotOnCls(cls);
        List list2 = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)list2.size());
        FrameStore_Test.assertTrue((String)"a", (boolean)list2.contains(slot));
        FrameStore_Test.assertTrue((String)"b", (boolean)list2.contains(slot2));
    }

    public void testRemoveDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Slot slot2 = this.createSlotOnCls(cls);
        Slot slot3 = this.createSlotOnCls(cls);
        FrameStore_Test.assertEquals((String)"size1", (int)3, (int)this._testFrameStore.getDirectTemplateSlots(cls).size());
        this._testFrameStore.removeDirectTemplateSlot(cls, slot2);
        List list = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size2", (int)2, (int)list.size());
        FrameStore_Test.assertTrue((String)"contains a", (boolean)list.contains(slot));
        FrameStore_Test.assertTrue((String)"contains c", (boolean)list.contains(slot3));
        this._testFrameStore.removeDirectTemplateSlot(cls, slot);
        this._testFrameStore.removeDirectTemplateSlot(cls, slot3);
        FrameStore_Test.assertEquals((String)"size3", (int)0, (int)this._testFrameStore.getDirectTemplateSlots(cls).size());
    }

    public void testMoveDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Slot slot2 = this.createSlotOnCls(cls);
        Slot slot3 = this.createSlotOnCls(cls);
        List list = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEqualsList("start", FrameStore_Test.makeList(slot, slot2, slot3), list);
        this._testFrameStore.moveDirectTemplateSlot(cls, slot, 2);
        this._testFrameStore.moveDirectTemplateSlot(cls, slot3, 0);
        List list2 = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEqualsList("end", FrameStore_Test.makeList(slot3, slot2, slot), list2);
    }

    public void testGetTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Slot slot = this.createSlotOnCls(cls);
        List list = FrameStore_Test.makeList("foo");
        List list2 = FrameStore_Test.makeList("bar");
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(list2);
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, list);
        Collection collection = this._testFrameStore.getTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsSet("class values", list, collection);
        Collection collection2 = this._testFrameStore.getTemplateSlotValues(cls2, slot);
        FrameStore_Test.assertEqualsSet("subclass values1", list, collection2);
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls2, slot, list2);
        Collection collection3 = this._testFrameStore.getTemplateSlotValues(cls2, slot);
        FrameStore_Test.assertEqualsSet("subclass values2", arrayList, collection3);
    }

    public void testGetDirectTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List list = FrameStore_Test.makeList("foo", "bar");
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, list);
        List list2 = this._testFrameStore.getDirectTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsList("values", list, list2);
    }

    public void testSetDirectTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List list = FrameStore_Test.makeList("foo", "bar");
        this._testFrameStore.setDirectTemplateSlotValues(cls, slot, list);
        List list2 = this._testFrameStore.getDirectTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsList("values", list, list2);
    }

    public void testGetTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        Facet facet = this.createFacet();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls2);
        List list = FrameStore_Test.makeList("foo");
        List list2 = FrameStore_Test.makeList("bar");
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slot, facet, list);
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls2, slot, facet, list2);
        this._testFrameStore.getDirectTemplateFacetValues(cls, slot, facet);
        this._testFrameStore.getDirectTemplateFacetValues(cls2, slot, facet);
        this._testFrameStore.getDirectTemplateFacetValues(cls3, slot, facet);
    }

    public void testGetDirectTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(this._kb.getDefaultSlotMetaCls());
        Slot slot = this.createSlotOnCls(cls2, ValueType.STRING, true);
        Slot slot2 = this.createSlotOnCls(cls, ValueType.STRING, true);
        this.setDirectType(slot2, cls2);
        Facet facet = this.createFacet();
        Slot slot3 = (Slot)this.getFrame(":ASSOCIATED-FACET");
        Collection<Facet> collection = CollectionUtilities.createCollection(facet);
        this._modifiableFrameStore.setDirectOwnSlotValues(slot, slot3, collection);
        List list = FrameStore_Test.makeList("foo", "bar");
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slot2, facet, list);
        List list2 = this._testFrameStore.getDirectTemplateFacetValues(cls, slot2, facet);
        FrameStore_Test.assertEqualsList("values", list, list2);
    }

    private void setDirectType(Instance instance, Cls cls) {
        Cls cls2 = instance.getDirectType();
        this._modifiableFrameStore.addDirectType(instance, cls);
        this._modifiableFrameStore.removeDirectType(instance, cls2);
    }

    public void testSetDirectTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(this._kb.getDefaultSlotMetaCls());
        Slot slot = this.createSlotOnCls(cls2, ValueType.STRING, true);
        Slot slot2 = this.createSlotOnCls(cls, ValueType.STRING, true);
        slot2.setDirectType(cls2);
        Facet facet = this.createFacet();
        slot.setAssociatedFacet(facet);
        List list = FrameStore_Test.makeList("foo", "bar");
        this._testFrameStore.setDirectTemplateFacetValues(cls, slot2, facet, list);
        List list2 = this._testFrameStore.getDirectTemplateFacetValues(cls, slot2, facet);
        FrameStore_Test.assertEqualsList("values", list, list2);
    }

    public void testGetDirectSuperclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Cls cls3 = this.createCls(cls);
        this._modifiableFrameStore.addDirectSuperclass(cls3, cls2);
        List<Cls> list = this._testFrameStore.getDirectSuperclasses(cls3);
        FrameStore_Test.assertEqualsList("clses", FrameStore_Test.makeList(cls, cls2), list);
    }

    public void testGetSuperclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":THING");
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls2);
        Cls cls5 = this.createCls(cls4);
        this._modifiableFrameStore.addDirectSuperclass(cls4, cls3);
        Set set = this._testFrameStore.getSuperclasses(cls5);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(cls, cls2, cls3, cls4), set);
    }

    public void testGetDirectSubclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        List<Cls> list = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("clses", FrameStore_Test.makeList(cls2, cls3), list);
    }

    public void testGetSubclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls2);
        Cls cls4 = this.createCls(cls2);
        Set<Cls> set = this._testFrameStore.getSubclasses(cls);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(cls2, cls3, cls4), set);
    }

    public void testAddDirectSuperclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls2);
        this._testFrameStore.addDirectSuperclass(cls4, cls3);
        List<Cls> list = this._testFrameStore.getDirectSuperclasses(cls4);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(cls2, cls3), list);
    }

    public void testRemoveDirectSuperclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls);
        Cls cls5 = this.createCls(cls2);
        this._modifiableFrameStore.addDirectSuperclass(cls5, cls3);
        this._modifiableFrameStore.addDirectSuperclass(cls5, cls4);
        List<Cls> list = this._testFrameStore.getDirectSuperclasses(cls5);
        FrameStore_Test.assertEqualsSet("clses start", FrameStore_Test.makeList(cls2, cls3, cls4), list);
        this._testFrameStore.removeDirectSuperclass(cls5, cls2);
        list = this._testFrameStore.getDirectSuperclasses(cls5);
        FrameStore_Test.assertEqualsSet("clses end", FrameStore_Test.makeList(cls3, cls4), list);
    }

    public void testMoveDirectSubclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls);
        List<Cls> list = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("start", FrameStore_Test.makeList(cls2, cls3, cls4), list);
        this._testFrameStore.moveDirectSubclass(cls, cls2, 1);
        list = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls3, cls2, cls4), list);
        this._testFrameStore.moveDirectSubclass(cls, cls2, 2);
        list = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(cls3, cls4, cls2), list);
        this._testFrameStore.moveDirectSubclass(cls, cls2, 0);
        list = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("3", FrameStore_Test.makeList(cls2, cls3, cls4), list);
    }

    public void testGetDirectSuperslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot(slot);
        Slot slot3 = this.createSlot(slot);
        Slot slot4 = this.createSlot(slot2);
        this._modifiableFrameStore.addDirectSuperslot(slot4, slot3);
        FrameStore_Test.assertEquals((String)"no superslots", (int)0, (int)this._testFrameStore.getDirectSuperslots(slot).size());
        FrameStore_Test.assertEqualsList("1 superslot", FrameStore_Test.makeList(slot), this._testFrameStore.getDirectSuperslots(slot2));
        FrameStore_Test.assertEqualsList("2 superslots", FrameStore_Test.makeList(slot2, slot3), this._testFrameStore.getDirectSuperslots(slot4));
    }

    public void testGetSuperslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot(slot);
        Slot slot3 = this.createSlot(slot);
        Slot slot4 = this.createSlot(slot2);
        this._modifiableFrameStore.addDirectSuperslot(slot4, slot3);
        FrameStore_Test.assertEquals((String)"no superslots", (int)0, (int)this._testFrameStore.getSuperslots(slot).size());
        FrameStore_Test.assertEqualsSet("1 superslot", FrameStore_Test.makeList(slot), this._testFrameStore.getSuperslots(slot2));
        FrameStore_Test.assertEqualsSet("2 superslots", FrameStore_Test.makeList(slot, slot2, slot3), this._testFrameStore.getSuperslots(slot4));
    }

    public void testGetDirectSubslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot(slot);
        Slot slot3 = this.createSlot(slot);
        Slot slot4 = this.createSlot(slot2);
        this._modifiableFrameStore.addDirectSuperslot(slot4, slot3);
        FrameStore_Test.assertEqualsList("slot", FrameStore_Test.makeList(slot2, slot3), this._testFrameStore.getDirectSubslots(slot));
        FrameStore_Test.assertEqualsList("slota", FrameStore_Test.makeList(slot4), this._testFrameStore.getDirectSubslots(slot2));
        FrameStore_Test.assertEqualsList("slotc", FrameStore_Test.makeList(), this._testFrameStore.getDirectSubslots(slot4));
    }

    public void testGetSubslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot(slot);
        Slot slot3 = this.createSlot(slot);
        Slot slot4 = this.createSlot(slot2);
        this._modifiableFrameStore.addDirectSuperslot(slot4, slot3);
        FrameStore_Test.assertEqualsSet("slot", FrameStore_Test.makeList(slot2, slot3, slot4), this._testFrameStore.getSubslots(slot));
        FrameStore_Test.assertEqualsSet("slota", FrameStore_Test.makeList(slot4), this._testFrameStore.getDirectSubslots(slot2));
        FrameStore_Test.assertEqualsSet("slotc", FrameStore_Test.makeList(), this._testFrameStore.getDirectSubslots(slot4));
    }

    public void testAddDirectSuperslot() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot();
        Slot slot3 = this.createSlot(slot);
        this._testFrameStore.addDirectSuperslot(slot2, slot);
        FrameStore_Test.assertEqualsList("b", FrameStore_Test.makeList(slot), this._testFrameStore.getDirectSuperslots(slot2));
        this._testFrameStore.addDirectSuperslot(slot3, slot2);
        FrameStore_Test.assertEqualsList("c", FrameStore_Test.makeList(slot, slot2), this._testFrameStore.getDirectSuperslots(slot3));
    }

    public void testRemoveDirectSuperslot() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot();
        Slot slot3 = this.createSlot(slot);
        this._modifiableFrameStore.addDirectSuperslot(slot3, slot2);
        FrameStore_Test.assertEqualsList("c", FrameStore_Test.makeList(slot, slot2), this._testFrameStore.getDirectSuperslots(slot3));
        this._testFrameStore.removeDirectSuperslot(slot3, slot);
        FrameStore_Test.assertEqualsList("c1", FrameStore_Test.makeList(slot2), this._testFrameStore.getDirectSuperslots(slot3));
        this._testFrameStore.removeDirectSuperslot(slot3, slot2);
        FrameStore_Test.assertEqualsList("c0", FrameStore_Test.makeList(), this._testFrameStore.getDirectSuperslots(slot3));
    }

    public void testGetDirectTypes() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls), this._testFrameStore.getDirectTypes(simpleInstance));
        this._modifiableFrameStore.addDirectType(simpleInstance, cls2);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(cls, cls2), this._testFrameStore.getDirectTypes(simpleInstance));
    }

    public void testGetTypes() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":THING");
        Cls cls2 = this.createCls();
        Cls cls3 = this.createCls();
        SimpleInstance simpleInstance = this.createSimpleInstance(cls2);
        FrameStore_Test.assertEqualsSet("1", FrameStore_Test.makeList(cls2, cls), this._testFrameStore.getTypes(simpleInstance));
        this._modifiableFrameStore.addDirectType(simpleInstance, cls3);
        FrameStore_Test.assertEqualsSet("2", FrameStore_Test.makeList(cls2, cls3, cls), this._testFrameStore.getTypes(simpleInstance));
    }

    public void testGetDirectInstances() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        SimpleInstance simpleInstance = this.createSimpleInstance(null, cls);
        SimpleInstance simpleInstance2 = this.createSimpleInstance(null, cls);
        SimpleInstance simpleInstance3 = this.createSimpleInstance(null, cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(simpleInstance, simpleInstance2, simpleInstance3), this._testFrameStore.getDirectInstances(cls));
    }

    public void testAddDirectType() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        this._testFrameStore.addDirectType(simpleInstance, cls2);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls, cls2), this._testFrameStore.getDirectTypes(simpleInstance));
    }

    public void testRemoveDirectType() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        this._testFrameStore.addDirectType(simpleInstance, cls2);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls, cls2), this._testFrameStore.getDirectTypes(simpleInstance));
        this._testFrameStore.removeDirectType(simpleInstance, cls);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(cls2), this._testFrameStore.getDirectTypes(simpleInstance));
    }

    public void testGetSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-SLOT");
        Cls cls2 = this.createCls(cls);
        Set<Slot> set = this._testFrameStore.getSlots();
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot(slot);
        Slot slot3 = this.createSlotOnCls(cls2);
        List list = FrameStore_Test.makeList(slot, slot2, slot3);
        list.addAll(set);
        FrameStore_Test.assertEqualsSet("slots", list, this._testFrameStore.getSlots());
    }

    public void testGetFacets() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-FACET");
        Cls cls2 = this.createCls(cls);
        Set<Facet> set = this._testFrameStore.getFacets();
        Facet facet = this.createFacet();
        Facet facet2 = this.createFacet();
        Facet facet3 = this.createFacet(ValueType.STRING, cls2);
        List list = FrameStore_Test.makeList(facet, facet2, facet3);
        list.addAll(set);
        FrameStore_Test.assertEqualsSet("slots", list, this._testFrameStore.getFacets());
    }

    private Set<Reference> getMatchingReferences(String string) {
        return this._testFrameStore.getMatchingReferences(string, -1);
    }

    public void testGetMatchingReferences() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        int n = this.getMatchingReferences("refxxx").size();
        int n2 = this.getMatchingReferences("refxxx*").size();
        int n3 = this.getMatchingReferences("*EFx*").size();
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, FrameStore_Test.makeList("refxxx", "erexxx"));
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance2, slot, FrameStore_Test.makeList("refxxxerexxx"));
        Set<Reference> set = this.getMatchingReferences("refxxx");
        FrameStore_Test.assertEquals((String)"exact", (int)(n + 1), (int)set.size());
        Set<Reference> set2 = this.getMatchingReferences("refxxx*");
        FrameStore_Test.assertEquals((String)"startswith", (int)(n2 + 2), (int)set2.size());
        Set<Reference> set3 = this.getMatchingReferences("*EFx*");
        FrameStore_Test.assertEquals((String)"contains", (int)(n3 + 2), (int)set3.size());
    }

    public void testGetFramesWithOwnSlotValue() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, FrameStore_Test.makeList("own", "value"));
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance2, slot, FrameStore_Test.makeList("foo", "own"));
        FrameStore_Test.assertEqualsSet("values", FrameStore_Test.makeList(simpleInstance, simpleInstance2), this._testFrameStore.getFramesWithDirectOwnSlotValue(slot, "own"));
    }

    public void testGetFramesWithMatchingOwnSlotValue() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance, slot, FrameStore_Test.makeList("own", "value"));
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance2, slot, FrameStore_Test.makeList("foo", "own"));
        SimpleInstance simpleInstance3 = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(simpleInstance3, slot, FrameStore_Test.makeList("owx"));
        FrameStore_Test.assertEqualsSet("exact", FrameStore_Test.makeList(simpleInstance, simpleInstance2), this._testFrameStore.getFramesWithMatchingDirectOwnSlotValue(slot, "own", -1));
        FrameStore_Test.assertEqualsSet("starts with", FrameStore_Test.makeList(simpleInstance, simpleInstance2, simpleInstance3), this._testFrameStore.getFramesWithMatchingDirectOwnSlotValue(slot, "OW*", -1));
    }

    public void testGetTemplateFacets() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-SLOT");
        Slot slot = (Slot)this.getFrame(":ASSOCIATED-FACET");
        Cls cls2 = this.createCls(cls);
        Slot slot2 = this.createSlotOnCls(cls2);
        Facet facet = this.createFacet();
        Cls cls3 = this.createCls();
        Slot slot3 = this.createSlotOnCls(cls3, cls2);
        this.setOwnSlotValue(slot2, slot, facet);
        Set<Facet> set = this._testFrameStore.getTemplateFacets(cls3, slot3);
        FrameStore_Test.assertTrue((String)"new facet", (boolean)set.contains(facet));
    }

    public void testSetInverseSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slot2 = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slot3 = (Slot)this.getFrame(":SLOT-INVERSE");
        this.setOwnSlotValue(slot, slot3, slot2);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        SimpleInstance simpleInstance2 = this.createSimpleInstance(cls);
        Cls cls2 = this.createCls();
        SimpleInstance simpleInstance3 = this.createSimpleInstance(cls2);
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot).size());
        this._testFrameStore.setDirectOwnSlotValues(simpleInstance, slot, FrameStore_Test.makeList(simpleInstance2));
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(simpleInstance2), this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot));
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(simpleInstance), this._testFrameStore.getDirectOwnSlotValues(simpleInstance2, slot2));
        this._testFrameStore.setDirectOwnSlotValues(simpleInstance2, slot2, FrameStore_Test.makeList(simpleInstance3));
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(simpleInstance, slot).size());
        FrameStore_Test.assertEqualsList("3", FrameStore_Test.makeList(simpleInstance3), this._testFrameStore.getDirectOwnSlotValues(simpleInstance2, slot2));
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(simpleInstance3, slot).size());
    }
}

