/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import edu.stanford.smi.protege.plugin.ExportProjectPlugin;
import edu.stanford.smi.protege.plugin.SelectOutputFormatWizardPage;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.util.Wizard;
import javax.swing.JComponent;

public class ExportWizard
extends Wizard {
    private Project originalProject;
    private Project newProject;
    private ExportProjectPlugin plugin;
    private boolean exportToNewFormat = false;

    public ExportWizard(JComponent jComponent, Project project) {
        super(jComponent, "Export Project");
        this.setSize(400, 400);
        this.originalProject = project;
        this.addPage(new SelectOutputFormatWizardPage(this, project));
    }

    public Project getNewProject() {
        return this.newProject;
    }

    public void setExportPlugin(ExportProjectPlugin exportProjectPlugin) {
        this.plugin = exportProjectPlugin;
    }

    public void setExportToNewFormat(boolean bl) {
        this.exportToNewFormat = bl;
    }

    public void onFinish() {
        super.onFinish();
        this.doExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        WaitCursor waitCursor = new WaitCursor(this);
        try {
            if (this.exportToNewFormat) {
                this.newProject = ((BackendExportPlugin)this.plugin).exportProjectToNewFormat(this.originalProject);
            } else {
                this.plugin.exportProject(this.originalProject);
            }
        }
        finally {
            waitCursor.hide();
        }
    }
}

