/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.ClsesAndInstancesTab;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MetaprojectPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = 6214203367190208198L;

    public MetaprojectPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        super(remoteServer, remoteSession);
    }

    protected JComponent createCenterComponent() {
        MetaProject metaProject = null;
        try {
            metaProject = RemoteProjectManager.getInstance().connectToMetaProject(this.getServer(), this.getSession());
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at getting the metaproject", exception);
        }
        if (metaProject == null) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("<html><i><b>You do not have enough privileges to change the metaproject.</b></i></html>"));
            jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
            return jPanel;
        }
        KnowledgeBase knowledgeBase = ((MetaProjectImpl)metaProject).getKnowledgeBase();
        Project project = knowledgeBase.getProject();
        project.setIsReadonly(false);
        ClsesAndInstancesTab clsesAndInstancesTab = new ClsesAndInstancesTab();
        clsesAndInstancesTab.setup(project.createWidgetDescriptor(), project);
        clsesAndInstancesTab.initialize();
        return clsesAndInstancesTab;
    }

    protected void addRefreshButton() {
    }
}

