/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LastUsageInvocationHandler
extends AbstractFrameStoreInvocationHandler {
    public static long ACCESS_TIME_GRANULARITY = 15000L;
    private ProjectInstance projectInstance;
    private MetaProject metaproject;
    private Map<User, Date> lastAccessTimeMap = new HashMap<User, Date>();

    public LastUsageInvocationHandler(ProjectInstance projectInstance) {
        this.projectInstance = projectInstance;
        this.metaproject = projectInstance.getMetaProject();
    }

    protected void executeQuery(Query query, final QueryCallback queryCallback) {
        this.updateLastAccessTime();
        QueryCallback queryCallback2 = new QueryCallback(){

            @Override
            public void provideQueryResults(Collection<Frame> collection) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.provideQueryResults(collection);
            }

            @Override
            public void handleError(ProtegeError protegeError) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(protegeError);
            }

            @Override
            public void handleError(ProtegeIOException protegeIOException) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(protegeIOException);
            }

            @Override
            public void handleError(OntologyException ontologyException) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(ontologyException);
            }
        };
        this.getDelegate().executeQuery(query, queryCallback2);
    }

    protected Object handleInvoke(Method method, Object[] objectArray) {
        if (!method.getName().equals("getEvents")) {
            this.updateLastAccessTime();
        }
        return this.invoke(method, objectArray);
    }

    private void updateLastAccessTime() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        if (remoteSession == null) {
            return;
        }
        User user = this.metaproject.getUser(remoteSession.getUserName());
        Date date = new Date();
        Date date2 = this.lastAccessTimeMap.get(user);
        if (date2 == null || date.getTime() > date2.getTime() + ACCESS_TIME_GRANULARITY) {
            user.setLastAccess(date);
            this.lastAccessTimeMap.put(user, date);
        }
    }
}

