/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.storage.xml.XMLUtil;
import edu.stanford.smi.protege.util.Log;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XMLStorer {
    private KnowledgeBase kb;
    private PrintWriter writer;
    private Collection excludeSlots = new HashSet();
    private int indentLevel = 0;
    private NarrowFrameStore activeFrameStore;
    private Collection activeFrames;

    public XMLStorer(KnowledgeBase knowledgeBase, Writer writer, Collection collection) {
        this.kb = knowledgeBase;
        this.writer = new PrintWriter(writer);
        this.initializeExcludeSlots();
        this.activeFrameStore = MergingNarrowFrameStore.get(knowledgeBase).getActiveFrameStore();
        this.activeFrames = this.activeFrameStore.getFrames();
    }

    private void initializeExcludeSlots() {
        this.exclude(":NAME");
        this.exclude(":DIRECT-INSTANCES");
        this.exclude(":DIRECT-TEMPLATE-SLOTS");
        this.exclude(":DIRECT-SUPERCLASSES");
        this.exclude(":DIRECT-SUBCLASSES");
        this.exclude(":DIRECT-TYPE");
        this.exclude(":DIRECT-INSTANCES");
        this.exclude(":DIRECT-SUBSLOTS");
        this.exclude(":DIRECT-SUPERSLOTS");
        this.exclude(":DIRECT-DOMAIN");
        this.exclude(":ASSOCIATED-SLOT");
    }

    private void exclude(String string) {
        this.excludeSlots.add(this.kb.getSlot(string));
    }

    private void indent() {
        ++this.indentLevel;
    }

    private void unindent() {
        --this.indentLevel;
    }

    public void store() {
        this.preamble();
        this.indent();
        this.storeClses();
        this.storeSlots();
        this.storeFacets();
        this.storeSimpleInstances();
        this.unindent();
        this.postscript();
        this.writer.flush();
    }

    private void storeClses() {
        this.storeCls(this.kb.getRootCls(), new HashSet());
    }

    private void storeSlots() {
        ArrayList arrayList = new ArrayList(this.kb.getSlots());
        Collections.sort(arrayList);
        for (Slot slot : arrayList) {
            this.storeSlot(slot);
        }
    }

    private void storeFacets() {
        ArrayList arrayList = new ArrayList(this.kb.getFacets());
        Collections.sort(arrayList);
        for (Facet facet : arrayList) {
            this.storeFacet(facet);
        }
    }

    private void storeSimpleInstances() {
        HashSet hashSet = new HashSet();
        for (Cls cls : this.kb.getClses()) {
            this.storeSimpleInstances(cls, hashSet);
        }
    }

    private void storeSimpleInstances(Cls cls, Set set) {
        for (Instance instance : cls.getDirectInstances()) {
            if (!(instance instanceof SimpleInstance) || set.contains(instance)) continue;
            this.storeSimpleInstance((SimpleInstance)instance);
            set.add(instance);
        }
    }

    private void printHeader() {
        this.println("<?xml version=\"1.0\" ?>");
    }

    private void preamble() {
        this.printHeader();
        String[] stringArray = new String[]{"xmlns=\"http://protege.stanford.edu/xml\"", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "xsi:schemaLocation=\"http://protege.stanford.edu/xml http://protege.stanford.edu/xml/schema/protege.xsd\""};
        this.println();
        this.printStartTag("knowledge_base", stringArray);
    }

    private void postscript() {
        this.printEndTag("knowledge_base");
    }

    private void println(String string) {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.print("\t");
        }
        this.writer.println(string);
    }

    private void println() {
        this.writer.println();
    }

    private static String escape(String string) {
        return XMLUtil.escape(string);
    }

    private void printValue(String string, String string2) {
        this.println("<" + string + ">" + XMLStorer.escape(string2) + "</" + string + ">");
    }

    private void printValue(String string, String string2, String string3, String string4) {
        this.println("<" + string + " " + string3 + "=\"" + string4 + "\">" + XMLStorer.escape(string2) + "</" + string + ">");
    }

    private void printFrameReference(String string, Frame frame) {
        this.printValue(string, frame.getName());
    }

    private void printStartTag(String string) {
        this.printStartTag(string, null);
    }

    private void printStartTag(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray.length == 1) {
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append("\n\t");
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        stringBuffer.append(">");
        this.println(stringBuffer.toString());
    }

    private void printEndTag(String string) {
        this.println("</" + string + ">");
    }

    private void printOwnSlotValues(Frame frame) {
        for (Slot slot : frame.getOwnSlots()) {
            if (!this.printOwnSlot(frame, slot)) continue;
            this.printOwnSlotValues(frame, slot);
        }
    }

    private boolean printOwnSlot(Frame frame, Slot slot) {
        return !this.excludeSlots.contains(slot);
    }

    private void printOwnSlotValues(Frame frame, Slot slot) {
        List list = frame.getDirectOwnSlotValues(slot);
        if (!list.isEmpty()) {
            this.printStartTag("own_slot_value");
            this.indent();
            this.printValue("slot_reference", slot.getName());
            this.printValues(frame.getDirectOwnSlotValues(slot));
            this.unindent();
            this.printEndTag("own_slot_value");
        }
    }

    private void printValues(Collection collection) {
        for (Object e : collection) {
            this.printValue(e);
        }
    }

    private void printValue(Object object) {
        String string;
        String string2;
        String string3;
        if (object instanceof Frame) {
            string3 = "value";
            string2 = XMLStorer.frameAttribute(object);
            string = XMLStorer.frameValue(object);
        } else {
            string3 = "value";
            if (object instanceof String) {
                string2 = "string";
                string = (String)object;
            } else if (object instanceof Integer) {
                string2 = "integer";
                string = object.toString();
            } else if (object instanceof Float) {
                string2 = "float";
                string = object.toString();
            } else if (object instanceof Boolean) {
                string2 = "boolean";
                string = object.toString();
            } else {
                Log.getLogger().warning("Unexpected object: " + object);
                string2 = "string";
                string = object.toString();
            }
        }
        this.printValue(string3, string, "value_type", string2);
    }

    private static String frameValue(Object object) {
        return ((Frame)object).getName();
    }

    private static String frameAttribute(Object object) {
        String string = object instanceof Cls ? "class" : (object instanceof Slot ? "slot" : (object instanceof Facet ? "facet" : "simple_instance"));
        return string;
    }

    private void endInstance(String string, Instance instance) {
        this.printEndTag(string);
    }

    private void beginInstance(String string, Instance instance) {
        this.println();
        this.printStartTag(string);
        this.indent();
        this.printValue("name", instance.getName());
        this.printFrameValues("type", instance.getDirectTypes());
        this.printOwnSlotValues(instance);
        this.unindent();
    }

    private void printFrameValues(String string, Collection collection) {
        for (Frame frame : collection) {
            this.printFrameReference(string, frame);
        }
    }

    private void storeCls(Cls cls, Set set) {
        if (this.shouldPrintFrame(cls)) {
            this.beginInstance("class", cls);
            this.indent();
            this.printFrameValues("superclass", cls.getDirectSuperclasses());
            this.printFrameValues("template_slot", cls.getDirectTemplateSlots());
            this.printTemplateFacetValues(cls);
            this.unindent();
            this.endInstance("class", cls);
        }
        set.add(cls);
        this.storeSubclasses(cls, set);
    }

    private boolean shouldPrintFrame(Frame frame) {
        boolean bl = this.activeFrames.contains(frame);
        if (frame.getName().equals("label")) {
            Log.getLogger().info("label: " + bl);
        }
        if (bl) {
            bl = false;
            for (Slot slot : frame.getOwnSlots()) {
                if (!this.shouldStoreSlot(slot)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean shouldStoreSlot(Slot slot) {
        return !this.excludeSlots.contains(slot);
    }

    private void storeSubclasses(Cls cls, Set set) {
        for (Cls cls2 : cls.getDirectSubclasses()) {
            if (set.contains(cls2)) continue;
            this.storeCls(cls2, set);
        }
    }

    private void printTemplateFacetValues(Cls cls) {
        for (Slot slot : cls.getTemplateSlots()) {
            this.printTemplateFacetValues(cls, slot);
        }
    }

    private void printTemplateFacetValues(Cls cls, Slot slot) {
        for (Facet facet : cls.getTemplateFacets(slot)) {
            List list = cls.getDirectTemplateFacetValues(slot, facet);
            if (list.isEmpty()) continue;
            this.printTemplateFacetValues(slot, facet, list);
        }
    }

    private void printTemplateFacetValues(Slot slot, Facet facet, Collection collection) {
        this.printStartTag("template_facet_value");
        this.indent();
        this.printFrameReference("slot_reference", slot);
        this.printFrameReference("facet_reference", facet);
        this.printValues(collection);
        this.unindent();
        this.printEndTag("template_facet_value");
    }

    private void storeSlot(Slot slot) {
        if (this.shouldPrintFrame(slot)) {
            this.beginInstance("slot", slot);
            this.printFrameValues("superslot", slot.getDirectSuperslots());
            this.endInstance("slot", slot);
        }
    }

    private void storeFacet(Facet facet) {
        if (this.shouldPrintFrame(facet)) {
            this.beginInstance("facet", facet);
            this.endInstance("facet", facet);
        }
    }

    private void storeSimpleInstance(SimpleInstance simpleInstance) {
        if (this.shouldPrintFrame(simpleInstance)) {
            this.beginInstance("simple_instance", simpleInstance);
            this.endInstance("simple_instance", simpleInstance);
        }
    }
}

