/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.logging.Level;

public abstract class ExclusiveRunnable
implements Runnable {
    private boolean running = false;
    private boolean aborted = false;
    private Object lock = new Object();

    public abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            this.waitForShutdown();
            this.running = true;
            this.aborted = false;
            this.lock.notifyAll();
        }
        this.execute();
        object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStartup() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.running) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.getLogger().log(Level.WARNING, "Unexpected interrupt", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        Object object = this.lock;
        synchronized (object) {
            while (this.running) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.getLogger().log(Level.WARNING, "Unexpected interrupt", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.lock;
        synchronized (object) {
            this.aborted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAborted() {
        Object object = this.lock;
        synchronized (object) {
            return this.aborted;
        }
    }
}

