/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import java.util.Collection;

public class InstanceNameWidget
extends TextFieldWidget {
    private static final long serialVersionUID = -1873474195346387238L;

    public void addNotify() {
        super.addNotify();
        if (this.isRuntime() && this.needsNameChange()) {
            this.selectAll();
        }
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":NAME");
    }

    private boolean needsNameChange() {
        if (this.getInstance() == null) {
            return false;
        }
        boolean bl = false;
        String string = this.getInstance().getName();
        if (this.isEditable() && string != null) {
            int n = string.lastIndexOf(95);
            String string2 = string.substring(n + 1);
            try {
                Integer.parseInt(string2);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public void setAssociatedCls(Cls cls) {
        super.setAssociatedCls(cls);
        if (cls != null) {
            this.setEditable(false);
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl && !this.isSlotAtCls());
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (this.needsNameChange()) {
            this.selectAll();
        }
    }

    public void setInstanceValues() {
        Collection collection = this.getValues();
        if (collection == null) {
            throw new IllegalArgumentException("Illegal null value for frame");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Missing name for class");
        }
        if (collection.size() > 1) {
            throw new IllegalArgumentException("Too many names for frame " + collection.size());
        }
        if (!(collection.iterator().next() instanceof String)) {
            throw new IllegalArgumentException("name should be a string");
        }
        String string = (String)collection.iterator().next();
        Instance instance = this.getInstance();
        if (instance.getName().equals(string)) {
            return;
        }
        instance.rename(string);
        this.markDirty(false);
    }

    protected String getInvalidTextDescription(String string) {
        String string2 = null;
        if (string == null || !this.isValidName(string)) {
            string2 = "Invalid frame name";
        }
        return string2;
    }

    private boolean isValidName(String string) {
        Instance instance = this.getInstance();
        Frame frame = this.getKnowledgeBase().getFrame(string);
        boolean bl = frame != null && !frame.equals(instance);
        boolean bl2 = this.getKnowledgeBase().isValidFrameName(string, instance);
        return bl2 && !bl && string.length() > 0;
    }

    public void setWidgetValues() {
        if (this.isSlotAtCls()) {
            this.setText(this.getInstance().getName());
        } else {
            super.setWidgetValues();
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Name", ResourceKey.NAME_SLOT_WIDGET_LABEL);
    }
}

