/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectTemplateSlotCommand
extends AbstractCommand {
    private Slot slot;
    private Cls cls;
    private int index;
    private int oldIndex;

    MoveDirectTemplateSlotCommand(FrameStore frameStore, Slot slot, Cls cls, int n) {
        super(frameStore);
        this.slot = slot;
        this.cls = cls;
        this.index = n;
        this.setDescription("Move template slot " + MoveDirectTemplateSlotCommand.getText(slot) + " to index " + n);
    }

    public Object doIt() {
        this.oldIndex = this.getDelegate().getDirectTemplateSlots(this.cls).indexOf(this.slot);
        this.getDelegate().moveDirectTemplateSlot(this.cls, this.slot, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectTemplateSlot(this.cls, this.slot, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectTemplateSlot(this.cls, this.slot, this.index);
    }
}

