/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.admin.ControlServerPanel;
import edu.stanford.smi.protege.server.admin.MetaprojectPanel;
import edu.stanford.smi.protege.server.admin.ProjectsServerPanel;
import edu.stanford.smi.protege.server.admin.SessionServerPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ServerAdminPanel
extends JPanel
implements Disposable {
    private static final long serialVersionUID = -8915505640982212662L;
    private RemoteServer server;
    private RemoteSession session;
    private JTabbedPane tabbedPane;
    private Thread shutdownHook;

    public ServerAdminPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        this.server = remoteServer;
        this.session = remoteSession;
        this.initializeUI();
        this.installShutdownHook();
    }

    public void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 600));
        this.tabbedPane = ComponentFactory.createTabbedPane(true);
        if (this.server != null) {
            this.tabbedPane.addTab("Projects", this.createProjectsTab());
            this.tabbedPane.addTab("Sessions", this.createSessionsTab());
            this.tabbedPane.addTab("Metaproject", this.createMetaProjectTab());
            this.tabbedPane.addTab("Server Control", this.createControlTab());
        }
        this.add(this.tabbedPane);
    }

    private JPanel createSessionsTab() {
        return new SessionServerPanel(this.server, this.session);
    }

    private JPanel createProjectsTab() {
        return new ProjectsServerPanel(this.server, this.session);
    }

    private JPanel createControlTab() {
        return new ControlServerPanel(this.server, this.session);
    }

    private JPanel createMetaProjectTab() {
        return new MetaprojectPanel(this.server, this.session);
    }

    private void installShutdownHook() {
        this.shutdownHook = new Thread("Remote Project ShutdownHook"){

            public void run() {
                try {
                    ServerAdminPanel.this.server.closeSession(ServerAdminPanel.this.session);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Unable to install shutdown hook", exception);
        }
    }

    private void uninstallShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Unable to remove shutdown hook", exception);
        }
    }

    public void dispose() {
        try {
            this.server.closeSession(this.session);
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.INFO, "Exception caught", throwable);
        }
        this.uninstallShutdownHook();
    }
}

