/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyControlledObjectImpl;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.io.File;
import java.io.Serializable;

public class ProjectInstanceImpl
extends PolicyControlledObjectImpl
implements ProjectInstance,
Serializable {
    private static final long serialVersionUID = 8666270295698053695L;
    String location;

    protected ProjectInstanceImpl(MetaProjectImpl metaProjectImpl, Instance instance) {
        super(metaProjectImpl, instance, MetaProjectImpl.ClsEnum.Project);
        if (instance != null) {
            this.location = (String)instance.getOwnSlotValue(metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.location));
        }
        ProjectInstanceImpl.localizeLocation(this.location);
    }

    public String getLocation() {
        return this.location;
    }

    private static String localizeLocation(String string) {
        if (string == null) {
            return null;
        }
        if (File.separatorChar != '\\') {
            string = string.replace('\\', File.separatorChar);
        }
        return string;
    }

    public ProjectInstance getAnnotationProject() {
        return (ProjectInstance)this.getSlotValue(MetaProjectImpl.SlotEnum.annotationProject, MetaProjectImpl.ClsEnum.Project);
    }

    public void setLocation(String string) {
        this.location = string;
        this.setSlotValue(MetaProjectImpl.SlotEnum.location, string);
    }

    public User getOwner() {
        return (User)this.getSlotValue(MetaProjectImpl.SlotEnum.owner, MetaProjectImpl.ClsEnum.User);
    }

    public void setAnnotationProject(ProjectInstance projectInstance) {
        Project project = this.getProtegeInstance().getProject();
        Slot slot = project.getKnowledgeBase().getSlot(MetaProjectImpl.SlotEnum.annotationProject.name());
        if (slot == null) {
            slot = project.getKnowledgeBase().createSlot(MetaProjectImpl.SlotEnum.annotationProject.name());
            slot.setValueType(ValueType.INSTANCE);
            slot.setAllowedClses(CollectionUtilities.createCollection(project.getKnowledgeBase().getCls(MetaProjectImpl.ClsEnum.Project.name())));
        }
        this.setSlotValue(MetaProjectImpl.SlotEnum.annotationProject, projectInstance);
    }

    public void setOwner(User user) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.owner, user);
    }
}

