/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractBackendExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.storage.clips.ClipsExportToNewFormatWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class ClipsFilesExportProjectPlugin
extends AbstractBackendExportPlugin
implements ClipsFilesPlugin {
    private String clsesFileName;
    private String instancesFileName;

    public ClipsFilesExportProjectPlugin() {
        super(ClipsKnowledgeBaseFactory.DESCRIPTION);
    }

    public boolean canExport(Project project) {
        return true;
    }

    public boolean canExportToNewFormat(Project project) {
        return this.canExport(project);
    }

    public WizardPage createExportWizardPage(ExportWizard exportWizard, Project project) {
        return new ClipsFilesWizardPage(exportWizard, this);
    }

    public WizardPage createExportToNewFormatWizardPage(ExportWizard exportWizard, Project project) {
        return new ClipsExportToNewFormatWizardPage(exportWizard, project, this);
    }

    protected void overwriteDomainInformation(Project project, Collection collection) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        new ClipsKnowledgeBaseFactory().saveKnowledgeBase(knowledgeBase, this.clsesFileName, this.instancesFileName, collection);
    }

    protected void initializeSources(Project project, Collection collection) {
        PropertyList propertyList = project.getSources();
        project.setKnowledgeBaseFactory(new ClipsKnowledgeBaseFactory());
        ClipsKnowledgeBaseFactory.setSourceFiles(propertyList, this.clsesFileName, this.instancesFileName);
    }

    public void setFiles(String string, String string2) {
        this.clsesFileName = string;
        this.instancesFileName = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProject(Project project) {
        Writer writer = null;
        Writer writer2 = null;
        try {
            ArrayList arrayList = new ArrayList();
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            ClipsKnowledgeBaseFactory clipsKnowledgeBaseFactory = new ClipsKnowledgeBaseFactory();
            writer = FileUtilities.getWriter(this.clsesFileName);
            writer2 = FileUtilities.getWriter(this.instancesFileName);
            clipsKnowledgeBaseFactory.saveKnowledgeBase(knowledgeBase, writer, writer2, arrayList);
            this.handleErrors(arrayList);
        }
        catch (Throwable throwable) {
            FileUtilities.close(writer);
            FileUtilities.close(writer2);
            throw throwable;
        }
        FileUtilities.close(writer);
        FileUtilities.close(writer2);
    }
}

