/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class HeaderComponent
extends JPanel {
    private static final long serialVersionUID = 6410242403360276543L;
    private JComponent component;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JLabel componentLabel;
    private JToolBar toolBar = ComponentFactory.createToolBar();

    public HeaderComponent(JComponent jComponent) {
        this("", "", jComponent);
    }

    public HeaderComponent(String string, String string2, JComponent jComponent) {
        this.component = jComponent;
        this.setLayout(new BorderLayout());
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setBackground(Colors.getClsColor());
        this.titleLabel = ComponentFactory.createTitleFontLabel(string.toUpperCase());
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.titlePanel.add(this.titleLabel);
        this.add((Component)this.titlePanel, "North");
        this.componentLabel = ComponentFactory.createSmallFontLabel("");
        this.componentLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.componentLabel, "West");
        jPanel.add((Component)jComponent, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)this.toolBar, "East");
        this.setComponentLabel(string2);
    }

    public JButton addButton(Action action) {
        return ComponentFactory.addToolBarButton(this.toolBar, action);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JToggleButton addToggleButton(Action action) {
        return ComponentFactory.addToggleToolBarButton(this.toolBar, action);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setTitle(String string) {
        this.setTitle(string, true);
    }

    public void setTitle(String string, boolean bl) {
        this.titleLabel.setText(bl ? string.toUpperCase() : string);
    }

    public void setComponentLabel(String string) {
        this.componentLabel.setText(string);
    }

    public void setColor(Color color) {
        this.titlePanel.setBackground(color);
    }
}

