/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.IntegerField;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MinimumCardinalityWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -28100150611436999L;
    private JCheckBox _isRequiredComponent;
    private IntegerField _atLeastComponent;
    private ActionListener _buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MinimumCardinalityWidget.this._atLeastComponent.removeActionListener(MinimumCardinalityWidget.this._textFieldListener);
            if (MinimumCardinalityWidget.this._isRequiredComponent.isSelected()) {
                MinimumCardinalityWidget.this._atLeastComponent.setValue(1);
            } else {
                MinimumCardinalityWidget.this._atLeastComponent.clearValue();
            }
            MinimumCardinalityWidget.this._atLeastComponent.addActionListener(MinimumCardinalityWidget.this._textFieldListener);
            MinimumCardinalityWidget.this.valueChanged();
        }
    };
    private ActionListener _textFieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Integer n = MinimumCardinalityWidget.this._atLeastComponent.getValue();
            boolean bl = n == null || n == 0;
            MinimumCardinalityWidget.this._isRequiredComponent.removeActionListener(MinimumCardinalityWidget.this._buttonListener);
            MinimumCardinalityWidget.this._isRequiredComponent.setSelected(!bl);
            MinimumCardinalityWidget.this._isRequiredComponent.addActionListener(MinimumCardinalityWidget.this._buttonListener);
            MinimumCardinalityWidget.this.valueChanged();
        }
    };

    private Component createAtLeastComponent() {
        String string = LocalizedText.getText(ResourceKey.AT_LEAST_LABEL);
        this._atLeastComponent = new IntegerField(string);
        this._atLeastComponent.addActionListener(this._textFieldListener);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.add(this._atLeastComponent);
        return jPanel;
    }

    private JComponent createIsRequiredComponent() {
        String string = LocalizedText.getText(ResourceKey.REQUIRED_LABEL);
        this._isRequiredComponent = ComponentFactory.createCheckBox(string);
        this._isRequiredComponent.addActionListener(this._buttonListener);
        return this._isRequiredComponent;
    }

    public Collection getValues() {
        Integer n = this._atLeastComponent.getValue();
        return CollectionUtilities.createCollection(n);
    }

    public void initialize() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.createIsRequiredComponent());
        jPanel.add(this.createAtLeastComponent());
        this.add(new LabeledComponent(this.getLabel(), jPanel, false));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-MINIMUM-CARDINALITY");
    }

    public void setEditable(boolean bl) {
        this._isRequiredComponent.setEnabled(bl);
        this._atLeastComponent.setEnabled(bl);
    }

    public void setValues(Collection collection) {
        Integer n = (Integer)MinimumCardinalityWidget.getFirstItem(collection);
        boolean bl = n != null && n > 0;
        this._isRequiredComponent.setSelected(bl);
        if (bl) {
            this._atLeastComponent.setValue(n);
        } else {
            this._atLeastComponent.clearValue();
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Cardinality", ResourceKey.MINIMUM_CARDINALITY_SLOT_WIDGET_LABEL);
    }
}

