/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.plugin.DefaultCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.PickCreateProjectPluginPage;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.ui.FactoryRenderer;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectProjectTypeWizardPage
extends WizardPage {
    private static final long serialVersionUID = -8843058597898410690L;
    private static final String SELECTED_FACTORY = "select_project_type.last_factory";
    private JCheckBox doBuildBox;
    private SelectableList list;
    private CreateProjectPlugin plugin;

    SelectProjectTypeWizardPage(CreateProjectWizard createProjectWizard) {
        super("select project type", createProjectWizard);
        JLabel jLabel = ComponentFactory.createSmallFontLabel("Select a Project Type:");
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        this.list = this.createList();
        jPanel.add((Component)new JScrollPane(this.list), "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.configureCheckBox();
        this.add((Component)jPanel, "Center");
        this.add((Component)this.doBuildBox, "North");
    }

    private SelectableList createList() {
        KnowledgeBaseFactory knowledgeBaseFactory = null;
        String string = ApplicationProperties.getString(SELECTED_FACTORY);
        Collection<KnowledgeBaseFactory> collection = PluginUtilities.getAvailableFactories();
        for (KnowledgeBaseFactory knowledgeBaseFactory2 : collection) {
            if (!knowledgeBaseFactory2.getClass().getName().equals(string)) continue;
            knowledgeBaseFactory = knowledgeBaseFactory2;
        }
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setModel(new SimpleListModel(collection));
        this.list.setCellRenderer(new FactoryRenderer());
        if (knowledgeBaseFactory == null) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedValue(knowledgeBaseFactory);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SelectProjectTypeWizardPage.this.updateNextPage();
                SelectProjectTypeWizardPage.this.updateDoBuildBox();
            }
        });
        return this.list;
    }

    private void configureCheckBox() {
        StandardAction standardAction = new StandardAction("Create from Existing Sources"){
            private static final long serialVersionUID = 3873947894902634872L;

            public void actionPerformed(ActionEvent actionEvent) {
                SelectProjectTypeWizardPage.this.updateNextPage();
            }
        };
        standardAction.setMnemonic(67);
        this.doBuildBox = new JCheckBox(standardAction);
    }

    public KnowledgeBaseFactory getSelectedFactory() {
        KnowledgeBaseFactory knowledgeBaseFactory = (KnowledgeBaseFactory)this.list.getSelectedValue();
        if (knowledgeBaseFactory != null) {
            ApplicationProperties.setString(SELECTED_FACTORY, knowledgeBaseFactory.getClass().getName());
        }
        return knowledgeBaseFactory;
    }

    private CreateProjectWizard getCreateProjectWizard() {
        return (CreateProjectWizard)this.getWizard();
    }

    private void updateDoBuildBox() {
        Collection collection = SelectProjectTypeWizardPage.getAppropriateCreateProjectPlugins(this.getSelectedFactory(), this.getUseExistingSources());
        if (collection.size() == 0) {
            this.doBuildBox.setSelected(false);
            this.doBuildBox.setEnabled(false);
        } else {
            this.doBuildBox.setEnabled(true);
        }
    }

    private boolean getUseExistingSources() {
        return this.doBuildBox.isSelected();
    }

    public void onFinish() {
        if (this.plugin != null) {
            this.plugin.setKnowledgeBaseFactory(this.getSelectedFactory());
            this.plugin.setUseExistingSources(this.getUseExistingSources());
            this.getCreateProjectWizard().setPlugin(this.plugin);
        }
    }

    public WizardPage getNextPage() {
        WizardPage wizardPage = null;
        Collection collection = SelectProjectTypeWizardPage.getAppropriateCreateProjectPlugins(this.getSelectedFactory(), this.getUseExistingSources());
        if (collection.size() == 0) {
            this.plugin = new DefaultCreateProjectPlugin();
        } else if (collection.size() == 1) {
            this.plugin = (CreateProjectPlugin)collection.iterator().next();
            wizardPage = this.plugin.createCreateProjectWizardPage(this.getCreateProjectWizard(), this.getUseExistingSources());
        } else {
            this.plugin = null;
            wizardPage = new PickCreateProjectPluginPage(collection, this.getSelectedFactory(), this.getWizard());
        }
        return wizardPage;
    }

    private static Collection getAppropriateCreateProjectPlugins(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        ArrayList<CreateProjectPlugin> arrayList = new ArrayList<CreateProjectPlugin>();
        for (String string : PluginUtilities.getAvailableCreateProjectPluginClassNames()) {
            CreateProjectPlugin createProjectPlugin = (CreateProjectPlugin)SystemUtilities.newInstance(string);
            if (!createProjectPlugin.canCreateProject(knowledgeBaseFactory, bl)) continue;
            arrayList.add(createProjectPlugin);
        }
        return arrayList;
    }
}

