/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class ClsClsReferenceNode
extends LazyTreeNode {
    private Slot _slot;

    public ClsClsReferenceNode(LazyTreeNode lazyTreeNode, Cls cls, Slot slot) {
        super(lazyTreeNode, cls);
        this._slot = slot;
    }

    private static void addClsReferences(Cls cls, Slot slot, Collection collection) {
        ValueType valueType = cls.getTemplateSlotValueType(slot);
        if (ClsClsReferenceNode.equals(valueType, ValueType.INSTANCE)) {
            collection.addAll(cls.getTemplateSlotAllowedClses(slot));
        } else if (ClsClsReferenceNode.equals(valueType, ValueType.CLS)) {
            collection.addAll(cls.getTemplateSlotAllowedParents(slot));
        }
    }

    public LazyTreeNode createNode(Object object) {
        return new ClsClsReferenceNode((LazyTreeNode)this, (Cls)object, this._slot);
    }

    public int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public Collection getChildObjects() {
        HashSet hashSet = new HashSet();
        Cls cls = (Cls)this.getUserObject();
        if (this._slot == null) {
            for (Slot slot : cls.getTemplateSlots()) {
                ClsClsReferenceNode.addClsReferences(cls, slot, hashSet);
            }
        } else if (cls.hasTemplateSlot(this._slot)) {
            ClsClsReferenceNode.addClsReferences(cls, this._slot, hashSet);
        }
        return hashSet;
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }
}

