/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class SelectClsesPanel
extends JComponent
implements Validatable {
    private static final long serialVersionUID = 4752775085919596616L;
    private JTree _tree;
    private boolean _allowsMultiple;

    public SelectClsesPanel(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, Collections.EMPTY_SET);
    }

    public SelectClsesPanel(KnowledgeBase knowledgeBase, DefaultRenderer defaultRenderer) {
        this(knowledgeBase, Collections.EMPTY_SET);
        this._tree.setCellRenderer(defaultRenderer);
    }

    public SelectClsesPanel(KnowledgeBase knowledgeBase, Collection collection) {
        this(knowledgeBase, collection, true);
    }

    public SelectClsesPanel(KnowledgeBase knowledgeBase, Collection collection, boolean bl) {
        this._allowsMultiple = bl;
        if (collection.isEmpty()) {
            collection = knowledgeBase.getRootClses();
        }
        this._tree = ComponentFactory.createSelectableTree(ModalDialog.getCloseAction(this), new ParentChildRoot(collection));
        this._tree.setCellRenderer(FrameRenderer.createInstance());
        int n = this._tree.getRowCount();
        int n2 = n - collection.size();
        for (int i = n - 1; i > n2; --i) {
            this._tree.expandRow(i);
        }
        this._tree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this._tree), "Center");
        this.add((Component)new ClsTreeFinder(knowledgeBase, this._tree), "South");
        this.setPreferredSize(new Dimension(300, 300));
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._tree);
    }

    public boolean validateContents() {
        boolean bl;
        boolean bl2 = bl = this._allowsMultiple || this.getSelection().size() <= 1;
        if (!bl) {
            ModalDialog.showMessageDialog((Component)this, "Only 1 class can be selected", 14);
        }
        return bl;
    }

    public void saveContents() {
    }
}

