/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.DigestAndSalt;
import edu.stanford.smi.protege.util.Html2Text;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringUtilities {
    private static Logger log = Log.getLogger(StringUtilities.class);
    private static Random random = new Random();
    private static final char SINGLE_QUOTE = '\'';

    public static String capitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
            } else if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) != -1) {
            stringBuffer.append(string.substring(n3, n));
            stringBuffer.append(string3);
            n3 = n + n2;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    public static String symbolToLabel(String string) {
        String string2 = string.replace('_', ' ');
        string2 = StringUtilities.capitalize(string2);
        return string2;
    }

    public static String commaSeparatedList(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection == null) {
            return "(empty)";
        }
        for (Object e : collection) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public static String getShortClassName(String string) {
        int n = string.lastIndexOf(46) + 1;
        return string.substring(n);
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        return StringUtilities.getShortClassName(string);
    }

    public static String getClassName(Object object) {
        return StringUtilities.getClassName(object.getClass());
    }

    public static String stripHtmlTags(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        StringReader stringReader = new StringReader(string);
        Html2Text html2Text = new Html2Text();
        try {
            html2Text.parse(stringReader);
            string2 = html2Text.getText();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.WARNING, "Error at converting html to text", iOException);
        }
        stringReader.close();
        return string2;
    }

    public static String getFriendlyName(Frame frame) {
        String string = frame.getName();
        try {
            string = frame.getBrowserText();
        }
        catch (Throwable throwable) {
            Log.emptyCatchBlock(throwable);
        }
        return string;
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        stringBuffer.append(string);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static String unquote(String string) {
        if (string.length() > 0 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeAllQuotes(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.replaceAll("'", "");
        }
        return string;
    }

    public static DigestAndSalt makeDigest(String string) {
        byte[] byArray = new byte[8];
        random.nextBytes(byArray);
        String string2 = StringUtilities.encodeBytes(byArray);
        return StringUtilities.makeDigest(string, string2);
    }

    public static DigestAndSalt makeDigest(String string, String string2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.severe("Did not have MD5 algorithm");
            throw new RuntimeException("Did not have MD5 algorithm");
        }
        messageDigest.update(string2.getBytes());
        messageDigest.update(string.getBytes());
        String string3 = StringUtilities.encodeBytes(messageDigest.digest());
        return new DigestAndSalt(string3, string2);
    }

    private static String encodeBytes(byte[] byArray) {
        int n = 2 * byArray.length;
        BigInteger bigInteger = new BigInteger(1, byArray);
        String string = bigInteger.toString(16);
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }
}

