/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.PropertyValue;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.DigestAndSalt;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserImpl
extends WrappedProtegeInstanceImpl
implements User,
Serializable {
    private static final long serialVersionUID = -4416984896523630762L;
    private static final Logger log = Log.getLogger(UserImpl.class);
    private String name;

    protected UserImpl(MetaProjectImpl metaProjectImpl, Instance instance) {
        super(metaProjectImpl, instance, MetaProjectImpl.ClsEnum.User);
        this.name = (String)instance.getOwnSlotValue(metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.name));
    }

    @Override
    public String getDescription() {
        Object object = this.getProtegeInstance().getOwnSlotValue(this.getMetaProject().getSlot(MetaProjectImpl.SlotEnum.description));
        if (!(object instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.name) + " slot should take on string values");
        }
        return (String)object;
    }

    @Override
    public Set<Group> getGroups() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.group, MetaProjectImpl.ClsEnum.Group);
    }

    @Override
    public Date getLastAccess() {
        Object object = this.getSlotValue(MetaProjectImpl.SlotEnum.lastAccess, null);
        if (object != null && !(object instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.lastAccess) + " slot should take on string values");
        }
        return UserImpl.parseDate((String)object);
    }

    @Override
    public Date getLastLogin() {
        Object object = this.getSlotValue(MetaProjectImpl.SlotEnum.lastLogin, null);
        if (object != null && !(object instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.lastLogin) + " slot should take on string values");
        }
        return UserImpl.parseDate((String)object);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String string) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.description, string);
    }

    @Override
    public void setLastAccess(Date date) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.lastAccess, new Long(date.getTime()).toString());
    }

    @Override
    public void setLastLogin(Date date) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.lastLogin, new Long(date.getTime()).toString());
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.setSlotValue(MetaProjectImpl.SlotEnum.name, string);
    }

    @Override
    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        DigestAndSalt digestAndSalt = StringUtilities.makeDigest(string);
        this.setSlotValue(MetaProjectImpl.SlotEnum.salt, digestAndSalt.getSalt());
        this.setSlotValue(MetaProjectImpl.SlotEnum.password, digestAndSalt.getDigest());
    }

    @Override
    public boolean verifyPassword(String string) {
        if (string == null) {
            string = "";
        }
        DigestAndSalt digestAndSalt = StringUtilities.makeDigest(string, (String)this.getSlotValue(MetaProjectImpl.SlotEnum.salt, null));
        return digestAndSalt.getDigest().equals(this.getSlotValue(MetaProjectImpl.SlotEnum.password, null));
    }

    @Override
    public String getEmail() {
        return (String)this.getSlotValue(MetaProjectImpl.SlotEnum.email, null);
    }

    @Override
    public void setEmail(String string) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.email, string);
    }

    public Set<PropertyValue> getPropertyValues() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.properties, MetaProjectImpl.ClsEnum.PropertyValue);
    }

    @Override
    public void setPropertyValues(Collection<PropertyValue> collection) {
        this.setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum.properties, collection);
    }

    @Override
    public void addPropertyValue(PropertyValue propertyValue) {
        this.addSlotValue(MetaProjectImpl.SlotEnum.properties, propertyValue);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.name.equals(user.getName());
    }

    @Override
    public int hashCode() {
        return this.name == null ? 42 : this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }

    private static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

