/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplaySlotRenderer;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.MultiSlotPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SetDisplaySlotPanel
extends JComponent
implements Disposable {
    private static final String MULTISLOT = "Multiple Slots";
    private JComboBox _displaySlotComboBox;
    private Cls _cls;
    private BrowserSlotPattern _currentPattern;
    private ActionListener _actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SetDisplaySlotPanel.this._cls != null) {
                Object object = SetDisplaySlotPanel.this._displaySlotComboBox.getSelectedItem();
                if (SetDisplaySlotPanel.MULTISLOT.equals(object)) {
                    SetDisplaySlotPanel.this.setMultiSlotPattern();
                } else {
                    BrowserSlotPattern browserSlotPattern = (BrowserSlotPattern)SetDisplaySlotPanel.this._displaySlotComboBox.getSelectedItem();
                    SetDisplaySlotPanel.this._cls.setDirectBrowserSlotPattern(browserSlotPattern);
                }
            }
        }
    };
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent clsEvent) {
            SetDisplaySlotPanel.this.reload();
        }

        public void directSuperclassRemoved(ClsEvent clsEvent) {
            SetDisplaySlotPanel.this.reload();
        }

        public void templateSlotAdded(ClsEvent clsEvent) {
            SetDisplaySlotPanel.this.reload();
        }

        public void templateSlotRemoved(ClsEvent clsEvent) {
            SetDisplaySlotPanel.this.reload();
        }
    };

    public SetDisplaySlotPanel() {
        this.createComponents();
        this.layoutComponents();
    }

    public void setCls(Cls cls) {
        if (this._cls != null) {
            this._cls.removeClsListener(this._clsListener);
        }
        this._cls = cls;
        if (this._cls != null) {
            this._cls.addClsListener(this._clsListener);
        }
        this._displaySlotComboBox.setRenderer(new DisplaySlotRenderer(cls));
        this.reload();
    }

    public void dispose() {
        if (this._cls != null) {
            this._cls.removeClsListener(this._clsListener);
        }
    }

    private void layoutComponents() {
        this.setLayout(new FlowLayout(0, 3, 0));
        String string = LocalizedText.getText(ResourceKey.FORM_EDITOR_DISPLAY_SLOT_LABEL);
        this.add(ComponentFactory.createSmallFontLabel(string));
        this.add(this._displaySlotComboBox);
        Dimension dimension = this._displaySlotComboBox.getPreferredSize();
        dimension.width = 250;
        this._displaySlotComboBox.setPreferredSize(dimension);
    }

    private void createComponents() {
        this.createDisplaySlotComboBox();
    }

    private void createDisplaySlotComboBox() {
        this._displaySlotComboBox = ComponentFactory.createComboBox();
        this._displaySlotComboBox.addActionListener(this._actionListener);
    }

    private void reload() {
        Object object;
        this._currentPattern = null;
        boolean bl = this._cls != null;
        BrowserSlotPattern browserSlotPattern = this._cls == null ? null : this._cls.getBrowserSlotPattern();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            Slot slot;
            object = this._cls.getVisibleTemplateSlots();
            if (!object.contains(slot = this._cls.getKnowledgeBase().getNameSlot())) {
                object.add(slot);
            }
            Collections.sort((List)object, new FrameComparator());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Slot slot2 = (Slot)iterator.next();
                BrowserSlotPattern browserSlotPattern2 = new BrowserSlotPattern(slot2);
                arrayList.add(browserSlotPattern2);
            }
            if (browserSlotPattern != null && !arrayList.contains(browserSlotPattern)) {
                arrayList.add(browserSlotPattern);
            }
            if (object.size() > 0) {
                arrayList.add(MULTISLOT);
            }
        }
        object = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._displaySlotComboBox.removeActionListener(this._actionListener);
        this._displaySlotComboBox.setModel(object);
        this._displaySlotComboBox.setSelectedItem(browserSlotPattern);
        this._displaySlotComboBox.addActionListener(this._actionListener);
        this.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        this._displaySlotComboBox.setEnabled(bl);
    }

    private void setMultiSlotPattern() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SetDisplaySlotPanel.this.acquireMultiSlotPattern();
            }
        });
    }

    private void acquireMultiSlotPattern() {
        BrowserSlotPattern browserSlotPattern;
        MultiSlotPanel multiSlotPanel = new MultiSlotPanel(this._currentPattern, this._cls);
        int n = ModalDialog.showDialog(this, multiSlotPanel, "Multislot Display Pattern", 11);
        if (n == 1 && (browserSlotPattern = multiSlotPanel.getBrowserTextPattern()) != null) {
            this._cls.setDirectBrowserSlotPattern(browserSlotPattern);
            this.reload();
            this._currentPattern = browserSlotPattern;
            this._displaySlotComboBox.setSelectedItem(browserSlotPattern);
        }
    }
}

