/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectFixupPlugin;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFixupsPluginManager {
    private static final String PROJECT_FIXUP_PLUGIN = "ProjectFixupPlugin";
    private static final String IS_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class<?>[] IS_SUITABLE_METHOD_ARGS = new Class[]{KnowledgeBase.class, Collection.class};

    public static Collection<Class> getAvailableProjectFixupPluginClasses() {
        return PluginUtilities.getClassesWithAttribute(PROJECT_FIXUP_PLUGIN, "True");
    }

    public static Collection<ProjectFixupPlugin> getAvailableProjectFixupPlugins() {
        ArrayList<ProjectFixupPlugin> arrayList = new ArrayList<ProjectFixupPlugin>();
        for (Class clazz : ProjectFixupsPluginManager.getAvailableProjectFixupPluginClasses()) {
            ProjectFixupPlugin projectFixupPlugin = (ProjectFixupPlugin)SystemUtilities.newInstance(clazz);
            if (projectFixupPlugin == null) continue;
            arrayList.add(projectFixupPlugin);
        }
        return arrayList;
    }

    private static boolean isSuitable(KnowledgeBase knowledgeBase, Class clazz) {
        boolean bl;
        try {
            ArrayList arrayList = new ArrayList();
            Method method = clazz.getMethod(IS_SUITABLE_METHOD_NAME, IS_SUITABLE_METHOD_ARGS);
            Boolean bl2 = (Boolean)method.invoke((Object)clazz, knowledgeBase, arrayList);
            bl = bl2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Log.getLogger().warning(exception.getMessage());
        }
        return bl;
    }

    public static void fixProject(KnowledgeBase knowledgeBase) {
        for (ProjectFixupPlugin projectFixupPlugin : ProjectFixupsPluginManager.getAvailableProjectFixupPlugins()) {
            if (projectFixupPlugin == null) continue;
            try {
                if (!ProjectFixupsPluginManager.isSuitable(knowledgeBase, projectFixupPlugin.getClass())) continue;
                projectFixupPlugin.fixProject(knowledgeBase);
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.WARNING, "Error at applying project fix up " + projectFixupPlugin.getName(), throwable);
            }
        }
    }
}

